/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.occi;

import java.util.concurrent.TimeUnit;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.vomanagement.occi.datamodel.cloud.OSTemplate;

public class TemplatesCache {
    private static final int CACHE_SIZE = 100;
    private static final int CACHE_TTL = 864000;
    private static TemplatesCache instance;
    private static Cache<String, OSTemplate> osTemplatesCache;
    private static Cache<String, ResourceTemplate> resourceTemplatesCache;
    private static CacheManager cacheManager;

    public static synchronized TemplatesCache getInstance() {
        if (instance == null) {
            instance = new TemplatesCache();
        }
        return instance;
    }

    public void cache(String providerId, OSTemplate template) {
        osTemplatesCache.put((Object)(providerId + template.getId()), (Object)template);
    }

    public void cache(String providerId, ResourceTemplate template) {
        resourceTemplatesCache.put((Object)(providerId + template.getId()), (Object)template);
    }

    public OSTemplate getOSTemplate(String providerId, String templateId) {
        return (OSTemplate)osTemplatesCache.get((Object)(providerId + templateId));
    }

    public ResourceTemplate getResourceTemplate(String providerId, String tid) {
        return (ResourceTemplate)resourceTemplatesCache.get((Object)(providerId + tid));
    }

    static {
        cacheManager = CacheManagerBuilder.newCacheManagerBuilder().build(true);
        ResourcePoolsBuilder.newResourcePoolsBuilder();
        ResourcePoolsBuilder osTemplateCachePoolBuilder = ResourcePoolsBuilder.heap((long)100L);
        osTemplatesCache = cacheManager.createCache("OS_TEMPLATES", CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, OSTemplate.class, (Builder)osTemplateCachePoolBuilder).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)864000L, (TimeUnit)TimeUnit.SECONDS))).build());
        ResourcePoolsBuilder.newResourcePoolsBuilder();
        ResourcePoolsBuilder resourceTemplateCachePoolBuilder = ResourcePoolsBuilder.heap((long)100L);
        resourceTemplatesCache = cacheManager.createCache("RESOURCE_TEMPLATES", CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, ResourceTemplate.class, (Builder)resourceTemplateCachePoolBuilder).withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)864000L, (TimeUnit)TimeUnit.SECONDS))).build());
    }
}

