/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.occi;

import java.util.HashMap;
import java.util.Map;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.vomanagement.occi.datamodel.cloud.OSTemplate;

public class TemplatesCache {
    private static TemplatesCache instance;
    private Map<String, OSTemplate> osTemplates = new HashMap<String, OSTemplate>();
    private Map<String, ResourceTemplate> resourceTemplates = new HashMap<String, ResourceTemplate>();

    private TemplatesCache() {
    }

    public static synchronized TemplatesCache getInstance() {
        if (instance == null) {
            instance = new TemplatesCache();
        }
        return instance;
    }

    public void cache(String providerId, OSTemplate template) {
        this.osTemplates.put(providerId + template.getId(), template);
    }

    public void cache(String providerId, ResourceTemplate template) {
        this.resourceTemplates.put(providerId + template.getId(), template);
    }

    public OSTemplate getOSTemplate(String providerId, String templateId) {
        return this.osTemplates.get(providerId + templateId);
    }

    public ResourceTemplate getResourceTemplate(String providerId, String tid) {
        return this.resourceTemplates.get(providerId + tid);
    }
}

