/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.occi;

import cz.cesnet.cloud.occi.Model;
import cz.cesnet.cloud.occi.api.Authentication;
import cz.cesnet.cloud.occi.api.Client;
import cz.cesnet.cloud.occi.api.EntityBuilder;
import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import cz.cesnet.cloud.occi.api.exception.EntityBuildingException;
import cz.cesnet.cloud.occi.api.http.HTTPClient;
import cz.cesnet.cloud.occi.api.http.auth.VOMSAuthentication;
import cz.cesnet.cloud.occi.core.ActionInstance;
import cz.cesnet.cloud.occi.core.Entity;
import cz.cesnet.cloud.occi.core.Link;
import cz.cesnet.cloud.occi.core.Mixin;
import cz.cesnet.cloud.occi.core.Resource;
import cz.cesnet.cloud.occi.exception.AmbiguousIdentifierException;
import cz.cesnet.cloud.occi.exception.InvalidAttributeValueException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.DatatypeConverter;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.resources.federation.fhnmanager.api.type.VMProviderCredentials;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.TemplatesCache;
import org.gcube.vomanagement.occi.datamodel.cloud.Network;
import org.gcube.vomanagement.occi.datamodel.cloud.OSTemplate;
import org.gcube.vomanagement.occi.datamodel.cloud.Storage;
import org.gcube.vomanagement.occi.datamodel.cloud.VM;
import org.gcube.vomanagement.occi.datamodel.cloud.VMNetwork;
import org.gcube.vomanagement.occi.datamodel.cloud.VMStorage;
import org.gcube.vomanagement.occi.datamodel.security.Credentials;
import org.gcube.vomanagement.occi.datamodel.security.X509Credentials;
import org.gcube.vomanagement.occi.exceptions.UnsupportedCredentialsTypeException;
import org.gcube.vomanagement.occi.utils.ParseUtil;
import org.gcube.vomanagement.occi.utils.ScriptUtil;

public class OcciConnector
implements FHNConnector {
    private String proxyCertificatePath;
    private String trustStorePath;
    private VMProvider provider;
    private Client client;
    protected EntityBuilder eb;

    public OcciConnector(VMProvider provider) throws UnsupportedCredentialsTypeException {
        this.provider = provider;
        VMProviderCredentials creds = provider.getCredentials();
        if (creds != null) {
            this.setCredentials(creds.getType(), creds.getEncodedCredentails());
        }
    }

    public VMProvider getProvider() {
        return this.provider;
    }

    @Override
    public void connect() throws CommunicationException {
        if (this.client == null) {
            System.out.println("Connecting...");
            this.client = this.createOcciClient(this.proxyCertificatePath, this.trustStorePath);
            this.client.connect();
            System.out.println("Connected: " + this.getProvider().getEndpoint());
            Model model = this.client.getModel();
            this.eb = new EntityBuilder(model);
        }
    }

    private Client createOcciClient(String proxyCertificatePath, String trustStorePath) throws CommunicationException {
        HTTPClient client = null;
        if (proxyCertificatePath != null) {
            VOMSAuthentication authentication = new VOMSAuthentication(proxyCertificatePath);
            authentication.setCAPath(trustStorePath);
            client = new HTTPClient(URI.create(this.getEndpoint()), (Authentication)authentication);
        } else {
            client = new HTTPClient(URI.create(this.getEndpoint()));
        }
        return client;
    }

    public String getEndpoint() {
        return this.provider.getEndpoint();
    }

    private Mixin getMixin(OSTemplate template) {
        return this.client.getModel().findMixin(URI.create(template.getId()));
    }

    private Mixin getMixin(ResourceTemplate template) {
        return this.client.getModel().findMixin(URI.create(template.getId()));
    }

    @Override
    public Collection<OSTemplate> listOSTemplates() throws CommunicationException {
        ArrayList<OSTemplate> out = new ArrayList<OSTemplate>();
        try {
            List mixins = this.client.getModel().findRelatedMixins("os_tpl");
            for (Mixin m : mixins) {
                OSTemplate template = new OSTemplate();
                template.setId(m.getScheme() + m.getTerm());
                template.setName(m.getTitle());
                template = this.enrichWithCached(template);
                out.add(template);
            }
        }
        catch (AmbiguousIdentifierException e) {
            throw new CommunicationException((Throwable)e);
        }
        return out;
    }

    @Override
    public Collection<URI> listOSTemplatesURIs() throws CommunicationException {
        ArrayList<URI> out = new ArrayList<URI>();
        try {
            List mixins = this.client.getModel().findRelatedMixins("os_tpl");
            for (Mixin m : mixins) {
                out.add(m.getLocation());
            }
        }
        catch (AmbiguousIdentifierException e) {
            throw new CommunicationException((Throwable)e);
        }
        return out;
    }

    @Override
    public Collection<URI> listResourceTemplatesURIs() throws CommunicationException {
        ArrayList<URI> out = new ArrayList<URI>();
        try {
            List mixins = this.client.getModel().findRelatedMixins("resource_tpl");
            for (Mixin m : mixins) {
                out.add(m.getLocation());
            }
        }
        catch (AmbiguousIdentifierException e) {
            throw new CommunicationException((Throwable)e);
        }
        return out;
    }

    private OSTemplate enrichWithCached(OSTemplate template) {
        OSTemplate cached = TemplatesCache.getInstance().getOSTemplate(this.getProvider().getEndpoint(), template.getId());
        if (cached != null) {
            template.setDescription(cached.getDescription());
            template.setDiskSize(cached.getDiskSize());
            template.setOs(cached.getOs());
            template.setOsVersion(cached.getOsVersion());
            template.setVersion(cached.getVersion());
        }
        return template;
    }

    @Override
    public OSTemplate getOSTemplate(URI uri) {
        Mixin mixin = this.client.getModel().findMixin(uri);
        OSTemplate template = null;
        if (mixin != null) {
            template = new OSTemplate();
            template.setId(mixin.getScheme() + mixin.getTerm());
            template.setName(mixin.getTitle());
            template = this.enrichWithCached(template);
        }
        return template;
    }

    private ResourceTemplate enrichWithCached(ResourceTemplate template) {
        ResourceTemplate cached = TemplatesCache.getInstance().getResourceTemplate(this.getProvider().getEndpoint(), template.getId());
        if (cached != null) {
            template.setCores(cached.getCores());
            template.setMemory(cached.getMemory());
        }
        return template;
    }

    @Override
    public Collection<ResourceTemplate> listResourceTemplates() throws CommunicationException {
        ArrayList<ResourceTemplate> out = new ArrayList<ResourceTemplate>();
        try {
            List mixins = this.client.getModel().findRelatedMixins("resource_tpl");
            for (Mixin m : mixins) {
                ResourceTemplate template = new ResourceTemplate();
                template.setId(m.getScheme() + m.getTerm());
                template.setName(m.getTitle());
                template = this.enrichWithCached(template);
                out.add(template);
            }
        }
        catch (AmbiguousIdentifierException e) {
            throw new CommunicationException((Throwable)e);
        }
        return out;
    }

    @Override
    public ResourceTemplate getResourceTemplate(URI uri) {
        Mixin mixin = this.client.getModel().findMixin(uri);
        ResourceTemplate template = null;
        if (mixin != null) {
            template = new ResourceTemplate();
            template.setId(mixin.getScheme() + mixin.getTerm());
            template.setName(mixin.getTitle());
            template = this.enrichWithCached(template);
        }
        return template;
    }

    @Override
    public Collection<URI> listVMURIs() throws CommunicationException {
        ArrayList<URI> out = new ArrayList<URI>();
        for (URI uri : this.client.list("compute")) {
            if (uri.toString().isEmpty()) continue;
            out.add(uri);
        }
        return out;
    }

    @Override
    public Collection<VM> listVM() throws CommunicationException {
        ArrayList<VM> out = new ArrayList<VM>();
        for (URI uri : this.listVMURIs()) {
            VM vm;
            if (uri.toString().trim().isEmpty() || (vm = this.getVM(uri)) == null) continue;
            out.add(vm);
        }
        return out;
    }

    private VMNetwork linkToVMNetwork(Link link, URI uri) {
        VMNetwork vmNetwork = new VMNetwork();
        vmNetwork.setId(link.getValue("occi.core.id"));
        vmNetwork.setName(link.getValue("occi.core.title"));
        vmNetwork.setAddress(link.getValue("occi.networkinterface.address"));
        vmNetwork.setInterface(link.getValue("occi.networkinterface.interface"));
        vmNetwork.setMac(link.getValue("occi.networkinterface.mac"));
        vmNetwork.setStatus(link.getValue("occi.networkinterface.state"));
        return vmNetwork;
    }

    private VMStorage linkToVMStorage(Link link, URI uri) {
        VMStorage vmStorage = new VMStorage();
        vmStorage.setId(link.getValue("occi.core.id"));
        vmStorage.setName(link.getValue("occi.core.title"));
        vmStorage.setDeviceId(link.getValue("occi.storagelink.deviceid"));
        vmStorage.setStatus(link.getValue("occi.storagelink.state"));
        return vmStorage;
    }

    private VM entityToVM(Entity entity, URI uri) {
        Double cores;
        VM vm = new VM();
        vm.setProvider(this.getEndpoint());
        vm.setId(entity.getValue("occi.core.id"));
        vm.setName(entity.getValue("occi.core.title"));
        vm.setStatus(entity.getValue("occi.compute.state"));
        vm.setHostname(entity.getValue("occi.compute.hostname"));
        vm.setEndpoint(uri);
        Double memory = ParseUtil.extractDoubleAttribute(entity, "occi.compute.memory");
        if (memory != null) {
            vm.setMemory(Math.round(memory * 1024.0 * 1024.0 * 1024.0));
        }
        if ((cores = ParseUtil.extractDoubleAttribute(entity, "occi.compute.cores")) != null) {
            vm.setCores((int)(1.0 * cores));
        }
        return vm;
    }

    @Override
    public VM getVM(URI uri) {
        VM vm = null;
        try {
            List entities = this.client.describe(uri);
            Iterator iterator = entities.iterator();
            if (iterator.hasNext()) {
                Double cores;
                Entity e = (Entity)iterator.next();
                vm = this.entityToVM(e, uri);
                vm = new VM();
                vm.setProvider(this.getEndpoint());
                vm.setId(e.getValue("occi.core.id"));
                vm.setName(e.getValue("occi.core.title"));
                vm.setStatus(e.getValue("occi.compute.state"));
                vm.setHostname(e.getValue("occi.compute.hostname"));
                vm.setEndpoint(uri);
                Double memory = ParseUtil.extractDoubleAttribute(e, "occi.compute.memory");
                if (memory != null) {
                    vm.setMemory(Math.round(memory * 1024.0 * 1024.0 * 1024.0));
                }
                if ((cores = ParseUtil.extractDoubleAttribute(e, "occi.compute.cores")) != null) {
                    vm.setCores((int)(1.0 * cores));
                }
                if (e instanceof Resource) {
                    Resource resource = (Resource)e;
                    for (Link l : resource.getLinks()) {
                        Object link;
                        String term = l.getKind().getTerm();
                        if ("storagelink".equalsIgnoreCase(term)) {
                            link = this.linkToVMStorage(l, uri);
                            URI storageUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), l.getValue("occi.core.target"), uri.getQuery(), uri.getFragment());
                            Storage storage = this.getStorage(storageUri);
                            ((VMStorage)link).setStorage(storage);
                            vm.addStorage((VMStorage)link);
                            continue;
                        }
                        if (!"networkinterface".equalsIgnoreCase(term)) continue;
                        link = this.linkToVMNetwork(l, uri);
                        URI networkUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), l.getValue("occi.core.target"), uri.getQuery(), uri.getFragment());
                        Network network = this.getNetwork(networkUri);
                        ((VMNetwork)link).setNetwork(network);
                        vm.addNetwork((VMNetwork)link);
                    }
                }
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return vm;
    }

    @Override
    public URI createVM(String vmName, OSTemplate ot, ResourceTemplate rt, File scriptPath) throws CommunicationException {
        String script = null;
        try {
            script = ScriptUtil.getScriptFromFile(scriptPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommunicationException((Throwable)e);
        }
        return this.createVM(vmName, ot, rt, script);
    }

    @Override
    public URI createVM(String vmName, OSTemplate ot, ResourceTemplate rt, String script) throws CommunicationException {
        Mixin osMixin = this.getMixin(ot);
        Mixin resMixin = this.getMixin(rt);
        return this.createComputeResource(vmName, osMixin, resMixin, script);
    }

    @Override
    public URI createVM(String vmName, OSTemplate ot, ResourceTemplate rt, URL scriptURL) throws CommunicationException {
        String script = null;
        try {
            script = ScriptUtil.getScriptFromURL(scriptURL);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CommunicationException((Throwable)e);
        }
        return this.createVM(vmName, ot, rt, script);
    }

    @Override
    public void startVM(VM vm) throws CommunicationException {
        this.startVM(vm.getEndpoint());
    }

    @Override
    public void startVM(URI vmURI) throws CommunicationException {
        try {
            this.startComputeResource(vmURI);
        }
        catch (EntityBuildingException e) {
            throw new CommunicationException(e.getMessage());
        }
    }

    @Override
    public void stopVM(VM vm) throws CommunicationException {
        this.stopVM(vm.getEndpoint());
    }

    @Override
    public void stopVM(URI vmURI) throws CommunicationException {
        try {
            this.stopComputeResource(vmURI);
        }
        catch (EntityBuildingException e) {
            throw new CommunicationException(e.getMessage());
        }
    }

    @Override
    public void destroyVM(VM vm) throws CommunicationException {
        this.destroyVM(vm.getEndpoint());
    }

    @Override
    public void destroyVM(URI vmUri) throws CommunicationException {
        this.deleteComputeResource(vmUri);
    }

    @Override
    public Collection<URI> listNetworkURIs() throws CommunicationException {
        return this.client.list("network");
    }

    @Override
    public Collection<Network> listNetworks() throws CommunicationException {
        ArrayList<Network> out = new ArrayList<Network>();
        for (URI uri : this.listNetworkURIs()) {
            if (uri.toString().trim().isEmpty()) continue;
            out.add(this.getNetwork(uri));
        }
        return out;
    }

    @Override
    public Network getNetwork(URI uri) {
        Network network = null;
        try {
            List entities = this.client.describe(uri);
            Iterator iterator = entities.iterator();
            if (iterator.hasNext()) {
                Entity e = (Entity)iterator.next();
                network = new Network();
                network.setDescription(e.getValue("occi.core.summary"));
                network.setId(e.getValue("occi.core.id"));
                network.setName(e.getValue("occi.core.title"));
                network.setStatus(e.getValue("occi.network.state"));
                network.setAddress(e.getValue("occi.network.address"));
                network.setAllocation(e.getValue("occi.network.allocation"));
                network.setGateway(e.getValue("occi.network.gateway"));
                network.setEndpoint(uri);
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
        return network;
    }

    @Override
    public Collection<URI> listStorageURIs() throws CommunicationException {
        return this.client.list("storage");
    }

    @Override
    public Collection<Storage> listStorages() throws CommunicationException {
        ArrayList<Storage> out = new ArrayList<Storage>();
        for (URI uri : this.listStorageURIs()) {
            if (uri.toString().trim().isEmpty()) continue;
            out.add(this.getStorage(uri));
        }
        return out;
    }

    @Override
    public Storage getStorage(URI uri) {
        Storage storage = null;
        try {
            List entities = this.client.describe(uri);
            Iterator iterator = entities.iterator();
            if (iterator.hasNext()) {
                Entity e = (Entity)iterator.next();
                System.out.println(e);
                storage = new Storage();
                storage.setId(e.getValue("occi.core.id"));
                storage.setName(e.getValue("occi.core.title"));
                storage.setSummary(e.getValue("occi.core.summary"));
                Double disk = ParseUtil.extractDoubleAttribute(e, "occi.storage.size");
                if (disk != null) {
                    storage.setSize(Math.round(disk * 1024.0 * 1024.0 * 1024.0));
                }
                storage.setStatus(e.getValue("occi.storage.size"));
                storage.setEndpoint(uri);
                OSTemplate toCache = new OSTemplate();
                toCache.setId(storage.getEndpoint().toString());
                toCache.setDiskSize(storage.getSize());
                TemplatesCache.getInstance().cache(this.getProvider().getEndpoint(), toCache);
            }
        }
        catch (CommunicationException e) {
            e.printStackTrace();
        }
        return storage;
    }

    private URI createComputeResource(String vmName, Mixin osMixin, Mixin resourceMixin, String script) throws CommunicationException {
        try {
            System.out.println("Creating compute resource...");
            Model model = this.client.getModel();
            EntityBuilder eb = new EntityBuilder(model);
            Resource compute = eb.getResource("compute");
            System.out.println("Mixin:");
            compute.addMixin(osMixin);
            compute.addMixin(resourceMixin);
            System.out.println(osMixin.toText());
            System.out.println(resourceMixin.toText());
            compute.setTitle(vmName);
            compute.addAttribute("occi.compute.hostname", vmName);
            System.out.println("script:\n" + script);
            if (script != null) {
                byte[] message = script.getBytes("UTF-8");
                String encoded = DatatypeConverter.printBase64Binary((byte[])message);
                compute.addMixin(model.findMixin(URI.create("http://schemas.openstack.org/compute/instance#user_data")));
                compute.addAttribute("org.openstack.compute.user_data", encoded);
            }
            URI location = this.client.create((Entity)compute);
            System.out.println("Created compute instance at location: '" + location + "'.");
            ResourceTemplate toCache = new ResourceTemplate();
            toCache.setId(resourceMixin.getScheme() + resourceMixin.getTerm());
            VM vm = this.getVM(location);
            toCache.setCores(vm.getCores());
            toCache.setMemory(vm.getMemory());
            TemplatesCache.getInstance().cache(this.getEndpoint(), toCache);
            OSTemplate ostToCache = new OSTemplate();
            ostToCache.setId(osMixin.getScheme() + osMixin.getTerm());
            ostToCache.setDiskSize(vm.getDiskSize());
            TemplatesCache.getInstance().cache(this.getEndpoint(), ostToCache);
            return location;
        }
        catch (CommunicationException | EntityBuildingException | InvalidAttributeValueException | UnsupportedEncodingException ex) {
            throw new CommunicationException(ex);
        }
    }

    private boolean startComputeResource(URI uri) throws CommunicationException, EntityBuildingException {
        this.connect();
        System.out.println("Starting created compute...");
        ActionInstance actionInstance = this.eb.getActionInstance(URI.create("http://schemas.ogf.org/occi/infrastructure/compute/action#start"));
        return this.client.trigger(uri, actionInstance);
    }

    private boolean stopComputeResource(URI uri) throws CommunicationException, EntityBuildingException {
        this.connect();
        System.out.println("Stopping compute...");
        ActionInstance actionInstance = this.eb.getActionInstance(URI.create("http://schemas.ogf.org/occi/infrastructure/compute/action#stop"));
        return this.client.trigger(uri, actionInstance);
    }

    private boolean deleteComputeResource(URI uri) throws CommunicationException {
        this.connect();
        System.out.println("Deleting created resource...");
        return this.client.delete(uri);
    }

    @Override
    public void setTrustStore(String path) {
        this.trustStorePath = path;
    }

    private void setCredentials(String type, String encoded) throws UnsupportedCredentialsTypeException {
        if ("x509".equals(type)) {
            this.setCredentials(new X509Credentials(encoded));
        }
    }

    private void setCredentials(Credentials credentials) throws UnsupportedCredentialsTypeException {
        if (!(credentials instanceof X509Credentials)) {
            throw new UnsupportedCredentialsTypeException("unsupported credentials type");
        }
        this.proxyCertificatePath = ((X509Credentials)credentials).getCertificateFile().getPath();
    }
}

