/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.is;

import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Key;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.gcube.common.encryption.StringEncrypter;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.AdvancedScopedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.resources.federation.fhnmanager.api.type.Node;
import org.gcube.resources.federation.fhnmanager.api.type.NodeDefinition;
import org.gcube.resources.federation.fhnmanager.api.type.NodeTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusInfrastructure;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusInfrastructureTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusInstanceSet;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusNode;
import org.gcube.resources.federation.fhnmanager.api.type.OccopusScalingParams;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceReference;
import org.gcube.resources.federation.fhnmanager.api.type.ServiceProfile;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.resources.federation.fhnmanager.api.type.VMProviderCredentials;
import org.gcube.resources.federation.fhnmanager.impl.ConnectorFactory;
import org.gcube.resources.federation.fhnmanager.is.ISProxyInterface;
import org.gcube.resources.federation.fhnmanager.occopus.OccopusNodeDefinitionImporter;
import org.gcube.resources.federation.fhnmanager.utils.NodeHelper;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.datamodel.cloud.VM;
import org.gcube.vomanagement.occi.datamodel.cloud.VMNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

/*
 * Exception performing whole class analysis ignored.
 */
public class ISProxyImpl
implements ISProxyInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ISProxyImpl.class);
    private ConnectorFactory connectorFactory;

    private ServiceProfile convertSp(GenericResource a) {
        ServiceProfile out = new ServiceProfile();
        out.setId(a.id());
        out.setDescription(a.profile().body().getElementsByTagName("description").item(0).getTextContent());
        out.setVersion(a.profile().body().getElementsByTagName("version").item(0).getTextContent());
        out.setSuggestedCores(Integer.valueOf(a.profile().body().getElementsByTagName("suggestedCores").item(0).getTextContent()).intValue());
        out.setMinCores(Integer.valueOf(a.profile().body().getElementsByTagName("minCores").item(0).getTextContent()).intValue());
        out.setSuggestedRam(Long.valueOf(a.profile().body().getElementsByTagName("suggestedRam").item(0).getTextContent()));
        out.setMinRam(Long.valueOf(a.profile().body().getElementsByTagName("minRam").item(0).getTextContent()));
        out.setCreationDate(a.profile().body().getElementsByTagName("creationDate").item(0).getTextContent());
        HashSet<ResourceReference> sw = new HashSet<ResourceReference>();
        ResourceReference rr = new ResourceReference();
        rr.setRefId(a.profile().body().getElementsByTagName("deployedSoftware").item(0).getTextContent());
        sw.add(rr);
        out.setDeployedSoftware(sw);
        return out;
    }

    private NodeTemplate convertNt(GenericResource a) {
        NodeTemplate out = new NodeTemplate();
        out.setId(a.id());
        String c = a.profile().body().getElementsByTagName("scriptURL").item(0).getTextContent();
        try {
            URL url = new URL(c);
            out.setScript(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        out.setOsTemplateId(a.profile().body().getElementsByTagName("osTemplateId").item(0).getTextContent());
        ResourceReference rr = new ResourceReference();
        rr.setRefId(a.profile().body().getElementsByTagName("serviceProfileId").item(0).getTextContent());
        out.setServiceProfile(rr);
        return out;
    }

    private VMProvider convertVMP(GenericResource a) {
        VMProvider vmp = new VMProvider();
        VMProviderCredentials vmc = new VMProviderCredentials();
        vmp.setId(a.id());
        vmp.setName(a.profile().name());
        HashSet<ResourceReference> sw = new HashSet<ResourceReference>();
        int i = 0;
        while (i < a.profile().body().getElementsByTagName("nodeTemplateId").getLength()) {
            ResourceReference h1 = new ResourceReference();
            h1.setRefId(a.profile().body().getElementsByTagName("nodeTemplateId").item(i).getTextContent());
            sw.add(h1);
            ++i;
        }
        vmp.setNodeTemplates(sw);
        String serviceEndpointId = a.profile().body().getElementsByTagName("endpoint").item(0).getTextContent();
        XQuery query2 = ICFactory.queryFor(ServiceEndpoint.class);
        query2.addCondition("$resource/ID/text() eq '" + serviceEndpointId + "'").setResult("$resource");
        DiscoveryClient client2 = ICFactory.clientFor(ServiceEndpoint.class);
        List df = client2.submit((Query)query2);
        for (ServiceEndpoint b : df) {
            if (!b.id().equals(serviceEndpointId)) continue;
            vmp.setEndpoint(((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).address());
            vmc.setType(((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("type")).value());
            vmc.setEncodedCredentails(((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("encodedCredentials")).value());
            vmc.setVo(((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("vo")).value());
            vmp.setCredentials(vmc);
        }
        return vmp;
    }

    public ServiceProfile getServiceProfileById(String serviceProfileId) {
        ServiceProfile out = new ServiceProfile();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + serviceProfileId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertSp(a);
        }
        return out;
    }

    public NodeTemplate getNodeTemplateById(String nodeTemplateId) {
        GenericResource r = this.getGenericResourceById(nodeTemplateId);
        if (r == null) {
            return null;
        }
        return this.convertNt(r);
    }

    public Set<OccopusInfrastructure> getAllInfrastructures() {
        HashSet<OccopusInfrastructure> infraset = new HashSet<OccopusInfrastructure>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'OccopusInfras'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            infraset.add(this.convertInfra(a));
        }
        return infraset;
    }

    public List<OccopusInfrastructure> getAllInfrastructuresList() {
        LinkedList<OccopusInfrastructure> infraset = new LinkedList<OccopusInfrastructure>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'OccopusInfras'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            infraset.add(this.convertInfra(a));
        }
        return infraset;
    }

    public Set<ServiceProfile> getAllServiceProfiles() {
        HashSet<ServiceProfile> out = new HashSet<ServiceProfile>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'ServiceProfile'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertSp(a));
        }
        LOGGER.debug("Found " + out.size() + " service profiles");
        return out;
    }

    public Set<Node> getAllNodes() {
        HashSet<Node> out = new HashSet<Node>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'FHN-nodes'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertNode(a));
        }
        return out;
    }

    public Set<VMProvider> getAllVMProviders() {
        HashSet<VMProvider> out = new HashSet<VMProvider>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'VMProviders'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertVMP(a));
        }
        return out;
    }

    public Set<NodeTemplate> getAllNodeTemplates() {
        HashSet<NodeTemplate> out = new HashSet<NodeTemplate>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'NodeTemplate'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertNt(a));
        }
        LOGGER.debug("Found " + out.size() + " node templates");
        return out;
    }

    public VMProvider getVMProviderById(String vmProviderid) {
        VMProvider out = new VMProvider();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + vmProviderid + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertVMP(a);
        }
        return out;
    }

    private Node convertNode(GenericResource a) {
        Node out = new Node();
        out.setId(a.profile().name());
        out.setHostname(a.profile().body().getElementsByTagName("hostname").item(0).getTextContent());
        out.setStatus(a.profile().body().getElementsByTagName("status").item(0).getTextContent());
        out.setCores(Integer.valueOf(a.profile().body().getElementsByTagName("cores").item(0).getTextContent()).intValue());
        out.setMemory(a.profile().body().getElementsByTagName("memory").item(0).getTextContent());
        ResourceReference vp = new ResourceReference();
        vp.setRefId(a.profile().body().getElementsByTagName("vmProviderId").item(0).getTextContent());
        out.setVmProvider(vp);
        ResourceReference rt = new ResourceReference();
        rt.setRefId(a.profile().body().getElementsByTagName("resourceTemplateId").item(0).getTextContent());
        out.setResourceTemplate(rt);
        ResourceReference nt = new ResourceReference();
        nt.setRefId(a.profile().body().getElementsByTagName("nodeTemplateId").item(0).getTextContent());
        out.setNodeTemplate(nt);
        ResourceReference sp = new ResourceReference();
        sp.setRefId(a.profile().body().getElementsByTagName("serviceProfileId").item(0).getTextContent());
        out.setServiceProfile(sp);
        return out;
    }

    private OccopusInfrastructure convertInfra(GenericResource b) {
        OccopusInfrastructure out = new OccopusInfrastructure();
        out.setId(b.profile().body().getFirstChild().getTextContent());
        out.setInfrastructureTemplate(b.profile().body().getFirstChild().getTextContent());
        HashMap<String, OccopusInstanceSet> istanceSets = new HashMap<String, OccopusInstanceSet>();
        NodeList instanceSetNodeList = b.profile().body().getElementsByTagName("instanceset");
        int i = 0;
        while (i < instanceSetNodeList.getLength()) {
            org.w3c.dom.Node iset = instanceSetNodeList.item(i);
            OccopusInstanceSet isetObj = new OccopusInstanceSet();
            String name = null;
            HashMap<String, OccopusNode> nodes = new HashMap<String, OccopusNode>();
            int j = 0;
            while (j < iset.getChildNodes().getLength()) {
                org.w3c.dom.Node cn = iset.getChildNodes().item(j);
                if (cn.getNodeName().equals("name")) {
                    name = cn.getTextContent();
                    LOGGER.debug("FOUND name " + name);
                }
                if (cn.getNodeName().equals("scaling")) {
                    OccopusScalingParams sp = new OccopusScalingParams();
                    int k = 0;
                    while (k < cn.getChildNodes().getLength()) {
                        org.w3c.dom.Node sn = cn.getChildNodes().item(k);
                        if (sn.getNodeName().equals("min")) {
                            sp.setMin(Integer.valueOf(sn.getTextContent()).intValue());
                        }
                        if (sn.getNodeName().equals("max")) {
                            sp.setMax(Integer.valueOf(sn.getTextContent()).intValue());
                        }
                        if (sn.getNodeName().equals("actual")) {
                            sp.setActual(Integer.valueOf(sn.getTextContent()).intValue());
                        }
                        if (sn.getNodeName().equals("target")) {
                            sp.setTarget(Integer.valueOf(sn.getTextContent()).intValue());
                        }
                        ++k;
                    }
                    isetObj.setScaling(sp);
                }
                if (cn.getNodeName().equals("node")) {
                    String id = null;
                    OccopusNode n = new OccopusNode();
                    int k = 0;
                    while (k < cn.getChildNodes().getLength()) {
                        org.w3c.dom.Node nn = cn.getChildNodes().item(k);
                        if (nn.getNodeName().equals("id")) {
                            id = nn.getTextContent();
                            LOGGER.debug("FOUND id " + id);
                        }
                        if (nn.getNodeName().equals("ip")) {
                            n.setResource_address(nn.getTextContent());
                            LOGGER.debug("FOUND ip " + n.getResource_address());
                        }
                        if (nn.getNodeName().equals("state")) {
                            n.setState(nn.getTextContent());
                            LOGGER.debug("FOUND state " + n.getState());
                        }
                        ++k;
                    }
                    if (id != null) {
                        LOGGER.debug("FOUND id " + id);
                        nodes.put(id, n);
                    }
                }
                ++j;
            }
            isetObj.setInstances(nodes);
            if (name != null) {
                istanceSets.put(name, isetObj);
            }
            ++i;
        }
        out.setInstanceSets(istanceSets);
        return out;
    }

    public OccopusInfrastructure returnInfra(OccopusInfrastructureTemplate a) {
        OccopusInfrastructure out = new OccopusInfrastructure();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + a.getId() + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource b : ds) {
            out = this.convertInfra(b);
        }
        return out;
    }

    public VMProvider findVMProviderbyId(String vmProviderId) {
        VMProvider out = new VMProvider();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + vmProviderId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertVMP(a);
        }
        return out;
    }

    public OccopusInfrastructureTemplate returnInfraTemplate(String infraid) {
        GenericResource r = this.getGenericResourceByName(infraid);
        if (r == null) {
            return null;
        }
        OccopusInfrastructureTemplate t = new OccopusInfrastructureTemplate();
        HashSet<NodeDefinition> nd = new HashSet<NodeDefinition>();
        OccopusScalingParams sp = new OccopusScalingParams();
        t.setId(r.profile().name());
        NodeList instanceSetNodeList = r.profile().body().getElementsByTagName("instanceset");
        int i = 0;
        while (i < instanceSetNodeList.getLength()) {
            NodeDefinition a = new NodeDefinition();
            org.w3c.dom.Node iset = instanceSetNodeList.item(i);
            String restemp = null;
            int j = 0;
            while (j < iset.getChildNodes().getLength()) {
                org.w3c.dom.Node cn = iset.getChildNodes().item(j);
                if (cn.getNodeName().equals("vmproviderid")) {
                    String prov = cn.getTextContent();
                    a.setVmproviderId(prov);
                }
                if (cn.getNodeName().equals("nodetemplateId")) {
                    String ntId = cn.getTextContent();
                    a.setNodetemplateId(ntId);
                }
                if (cn.getNodeName().equals("resourcetemplateId")) {
                    restemp = cn.getTextContent();
                    a.setResourceTemplateId(restemp);
                }
                if (cn.getNodeName().equals("min")) {
                    Integer min = Integer.valueOf(cn.getTextContent());
                    sp.setMin(min.intValue());
                }
                if (cn.getNodeName().equals("max")) {
                    Integer max = Integer.valueOf(cn.getTextContent());
                    sp.setMax(max.intValue());
                }
                ++j;
            }
            a.setScaling(sp);
            nd.add(a);
            ++i;
        }
        t.setSetnd(nd);
        return t;
    }

    public Set<VMProvider> findVMProvidersbyServiceProfile(String serviceProfileId) {
        Set s1 = serviceProfileId == null ? this.getAllVMProviders() : this.getVMProvidersByServiceProfile(serviceProfileId);
        return s1;
    }

    public Set<VMProvider> getVMProvidersByServiceProfile(String serviceProfileId) {
        HashSet<VMProvider> result = new HashSet<VMProvider>();
        for (VMProvider vmp : this.getAllVMProviders()) {
            for (NodeTemplate nt : this.getVMProviderNodeTemplates(vmp)) {
                if (nt.getServiceProfile() == null || !nt.getServiceProfile().getRefId().equals(serviceProfileId)) continue;
                result.add(vmp);
            }
        }
        return result;
    }

    public Set<NodeTemplate> getVMProviderNodeTemplates(VMProvider vm) {
        HashSet<NodeTemplate> nodeTemplates = new HashSet<NodeTemplate>();
        vm = this.getVMProviderById(vm.getId());
        for (ResourceReference ref : vm.getNodeTemplates()) {
            nodeTemplates.add(this.getNodeTemplateById(ref.getRefId()));
        }
        return nodeTemplates;
    }

    public Set<NodeTemplate> getVMProviderNodeTemplates(String vmProviderId) {
        HashSet<NodeTemplate> nodeTemplates = new HashSet<NodeTemplate>();
        VMProvider vmp = this.getVMProviderById(vmProviderId);
        for (ResourceReference ref : vmp.getNodeTemplates()) {
            NodeTemplate nt = this.getNodeTemplateById(ref.getRefId());
            if (nt == null) continue;
            nodeTemplates.add(nt);
        }
        return nodeTemplates;
    }

    public NodeTemplate getNodeTemplate(String serviceProfileId, String vmProviderId) {
        VMProvider vmps = this.getVMProviderById(vmProviderId);
        for (NodeTemplate nt : this.getVMProviderNodeTemplates(vmps.getId())) {
            if (nt.getServiceProfile() == null || !nt.getServiceProfile().getRefId().equals(serviceProfileId)) continue;
            return nt;
        }
        return null;
    }

    private static void publishScopedResource(GenericResource a, List<String> scopes) throws RegistryNotFoundException, Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)a, (Writer)stringWriter);
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        try {
            System.out.println(scopes);
            System.out.println(stringWriter);
            scopedPublisher.create((Resource)a, scopes);
        }
        catch (RegistryNotFoundException e) {
            System.out.println((Object)e);
            throw e;
        }
    }

    private static void unPublishScopedResource(GenericResource resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        LOGGER.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove((Resource)resource);
        LOGGER.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    private static void unPublishHostingNode(HostingNode resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        LOGGER.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove((Resource)resource);
        LOGGER.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    public void updateNode(Node node) {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + node.getId() + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        if (ds.isEmpty()) {
            return;
        }
        GenericResource a = (GenericResource)ds.get(0);
        a.profile().newBody(this.getNodeBody(node));
        try {
            scopedPublisher.update((Resource)a);
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void updateInfra(OccopusInfrastructure infra) {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + infra.getId() + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        if (ds.isEmpty()) {
            return;
        }
        GenericResource a = (GenericResource)ds.get(0);
        a.profile().newBody(this.getInfraBody(infra));
        try {
            scopedPublisher.update((Resource)a);
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
    }

    private String getInfraBody(OccopusInfrastructure infra) {
        String isetsXml = "";
        if (infra.getInstanceSets() != null) {
            for (String k : infra.getInstanceSets().keySet()) {
                OccopusInstanceSet iset = (OccopusInstanceSet)infra.getInstanceSets().get(k);
                OccopusScalingParams iscal = iset.getScaling();
                String nodesXml = "";
                if (iset.getInstances() == null) continue;
                for (String nId : iset.getInstances().keySet()) {
                    OccopusNode node = (OccopusNode)iset.getInstances().get(nId);
                    String nodeXml = "<node><id>" + nId + "</id>" + "<ip>" + node.getResource_address() + "</ip>" + "<state>" + node.getState() + "</state>" + "</node>";
                    nodesXml = String.valueOf(nodesXml) + nodeXml;
                }
                isetsXml = String.valueOf(isetsXml) + "<instanceset>" + "<name>" + k + "</name>" + "<scaling>" + "<min>" + iscal.getMin() + "</min>" + "<max>" + iscal.getMax() + "</max>" + "<actual>" + iscal.getActual() + "</actual>" + "<target>" + iscal.getTarget() + "</target>" + "</scaling>" + nodesXml + "</instanceset>";
            }
        }
        return "<infraTemplateId>" + infra.getInfrastructureTemplate() + "</infraTemplateId>" + "\n" + isetsXml;
    }

    private String getNodeBody(Node node) {
        return "<nodeTemplateId>" + node.getNodeTemplate().getRefId() + "</nodeTemplateId>" + "\n" + "<vmProviderId>" + node.getVmProvider().getRefId() + "</vmProviderId>" + "\n" + "<serviceProfileId>" + node.getServiceProfile().getRefId() + "</serviceProfileId>" + "\n" + "<resourceTemplateId>" + node.getResourceTemplate().getRefId() + "</resourceTemplateId>" + "\n" + "<status>" + node.getStatus() + "</status>" + "\n" + "<hostname>" + node.getHostname() + "</hostname>" + "\n" + "<cores>" + node.getCores() + "</cores>" + "\n" + "<memory>" + node.getMemory() + "</memory>";
    }

    public void addNode(Node node) {
        GenericResource a = new GenericResource();
        a.newProfile().name(node.getId()).type("FHN-nodes").description("Node deployed to Provider " + node.getVmProvider().getRefId() + "with serviceProfile" + node.getServiceProfile().getRefId());
        a.profile().newBody(this.getNodeBody(node));
        try {
            ISProxyImpl.publishScopedResource((GenericResource)a, Arrays.asList(ScopeProvider.instance.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<OccopusInfrastructureTemplate> getAllInfrastructuresTemplates() {
        HashSet<OccopusInfrastructureTemplate> infraset = new HashSet<OccopusInfrastructureTemplate>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'OccopusTemplates'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            infraset.add(this.returnInfraTemplate(a.profile().name()));
        }
        return infraset;
    }

    public OccopusInfrastructureTemplate getInfraTemplatefromInfra(OccopusInfrastructure b) {
        OccopusInfrastructureTemplate it2 = new OccopusInfrastructureTemplate();
        for (OccopusInfrastructureTemplate it : this.getAllInfrastructuresTemplates()) {
            if (!it.getId().equals(b.getId())) continue;
            it2 = it;
            for (NodeDefinition nd : it.getSetnd()) {
                System.out.println(nd);
            }
        }
        return it2;
    }

    public void addNodeTemplate(NodeTemplate nt) {
        GenericResource res = new GenericResource();
        res.newProfile().name("node-template-" + nt.getId()).type("NodeTemplate").description(nt.getDescription());
        res.profile().newBody("<scriptURL>" + nt.getScript().toString() + "</scriptURL>" + "<osTemplateId>" + nt.getOsTemplateId() + "</osTemplateId>" + "<serviceProfileId>" + nt.getServiceProfile().getRefId() + "</serviceProfileId>");
        try {
            ISProxyImpl.publishScopedResource((GenericResource)res, Arrays.asList(ScopeProvider.instance.get()));
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String encodeMultilineString(String in) {
        return in.replaceAll("\\n", "\\$%\\$");
    }

    public String decodeMultilenString(String in) {
        return in.replaceAll("\\$%\\$", "\n");
    }

    public void addInfraTemplate(OccopusInfrastructureTemplate it) {
        GenericResource res = new GenericResource();
        res.newProfile().name("occopusInfraTemplate" + UUID.randomUUID()).type("OccopusTemplates");
        res.profile().newBody(this.getInfraTemplateBody(it));
        try {
            ISProxyImpl.publishScopedResource((GenericResource)res, Arrays.asList(ScopeProvider.instance.get()));
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getInfraTemplateBody(OccopusInfrastructureTemplate infra) {
        String template = "";
        for (NodeDefinition ndf : infra.getSetnd()) {
            template = String.valueOf(template) + "<instanceset><vmproviderid>" + ndf.getVmproviderId() + "</vmproviderid>" + "<nodetemplateId>" + ndf.getNodetemplateId() + "</nodetemplateId>" + "<resourcetemplateId>" + ndf.getResourceTemplateId() + "</resourcetemplateId>" + "<min>" + ndf.getScaling().getMin() + "</min>" + "<max>" + ndf.getScaling().getMax() + "</max>" + "</instanceset>";
        }
        return template;
    }

    public void addServiceProfile(ServiceProfile sp) {
        GenericResource gr = new GenericResource();
        gr.newProfile().name("gCubeSmartExecutor" + UUID.randomUUID()).description("gCubeSmartExecutor details").type("ServiceProfile");
        gr.profile().newBody("<deployedSoftware>" + sp.getDeployedSoftware() + "</deployedSoftware>" + "\n" + "<description>" + sp.getDescription() + "</description>" + "\n" + "<creationDate>" + sp.getCreationDate() + "</creationDate>" + "\n" + "<version>" + sp.getVersion() + "</version>" + "\n" + "<minRam>" + sp.getMinRam() + "</minRam>" + "\n" + "<minCores>" + sp.getMinCores() + "</minCores>" + "\n" + "<suggestedRam>" + sp.getSuggestedRam() + "</suggestedRam>" + "\n" + "<suggestedCores>" + sp.getSuggestedRam() + "</suggestedCores>" + "\n");
        try {
            ISProxyImpl.publishScopedResource((GenericResource)gr, Arrays.asList(ScopeProvider.instance.get()));
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addVMProvider(VMProvider vmp) {
        GenericResource gr = new GenericResource();
        gr.newProfile().name("FedCloud-Cesnet-Metacloud" + UUID.randomUUID()).description("Cesnet-Metacloud provider profile").type("VMProviders");
        gr.profile().newBody("<name>" + vmp.getName() + "</name>" + "\n" + "<resourceTemplates>" + vmp.getResourceTemplates() + "</resourceTemplates>" + "\n" + "<nodeTemplateId>" + ((ResourceReference)vmp.getNodeTemplates().iterator().next()).getRefId() + "</nodeTemplateId>" + "\n" + "<endpoint>" + vmp.getEndpoint() + "</endpoint>" + "\n");
        try {
            ISProxyImpl.publishScopedResource((GenericResource)gr, Arrays.asList(ScopeProvider.instance.get()));
        }
        catch (RegistryNotFoundException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addInfra(OccopusInfrastructure infra) {
        GenericResource a = new GenericResource();
        a.newProfile().name(infra.getId()).type("OccopusInfras");
        a.profile().newBody(this.getInfraBody(infra));
        try {
            ISProxyImpl.publishScopedResource((GenericResource)a, Arrays.asList(ScopeProvider.instance.get()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<Node> findNodes(String serviceProfileId, String vmProviderId) {
        Set n1 = this.getNodeByServiceProfileId(serviceProfileId);
        LOGGER.debug("Nodes filtered by ServiceProfile: " + n1);
        Set n2 = this.getNodesByVMProviderId(vmProviderId);
        LOGGER.debug("Nodes filtered by VMProvider: " + n2);
        HashSet<Node> intersection = new HashSet<Node>(n1);
        intersection.retainAll(n2);
        LOGGER.debug("Returning: " + intersection);
        return intersection;
    }

    private Set<Node> getNodeByServiceProfileId(String serviceProfileId) {
        if (serviceProfileId == null) {
            return this.getAllNodes();
        }
        HashSet<Node> result = new HashSet<Node>();
        for (Node vn2 : this.getAllNodes()) {
            if (!vn2.getServiceProfile().getRefId().equals(serviceProfileId)) continue;
            result.add(vn2);
        }
        return result;
    }

    private Set<Node> getNodesByVMProviderId(String vmProviderId) {
        if (vmProviderId == null) {
            return this.getAllNodes();
        }
        HashSet<Node> result = new HashSet<Node>();
        for (Node vn2 : this.getAllNodes()) {
            if (!vn2.getVmProvider().getRefId().equals(vmProviderId)) continue;
            result.add(vn2);
        }
        return result;
    }

    public Node getNodeById(String nodeId) {
        GenericResource r = this.getGenericResourceByName(nodeId);
        if (r != null) {
            return this.convertNode(r);
        }
        return null;
    }

    private GenericResource getGenericResourceByName(String name) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + name + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        if (ds.isEmpty()) {
            return null;
        }
        if (ds.size() > 1) {
            LOGGER.warn("Multiple generic resources found with Name=" + name + "!!! Returning the first one");
        }
        return (GenericResource)ds.get(0);
    }

    private GenericResource getGenericResourceById(String id) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + id + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        LOGGER.debug("Found " + ds.size() + " results");
        if (ds.isEmpty()) {
            return null;
        }
        if (ds.size() > 1) {
            LOGGER.warn("Multiple generic resources found with ID=" + id + "!!! Returning the first one");
        }
        return (GenericResource)ds.get(0);
    }

    public OccopusInfrastructure getInfrastructureById(String infraId) {
        OccopusInfrastructure out = new OccopusInfrastructure();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + infraId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertInfra(a);
        }
        return out;
    }

    public String setD4ScienceOccopusAuth() throws Exception {
        File d = null;
        this.connectorFactory = new ConnectorFactory();
        XQuery query2 = ICFactory.queryFor(ServiceEndpoint.class);
        query2.addCondition("$resource/Profile/Name/text() eq 'occopusD4ScienceOccopusAuth'").setResult("$resource");
        DiscoveryClient client2 = ICFactory.clientFor(ServiceEndpoint.class);
        List df = client2.submit((Query)query2);
        for (ServiceEndpoint b : df) {
            String proxy = ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("encodedCredentials")).value();
            String certPath = StringEncrypter.getEncrypter().decrypt(proxy, new Key[0]);
            certPath = this.connectorFactory.adaptIS(certPath);
            certPath = this.connectorFactory.adaptCert(certPath);
            certPath = this.connectorFactory.removeHeader(certPath);
            File f = new File("/tmp/temp");
            if (!f.exists()) {
                f.createNewFile();
                f.setReadable(false, false);
                f.setWritable(false, false);
                f.setExecutable(false, false);
                f.setReadable(true, true);
                f.setWritable(true, true);
            }
            FileWriter fw = new FileWriter(f.getPath());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(certPath);
            bw.flush();
            bw.close();
            String c = this.connectorFactory.generateSecondLevelProxy(f.getPath(), ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("vo")).value());
            d = new File(c);
            d.renameTo(new File("/tmp/occopusCert"));
        }
        return d.getPath();
    }

    public String setFedCloudOccopusAuth() throws Exception {
        File d = null;
        this.connectorFactory = new ConnectorFactory();
        XQuery query2 = ICFactory.queryFor(ServiceEndpoint.class);
        query2.addCondition("$resource/Profile/Name/text() eq 'occopusFedCloudOccopusAuth'").setResult("$resource");
        DiscoveryClient client2 = ICFactory.clientFor(ServiceEndpoint.class);
        List df = client2.submit((Query)query2);
        for (ServiceEndpoint b : df) {
            String proxy = ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("encodedCredentials")).value();
            String certPath = StringEncrypter.getEncrypter().decrypt(proxy, new Key[0]);
            certPath = this.connectorFactory.adaptIS(certPath);
            certPath = this.connectorFactory.adaptCert(certPath);
            certPath = this.connectorFactory.removeHeader(certPath);
            File f = new File("/tmp/temp2");
            if (!f.exists()) {
                f.createNewFile();
                f.setReadable(false, false);
                f.setWritable(false, false);
                f.setExecutable(false, false);
                f.setReadable(true, true);
                f.setWritable(true, true);
            }
            FileWriter fw = new FileWriter(f.getPath());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(certPath);
            bw.flush();
            bw.close();
            String c = this.connectorFactory.generateSecondLevelProxy(f.getPath(), ((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("vo")).value());
            d = new File(c);
            d.renameTo(new File("/tmp/occopusCert2"));
        }
        return d.getPath();
    }

    public Node getNodeByURI(String UriId) {
        Node out = new Node();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + UriId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertNode(a);
            System.out.println(out.getId());
        }
        return out;
    }

    public String getNodeNameById(String Id) {
        String b = new String();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + Id + "'").setResult("$resource/Profile/Name/text()");
        DiscoveryClient client = ICFactory.client();
        List ds = client.submit((Query)query);
        Iterator iterator = ds.iterator();
        while (iterator.hasNext()) {
            String a;
            b = a = (String)iterator.next();
        }
        return b;
    }

    public void deleteInfrastructure(String infra) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'OccopusInfras'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            if (!a.profile().name().equals(infra)) continue;
            try {
                ISProxyImpl.unPublishScopedResource((GenericResource)a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteNode(Node node) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'FHN-nodes'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            if (!a.profile().name().equals(node.getId())) continue;
            try {
                ISProxyImpl.unPublishScopedResource((GenericResource)a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteHostingNode(String hostname) {
        XQuery query = ICFactory.queryFor(HostingNode.class);
        DiscoveryClient client = ICFactory.clientFor(HostingNode.class);
        List ds = client.submit((Query)query);
        for (HostingNode a : ds) {
            if (!a.profile().description().name().startsWith(hostname)) continue;
            try {
                ISProxyImpl.unPublishHostingNode((HostingNode)a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateIs() throws CommunicationException, UnknownHostException {
        for (VMProvider a : this.getAllVMProviders()) {
            try {
                this.connectorFactory = new ConnectorFactory();
                FHNConnector connector = this.connectorFactory.getConnector(a);
                connector.connect();
                Collection listvm = connector.listVM();
                for (VM vm : listvm) {
                    String vmStatus = vm.getStatus();
                    String hostname = "";
                    for (VMNetwork vmn : vm.getNetworks()) {
                        if (InetAddress.getByName(vmn.getAddress()).isSiteLocalAddress()) continue;
                        hostname = InetAddress.getByName(vmn.getAddress()).getHostName();
                    }
                    Node isnode = this.getNodeById(NodeHelper.createNodeId((String)a.getId(), (String)vm.getEndpoint().toString()));
                    if (isnode == null) {
                        LOGGER.info("VM " + hostname + " not found on the IS. Skipping synchronization");
                        continue;
                    }
                    isnode.setStatus(vmStatus);
                    isnode.setHostname(hostname);
                    this.updateNode(isnode);
                }
            }
            catch (Exception aa) {
                aa.getMessage();
            }
        }
        try {
            OccopusNodeDefinitionImporter od = new OccopusNodeDefinitionImporter();
            od.importer();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        ScopeProvider.instance.set("/gcube/devsec");
        ISProxyImpl a = new ISProxyImpl();
        System.out.println(a.getAllInfrastructuresTemplates());
    }
}

