/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.federation.fhnmanager.is;

import cz.cesnet.cloud.occi.api.exception.CommunicationException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.publisher.AdvancedScopedPublisher;
import org.gcube.informationsystem.publisher.RegistryPublisherFactory;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.informationsystem.publisher.exception.RegistryNotFoundException;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.resources.federation.fhnmanager.api.type.Node;
import org.gcube.resources.federation.fhnmanager.api.type.NodeTemplate;
import org.gcube.resources.federation.fhnmanager.api.type.ResourceReference;
import org.gcube.resources.federation.fhnmanager.api.type.ServiceProfile;
import org.gcube.resources.federation.fhnmanager.api.type.VMProvider;
import org.gcube.resources.federation.fhnmanager.api.type.VMProviderCredentials;
import org.gcube.resources.federation.fhnmanager.impl.ConnectorFactory;
import org.gcube.resources.federation.fhnmanager.is.ISProxyInterface;
import org.gcube.vomanagement.occi.FHNConnector;
import org.gcube.vomanagement.occi.datamodel.cloud.VM;
import org.gcube.vomanagement.occi.datamodel.cloud.VMNetwork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ISProxyImpl
implements ISProxyInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(ISProxyImpl.class);
    private ConnectorFactory connectorFactory;

    private ServiceProfile convertSp(GenericResource a) {
        ServiceProfile out = new ServiceProfile();
        out.setId(a.id());
        out.setDescription(a.profile().body().getElementsByTagName("description").item(0).getTextContent());
        out.setVersion(a.profile().body().getElementsByTagName("version").item(0).getTextContent());
        out.setSuggestedCores(Integer.valueOf(a.profile().body().getElementsByTagName("suggestedCores").item(0).getTextContent()).intValue());
        out.setMinCores(Integer.valueOf(a.profile().body().getElementsByTagName("minCores").item(0).getTextContent()).intValue());
        out.setSuggestedRam(Long.valueOf(a.profile().body().getElementsByTagName("suggestedRam").item(0).getTextContent()));
        out.setMinRam(Long.valueOf(a.profile().body().getElementsByTagName("minRam").item(0).getTextContent()));
        out.setCreationDate(a.profile().body().getElementsByTagName("creationDate").item(0).getTextContent());
        HashSet<ResourceReference> sw = new HashSet<ResourceReference>();
        ResourceReference rr = new ResourceReference();
        rr.setRefId(a.profile().body().getElementsByTagName("deployedSoftware").item(0).getTextContent());
        sw.add(rr);
        out.setDeployedSoftware(sw);
        return out;
    }

    private NodeTemplate convertNt(GenericResource a) {
        NodeTemplate out = new NodeTemplate();
        out.setId(a.id());
        String c = a.profile().body().getElementsByTagName("scriptURL").item(0).getTextContent();
        try {
            URL url = new URL(c);
            out.setScript(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        out.setOsTemplateId(a.profile().body().getElementsByTagName("osTemplateId").item(0).getTextContent());
        ResourceReference rr = new ResourceReference();
        rr.setRefId(a.profile().body().getElementsByTagName("serviceProfileId").item(0).getTextContent());
        out.setServiceProfile(rr);
        return out;
    }

    private VMProvider convertVMP(GenericResource a) {
        VMProvider vmp = new VMProvider();
        VMProviderCredentials vmc = new VMProviderCredentials();
        vmp.setId(a.id());
        vmp.setName(a.profile().name());
        HashSet<ResourceReference> sw = new HashSet<ResourceReference>();
        int i = 0;
        while (i < a.profile().body().getElementsByTagName("nodeTemplateId").getLength()) {
            ResourceReference h1 = new ResourceReference();
            h1.setRefId(a.profile().body().getElementsByTagName("nodeTemplateId").item(i).getTextContent());
            sw.add(h1);
            ++i;
        }
        vmp.setNodeTemplates(sw);
        String serviceEndpointId = a.profile().body().getElementsByTagName("endpoint").item(0).getTextContent();
        XQuery query2 = ICFactory.queryFor(ServiceEndpoint.class);
        query2.addCondition("$resource/ID/text() eq '" + serviceEndpointId + "'").setResult("$resource");
        DiscoveryClient client2 = ICFactory.clientFor(ServiceEndpoint.class);
        List df = client2.submit((Query)query2);
        for (ServiceEndpoint b : df) {
            if (!b.id().equals(serviceEndpointId)) continue;
            vmp.setEndpoint(((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).address());
            vmc.setType(((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("type")).value());
            vmc.setEncodedCredentails(((ServiceEndpoint.Property)((ServiceEndpoint.AccessPoint)b.profile().accessPoints().iterator().next()).propertyMap().get("encodedCredentials")).value());
            vmp.setCredentials(vmc);
        }
        return vmp;
    }

    public ServiceProfile getServiceProfileById(String serviceProfileId) {
        ServiceProfile out = new ServiceProfile();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + serviceProfileId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertSp(a);
        }
        return out;
    }

    public NodeTemplate getNodeTemplateById(String nodeTemplateId) {
        NodeTemplate out = new NodeTemplate();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + nodeTemplateId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertNt(a);
        }
        return out;
    }

    public Set<ServiceProfile> getAllServiceProfiles() {
        HashSet<ServiceProfile> out = new HashSet<ServiceProfile>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'ServiceProfile'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertSp(a));
        }
        return out;
    }

    public Set<Node> getAllNodes() {
        HashSet<Node> out = new HashSet<Node>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'FHN-nodes'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertNode(a));
        }
        return out;
    }

    public Set<VMProvider> getAllVMProviders() {
        HashSet<VMProvider> out = new HashSet<VMProvider>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'VMProviders'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertVMP(a));
        }
        return out;
    }

    public Set<NodeTemplate> getAllNodeTemplates() {
        HashSet<NodeTemplate> out = new HashSet<NodeTemplate>();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'NodeTemplate'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out.add(this.convertNt(a));
        }
        return out;
    }

    public VMProvider getVMProviderById(String vmProviderid) {
        VMProvider out = new VMProvider();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + vmProviderid + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertVMP(a);
        }
        return out;
    }

    private Node convertNode(GenericResource a) {
        Node out = new Node();
        out.setId(a.profile().name());
        out.setHostname(a.profile().body().getElementsByTagName("hostname").item(0).getTextContent());
        out.setStatus(a.profile().body().getElementsByTagName("status").item(0).getTextContent());
        ResourceReference vp = new ResourceReference();
        vp.setRefId(a.profile().body().getElementsByTagName("vmProviderId").item(0).getTextContent());
        out.setVmProvider(vp);
        ResourceReference rt = new ResourceReference();
        rt.setRefId(a.profile().body().getElementsByTagName("resourceTemplateId").item(0).getTextContent());
        out.setResourceTemplate(rt);
        ResourceReference nt = new ResourceReference();
        nt.setRefId(a.profile().body().getElementsByTagName("nodeTemplateId").item(0).getTextContent());
        out.setNodeTemplate(nt);
        ResourceReference sp = new ResourceReference();
        sp.setRefId(a.profile().body().getElementsByTagName("serviceProfileId").item(0).getTextContent());
        out.setServiceProfile(sp);
        return out;
    }

    public VMProvider findVMProviderbyId(String vmProviderId) {
        VMProvider out = new VMProvider();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/ID/text() eq '" + vmProviderId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertVMP(a);
        }
        return out;
    }

    public Set<VMProvider> findVMProvidersbyServiceProfile(String serviceProfileId) {
        Set s1 = serviceProfileId == null ? this.getAllVMProviders() : this.getVMProvidersByServiceProfile(serviceProfileId);
        return s1;
    }

    public Set<VMProvider> getVMProvidersByServiceProfile(String serviceProfileId) {
        HashSet<VMProvider> result = new HashSet<VMProvider>();
        for (VMProvider vmp : this.getAllVMProviders()) {
            for (NodeTemplate nt : this.getVMProviderNodeTemplates(vmp)) {
                if (nt.getServiceProfile() == null || !nt.getServiceProfile().getRefId().equals(serviceProfileId)) continue;
                result.add(vmp);
            }
        }
        return result;
    }

    public Set<NodeTemplate> getVMProviderNodeTemplates(VMProvider vm) {
        HashSet<NodeTemplate> nodeTemplates = new HashSet<NodeTemplate>();
        vm = this.getVMProviderById(vm.getId());
        for (ResourceReference ref : vm.getNodeTemplates()) {
            nodeTemplates.add(this.getNodeTemplateById(ref.getRefId()));
        }
        return nodeTemplates;
    }

    public Set<NodeTemplate> getVMProviderNodeTemplates(String vmProviderId) {
        HashSet<NodeTemplate> nodeTemplates = new HashSet<NodeTemplate>();
        VMProvider vmp = this.getVMProviderById(vmProviderId);
        for (ResourceReference ref : vmp.getNodeTemplates()) {
            nodeTemplates.add(this.getNodeTemplateById(ref.getRefId()));
        }
        return nodeTemplates;
    }

    public NodeTemplate getNodeTemplate(String serviceProfileId, String vmProviderId) {
        VMProvider vmps = this.getVMProviderById(vmProviderId);
        for (NodeTemplate nt : this.getVMProviderNodeTemplates(vmps.getId())) {
            if (nt.getServiceProfile() == null || !nt.getServiceProfile().getRefId().equals(serviceProfileId)) continue;
            return nt;
        }
        return null;
    }

    private static void publishScopedResource(GenericResource a, List<String> scopes) throws RegistryNotFoundException, Exception {
        StringWriter stringWriter = new StringWriter();
        Resources.marshal((Object)a, (Writer)stringWriter);
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        try {
            System.out.println(scopes);
            System.out.println(stringWriter);
            scopedPublisher.create((Resource)a, scopes);
        }
        catch (RegistryNotFoundException e) {
            System.out.println((Object)e);
            throw e;
        }
    }

    private static void unPublishScopedResource(GenericResource resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        LOGGER.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove((Resource)resource);
        LOGGER.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    private static void unPublishHostingNode(HostingNode resource) throws RegistryNotFoundException, Exception {
        ScopedPublisher scopedPublisher = RegistryPublisherFactory.scopedPublisher();
        AdvancedScopedPublisher advancedScopedPublisher = new AdvancedScopedPublisher(scopedPublisher);
        String id = resource.id();
        LOGGER.debug("Trying to remove {} with ID {} from {}", new Object[]{resource.getClass().getSimpleName(), id, ScopeProvider.instance.get()});
        advancedScopedPublisher.forceRemove((Resource)resource);
        LOGGER.debug("{} with ID {} removed successfully", (Object)resource.getClass().getSimpleName(), (Object)id);
    }

    public void addNode(Node node) {
        GenericResource a = new GenericResource();
        LinkedList<String> b = new LinkedList<String>();
        String scope = ScopeProvider.instance.get();
        b.add(scope);
        a.newProfile().name(node.getId()).type("FHN-nodes").description("FHN node_test");
        a.profile().newBody("<nodeTemplateId>" + node.getNodeTemplate().getRefId() + "</nodeTemplateId>" + "\n" + "<vmProviderId>" + node.getVmProvider().getRefId() + "</vmProviderId>" + "\n" + "<serviceProfileId>" + node.getServiceProfile().getRefId() + "</serviceProfileId>" + "\n" + "<resourceTemplateId>" + node.getResourceTemplate().getRefId() + "</resourceTemplateId>" + "\n" + "<status>" + node.getStatus() + "</status>" + "\n" + "<hostname>" + node.getHostname() + "</hostname>");
        try {
            ISProxyImpl.publishScopedResource((GenericResource)a, b);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<Node> findNodes(String serviceProfileId, String vmProviderId) {
        Set n1 = this.getNodeByServiceProfileId(serviceProfileId);
        LOGGER.debug("Nodes filtered by ServiceProfile: " + n1);
        Set n2 = this.getNodesByVMProviderId(vmProviderId);
        LOGGER.debug("Nodes filtered by VMProvider: " + n2);
        HashSet<Node> intersection = new HashSet<Node>(n1);
        intersection.retainAll(n2);
        LOGGER.debug("Returning: " + intersection);
        return intersection;
    }

    private Set<Node> getNodeByServiceProfileId(String serviceProfileId) {
        if (serviceProfileId == null) {
            return this.getAllNodes();
        }
        HashSet<Node> result = new HashSet<Node>();
        for (Node vn2 : this.getAllNodes()) {
            if (!vn2.getServiceProfile().getRefId().equals(serviceProfileId)) continue;
            result.add(vn2);
        }
        return result;
    }

    private Set<Node> getNodesByVMProviderId(String vmProviderId) {
        if (vmProviderId == null) {
            return this.getAllNodes();
        }
        HashSet<Node> result = new HashSet<Node>();
        for (Node vn2 : this.getAllNodes()) {
            if (!vn2.getVmProvider().getRefId().equals(vmProviderId)) continue;
            result.add(vn2);
        }
        return result;
    }

    public Node getNodeById(String nodeId) {
        Node out = new Node();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/Name/text() eq '" + nodeId + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            out = this.convertNode(a);
        }
        return out;
    }

    public void deleteNode(Node node) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'FHN-nodes'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        for (GenericResource a : ds) {
            if (!a.profile().name().equals(node.getId())) continue;
            String t = node.getHostname();
            try {
                ISProxyImpl.unPublishScopedResource((GenericResource)a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteHostingNode(String hostname) {
        XQuery query = ICFactory.queryFor(HostingNode.class);
        query.addCondition("$resource/Profile/GHNDescription/Name/text() eq '" + hostname + ":80" + "'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(HostingNode.class);
        List ds = client.submit((Query)query);
        for (HostingNode a : ds) {
            if (!a.profile().description().name().equals(String.valueOf(hostname) + ":80")) continue;
            try {
                ISProxyImpl.unPublishHostingNode((HostingNode)a);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void updateIs() throws CommunicationException, UnknownHostException {
        for (VMProvider a : this.getAllVMProviders()) {
            this.connectorFactory = new ConnectorFactory();
            FHNConnector connector = this.connectorFactory.getConnector(a);
            connector.connect();
            Collection listvm = connector.listVM();
            for (VM vm : listvm) {
                for (VMNetwork vmn : vm.getNetworks()) {
                    Node isnode = this.getNodeById(vm.getEndpoint().toString());
                    if (isnode == null) continue;
                    InetAddress inetAddress = InetAddress.getByName(vmn.getAddress());
                    System.out.println(inetAddress);
                    System.out.println(isnode.getId());
                    isnode.setHostname(inetAddress.getHostName());
                    System.out.println(inetAddress.getHostName());
                    isnode.setStatus(vm.getStatus());
                    System.out.println(vm.getStatus());
                    for (Node n : this.getAllNodes()) {
                        if (!n.getId().equals(isnode.getId())) continue;
                        n.setHostname(isnode.getHostname());
                        n.setStatus(isnode.getStatus());
                        this.addNode(isnode);
                        this.deleteNode(n);
                    }
                }
            }
        }
    }

    public static void main(String[] args) {
        ScopeProvider.instance.set("/gcube/devsec");
        ISProxyImpl a = new ISProxyImpl();
    }
}

