package org.gcube.resources.discovery.icclient.stubs;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

import javax.net.ssl.HttpsURLConnection;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorStubRestImpl implements CollectorStub {
	
	private static Logger log = LoggerFactory.getLogger(CollectorStubRestImpl.class);
	
	public static final String TOKEN_HEADER_ENTRY = "gcube-token";
	public static final String SCOPE_HEADER_ENTRY = "gcube-scope";
	private String endopoint;
	 
	
	public CollectorStubRestImpl(String endopoint) {
		super();
		this.endopoint = endopoint;
	}

	@Override
	public String execute(String query) throws MalformedQueryException {
		//final String methodPath = "/search/"; 
		final String queryParameter = "query"; 
		
		try {
			StringBuilder callUrl = new StringBuilder(endopoint).append("?").append(queryParameter).append("=").append(URLEncoder.encode(query, StandardCharsets.UTF_8.toString()));
			URL url = new URL(callUrl.toString());
			HttpURLConnection connection = makeRequest(url, "GET", false);
			connection.setDoInput(true);		
			if (connection.getResponseCode()!=200){
				log.info("response code is not 200");
				throw new Exception("error executing query");
			}
			String toReturn;
			try(BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()))){
				StringBuilder result = new StringBuilder();
				String line;
				while((line = reader.readLine()) != null) 
					result.append(line);
				toReturn =  result.toString();
			}
			return toReturn;
		}catch (Exception e) {
			log.error("error executing query",e);
			throw new MalformedQueryException(e.getMessage());
		}
	}

	private HttpURLConnection makeRequest(URL url, String method, boolean includeTokenInHeader) throws Exception{
		HttpURLConnection connection;
		if (url.toString().startsWith("https://"))
			connection = (HttpsURLConnection)url.openConnection();
		else connection = (HttpURLConnection)url.openConnection();

		if (includeTokenInHeader){
			if (SecurityTokenProvider.instance.get()==null) throw new RuntimeException("null token passed");
			connection.setRequestProperty(TOKEN_HEADER_ENTRY,SecurityTokenProvider.instance.get());
		} else {
			if (ScopeProvider.instance.get()==null) throw new RuntimeException("null scope passed");
			connection.setRequestProperty(SCOPE_HEADER_ENTRY,ScopeProvider.instance.get());
		}
		connection.setRequestMethod(method);
		return connection;
	}		
	
}
