/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.whnmanager;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.gxhttp.request.GXHTTPStringRequest;
import org.gcube.common.gxhttp.util.ContentUtils;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.resourcemanagement.whnmanager.utils.ValidationUtils;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.security.SimpleCredentials;
import org.gcube.smartgears.security.defaults.DefaultAuthorizationProvider;
import org.gcube.smartgears.utils.InnerMethodName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/contexts")
public class ContextManager {
    private static Logger logger = LoggerFactory.getLogger(ContextManager.class);

    @PUT
    @Path(value="")
    public Response add(@FormParam(value="context") String context) {
        InnerMethodName.set((String)"addContext");
        Secret secret = SecretManagerProvider.get();
        logger.trace("WHNManager: addToContext method invokation with parameters context :{} and caller: {} curentContext: {}", new Object[]{context, secret.getOwner().getId(), secret.getContext()});
        try {
            ValidationUtils.valid((String)"context", (Object)context);
            ApplicationContext appContext = ContextProvider.get();
            if (context != null) {
                GXHTTPStringRequest request = GXHTTPStringRequest.newRequest((String)"https://conductor.dev.d4science.org/api");
                try {
                    request = request.path("workflow");
                    for (Map.Entry entry : secret.getHTTPAuthorizationHeaders().entrySet()) {
                        request = request.header((String)entry.getKey(), (String)entry.getValue());
                    }
                    SimpleCredentials credentials = ((DefaultAuthorizationProvider)appContext.container().authorizationProvider()).getCredentials();
                    HttpURLConnection response = request.post(String.format(" \"name\": \"ghn_client_add_to_contexts\",\n \"input\" : {\n     \"client_id\" : \"%s\",\n     \"context_list\" : [\"%s\"] }", credentials.getClientID(), context));
                    if (response.getResponseCode() != Response.Status.CREATED.getStatusCode()) {
                        throw new Exception("returned response is with status " + response.getResponseCode());
                    }
                    String body = ContentUtils.toString((byte[])ContentUtils.toByteArray((InputStream)response.getInputStream()));
                    logger.info("Returned response for remove scope {} ", (Object)body);
                    appContext.container().events().fire((Object)context, new String[]{"AddContextToContainer"});
                }
                catch (Exception e) {
                    logger.error("error adding context {}", (Object)context, (Object)e);
                    return Response.serverError().build();
                }
            } else {
                logger.error("context is null");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.ok().build();
        }
        catch (Throwable t) {
            logger.error("error adding context", t);
            throw new WebApplicationException(t);
        }
    }

    @DELETE
    @Path(value="")
    public Response remove(@QueryParam(value="context") String context) {
        InnerMethodName.set((String)"removeContext");
        Secret secret = SecretManagerProvider.get();
        logger.trace("WHNManager: removeFromContext method invokation with parameters context :{} and caller: {} curentContext: {}", new Object[]{context, secret.getOwner().getId(), secret.getContext()});
        try {
            ValidationUtils.valid((String)"context", (Object)context);
            ApplicationContext appContext = ContextProvider.get();
            if (context != null) {
                logger.trace("allowed container in context are {} ", (Object)appContext.container().authorizationProvider().getContexts());
                GXHTTPStringRequest request = GXHTTPStringRequest.newRequest((String)"https://conductor.dev.d4science.org/api");
                try {
                    request = request.path("workflow");
                    for (Map.Entry entry : secret.getHTTPAuthorizationHeaders().entrySet()) {
                        request = request.header((String)entry.getKey(), (String)entry.getValue());
                    }
                    SimpleCredentials credentials = ((DefaultAuthorizationProvider)appContext.container().authorizationProvider()).getCredentials();
                    HttpURLConnection response = request.post(String.format(" \"name\": \"ghn_client_remove_from_contexts\",\n \"input\" : {\n     \"client_id\" : \"%s\",\n     \"context_list\" : [\"%s\"] }", credentials.getClientID(), context));
                    if (response.getResponseCode() == Response.Status.CREATED.getStatusCode()) {
                        String body = ContentUtils.toString((byte[])ContentUtils.toByteArray((InputStream)response.getInputStream()));
                        logger.info("Returned response for remove scope {} ", (Object)body);
                    }
                    appContext.container().events().fire((Object)context, new String[]{"RemoveContextFromContainer"});
                }
                catch (Exception e) {
                    logger.error("error removing context {}", (Object)context, (Object)e);
                    return Response.serverError().build();
                }
            } else {
                logger.error("context is null");
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
            return Response.ok().build();
        }
        catch (Throwable t) {
            logger.error("error removing context", t);
            throw new WebApplicationException(t);
        }
    }

    @GET
    @Path(value="")
    @Produces(value={"application/json"})
    public String[] get() {
        InnerMethodName.set((String)"getContext");
        ApplicationContext appContext = ContextProvider.get();
        Set contexts = appContext.authorizationProvider().getContexts();
        return (String[])contexts.stream().toArray(String[]::new);
    }
}

