/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.whnmanager.jaxws.ws;

import javax.jws.WebService;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.ContainerInfo;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resourcemanagement.whnmanager.api.WhnManager;
import org.gcube.resourcemanagement.whnmanager.api.exception.GCUBEUnrecoverableException;
import org.gcube.resourcemanagement.whnmanager.api.exception.GCUBEUnrecoverableExceptionInfo;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.vremanagement.whnmanager.utils.ValidationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="WhnManagerIOPort", serviceName="gcube/vremanagement/ws/whnmanager", targetNamespace="http://gcube-system.org/", endpointInterface="org.gcube.resourcemanagement.whnmanager.api.WhnManager")
public class WhnManagerImpl
implements WhnManager {
    private static Logger logger = LoggerFactory.getLogger(WhnManagerImpl.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addToContext(String context) throws GCUBEUnrecoverableException {
        logger.trace("WHNManager: addToContext method invokation with parameters context :{} and caller: {} curentContext: {}", new Object[]{context, AuthorizationProvider.instance.get(), ScopeProvider.instance.get()});
        ValidationUtils.valid((String)"context", (Object)context);
        ApplicationContext appContext = ContextProvider.get();
        if (context == null) {
            logger.error("context is null");
            return false;
        }
        if (appContext.container().configuration().allowedContexts().contains(context)) {
            logger.warn("the context {} is already present ", (Object)context);
            return false;
        }
        if (!new ScopeBean(context).enclosingScope().toString().equals(ScopeProvider.instance.get())) {
            logger.error("the selected context {} is not enclosed in the context passed via token : authorization denied ", (Object)context);
            return false;
        }
        AuthorizationProxy proxy = ProviderFactory.provider().authorizationProxy();
        try {
            String token = proxy.requestActivation(new ContainerInfo(appContext.container().configuration().hostname(), appContext.container().configuration().port()), context);
            logger.trace("generated token is {}", (Object)token);
            appContext.events().fire((Object)token, new String[]{"AddTokenToContainer"});
            return true;
        }
        catch (Exception e) {
            logger.error("error contacting authorization service", (Throwable)e);
            throw new GCUBEUnrecoverableException(new GCUBEUnrecoverableExceptionInfo("error contacting authorization service"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean removeFromContext(String context) throws GCUBEUnrecoverableException {
        logger.trace("WHNManager: removeFromContext method invokation with parameters context :{} and caller: {} curentContext: {}", new Object[]{context, AuthorizationProvider.instance.get(), ScopeProvider.instance.get()});
        ValidationUtils.valid((String)"context", (Object)context);
        ApplicationContext appContext = ContextProvider.get();
        if (context == null) {
            logger.error("context is null");
            return false;
        }
        logger.trace("allowed container in context are {} ", (Object)appContext.container().configuration().allowedContexts());
        if (!appContext.container().configuration().allowedContexts().contains(context)) {
            logger.warn("the context {} is not present ", (Object)context);
            return false;
        }
        if (!new ScopeBean(context).enclosingScope().toString().equals(ScopeProvider.instance.get())) {
            logger.error("the selected context {} is not enclosed in the context passed via token : authorization denied ", (Object)context);
            return false;
        }
        AuthorizationProxy proxy = ProviderFactory.provider().authorizationProxy();
        try {
            String token = proxy.requestActivation(new ContainerInfo(appContext.container().configuration().hostname(), appContext.container().configuration().port()), context);
            logger.trace("token to remove is {}", (Object)token);
            appContext.events().fire((Object)token, new String[]{"RemoveTokenFromContainer"});
            return true;
        }
        catch (Exception e) {
            logger.error("error contacting authorization service", (Throwable)e);
            throw new GCUBEUnrecoverableException(new GCUBEUnrecoverableExceptionInfo("error contacting authorization service"));
        }
    }
}

