/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.whnmanager.client.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.exceptions.FaultDSL;
import org.gcube.common.vremanagement.whnmanager.client.proxies.WHNManagerProxy;
import org.gcube.resourcemanagement.whnmanager.api.WhnManager;
import org.gcube.resourcemanagement.whnmanager.api.exception.GCUBEUnrecoverableException;
import org.gcube.resourcemanagement.whnmanager.api.types.AddScopeInputParams;
import org.gcube.resourcemanagement.whnmanager.api.types.ScopeRIParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWHNManagerProxy
implements WHNManagerProxy {
    ProxyDelegate<WhnManager> delegate;
    private static Logger logger = LoggerFactory.getLogger(DefaultWHNManagerProxy.class);

    public DefaultWHNManagerProxy(ProxyDelegate<WhnManager> config) {
        this.delegate = config;
    }

    public boolean removeScope(final String identifier) throws GCUBEUnrecoverableException {
        Call<WhnManager, Boolean> call = new Call<WhnManager, Boolean>(){

            public Boolean call(WhnManager endpoint) throws Exception {
                return endpoint.removeScope(identifier);
            }
        };
        try {
            return (Boolean)this.delegate.make((Call)call);
        }
        catch (GCUBEUnrecoverableException e) {
            logger.error("no task found with id {}", (Object)identifier);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public boolean addScope(final AddScopeInputParams params) throws GCUBEUnrecoverableException {
        Call<WhnManager, Boolean> call = new Call<WhnManager, Boolean>(){

            public Boolean call(WhnManager endpoint) throws Exception {
                return endpoint.addScope(params);
            }
        };
        try {
            return (Boolean)this.delegate.make((Call)call);
        }
        catch (GCUBEUnrecoverableException e) {
            logger.error("no task found with id {}", (Object)params);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public boolean addRIToScope(final ScopeRIParams params) throws GCUBEUnrecoverableException {
        Call<WhnManager, Boolean> call = new Call<WhnManager, Boolean>(){

            public Boolean call(WhnManager endpoint) throws Exception {
                return endpoint.addRIToScope(params);
            }
        };
        try {
            return (Boolean)this.delegate.make((Call)call);
        }
        catch (GCUBEUnrecoverableException e) {
            logger.error("no task found with id {}", (Object)params);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }

    public boolean removeRIFromScope(final ScopeRIParams params) throws GCUBEUnrecoverableException {
        Call<WhnManager, Boolean> call = new Call<WhnManager, Boolean>(){

            public Boolean call(WhnManager endpoint) throws Exception {
                return endpoint.removeRIFromScope(params);
            }
        };
        try {
            return (Boolean)this.delegate.make((Call)call);
        }
        catch (GCUBEUnrecoverableException e) {
            logger.error("no task found with id {}", (Object)params);
            throw e;
        }
        catch (Exception e) {
            throw FaultDSL.again((Throwable)e).asServiceException();
        }
    }
}

