/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl.util;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.SelectArg;
import com.j256.ormlite.support.ConnectionSource;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.deploy.UndeployVRE;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VRE;
import org.gcube.vremanagement.vremodeler.utils.reports.Status;

public class ExpiredVREFinderTask {
    private static HashMap<String, ExpiredVREFinderTask> taskMap = new HashMap();
    GCUBELog logger = new GCUBELog(ExpiredVREFinderTask.class);
    Timer timer;
    Dao<VRE, String> vreDao;
    PreparedQuery<VRE> preparedQuery;

    public static ExpiredVREFinderTask get(GCUBEScope scope) throws Exception {
        if (!taskMap.containsKey(scope.toString())) {
            ExpiredVREFinderTask task = new ExpiredVREFinderTask(scope);
            taskMap.put(scope.toString(), task);
            return task;
        }
        return taskMap.get(scope.toString());
    }

    private ExpiredVREFinderTask(GCUBEScope scope) throws Exception {
        this.vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(scope), VRE.class);
        this.logger.trace((Object)("object created in scope " + scope.toString()));
        SelectArg selectArg = new SelectArg();
        this.preparedQuery = this.vreDao.queryBuilder().where().lt("intervalTo", (Object)selectArg).prepare();
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new ExpiredTask(scope), 60000L, 36000000L);
    }

    public void cancel() {
        this.timer.cancel();
    }

    class ExpiredTask
    extends TimerTask {
        GCUBEScope scope;

        ExpiredTask(GCUBEScope scope) {
            this.scope = scope;
        }

        @Override
        public void run() {
            ExpiredVREFinderTask.this.logger.trace((Object)("executing task in scope " + this.scope.toString()));
            try {
                ExpiredVREFinderTask.this.preparedQuery.setArgumentHolderValue(0, (Object)Calendar.getInstance().getTimeInMillis());
                for (VRE vre : ExpiredVREFinderTask.this.vreDao.query(ExpiredVREFinderTask.this.preparedQuery)) {
                    ExpiredVREFinderTask.this.logger.trace((Object)("vre " + vre.getName() + " found with status " + vre.getStatus()));
                    if (!vre.getStatus().equals(Status.Deployed.toString())) continue;
                    ExpiredVREFinderTask.this.logger.trace((Object)("preparing to undeploy vre " + vre.getName()));
                    UndeployVRE undeploy = new UndeployVRE(vre.getId());
                    ServiceContext.getContext().setScope(undeploy, this.scope);
                    undeploy.start();
                }
            }
            catch (Exception e) {
                ExpiredVREFinderTask.this.logger.warn((Object)"error executing task for expired vres", (Throwable)e);
            }
        }
    }
}

