/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.handlers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Ghn;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.RunningInstance;
import org.gcube.vremanagement.vremodeler.resources.handlers.ResourceHandler;

public class RunningInstancesHandler
implements ResourceHandler<RunningInstance> {
    private static GCUBELog logger = new GCUBELog(RunningInstancesHandler.class);
    public static final String tableName = "RunningInstance";
    private Ghn relatedGhn;

    public RunningInstancesHandler(Ghn ghn) {
        this.relatedGhn = ghn;
    }

    public RunningInstancesHandler() {
        this.relatedGhn = null;
    }

    @Override
    public List<RunningInstance> initialize() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBERIQuery queryRI = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
        queryRI.addGenericCondition("$result/Profile/GHN[string(@UniqueID) eq '" + this.relatedGhn.getId() + "']");
        List riList = client.execute((ISQuery)queryRI, ServiceContext.getContext().getScope());
        ArrayList<RunningInstance> toReturn = new ArrayList<RunningInstance>();
        for (GCUBERunningInstance gcubeRunningInstance : riList) {
            try {
                RunningInstance ri = new RunningInstance(gcubeRunningInstance.getID(), gcubeRunningInstance.getServiceClass(), gcubeRunningInstance.getServiceName());
                ri.setGhn(this.relatedGhn);
                this.insert(ri);
                toReturn.add(ri);
            }
            catch (Exception e) {
                logger.error((Object)"error inserting values in RunningInstance", (Throwable)e);
            }
        }
        return toReturn;
    }

    private void insert(RunningInstance ri) throws Exception {
        Dao runningInstanceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), RunningInstance.class);
        ri.setGhn(this.relatedGhn);
        if (runningInstanceDao.idExists((Object)ri.getId())) {
            runningInstanceDao.update((Object)ri);
        } else {
            runningInstanceDao.create((Object)ri);
        }
        logger.trace((Object)"runningInstance added ");
    }

    @Override
    public void add(RunningInstance resource) throws Exception {
        this.insert(resource);
    }

    @Override
    public void drop(String riId) throws Exception {
        Dao runningInstanceDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), RunningInstance.class);
        runningInstanceDao.deleteById((Object)riId);
    }
}

