/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.resources.handlers;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Collection;
import org.gcube.vremanagement.vremodeler.resources.handlers.ResourceHandler;

public class CollectionHandler
implements ResourceHandler<Collection> {
    private static GCUBELog logger = new GCUBELog(CollectionHandler.class);

    @Override
    public void add(Collection resource) throws Exception {
        this.insert(resource);
    }

    @Override
    public void drop(String collectionId) throws Exception {
        Dao collectionDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Collection.class);
        collectionDao.deleteById((Object)collectionId);
    }

    @Override
    public List<Collection> initialize() throws Exception {
        ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
        GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
        query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Body/CollectionInfo/user", "true"), new AtomicCondition("/Profile/SecondaryType", "GCUBECollection")});
        List gcubeCollectionList = client.execute((ISQuery)query, ServiceContext.getContext().getScope());
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (GCUBEGenericResource gcubeCollection : gcubeCollectionList) {
            try {
                Collection collection = new Collection(gcubeCollection.getID(), gcubeCollection.getName(), gcubeCollection.getDescription() == null ? "not provided" : gcubeCollection.getDescription());
                this.insert(collection);
                collections.add(collection);
            }
            catch (Exception e) {
                logger.error((Object)"error inserting collections", (Throwable)e);
            }
        }
        return collections;
    }

    private void insert(Collection collection) throws Exception {
        Dao collectionDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), Collection.class);
        collectionDao.createOrUpdate((Object)collection);
        logger.trace((Object)("inserting collection with id " + collection.getId()));
    }
}

