package org.gcube.vremanagement.vremodeler.resources.handlers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.Ghn;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;

public class GHNHandler implements ResourceHandler<Ghn> {

	private static GCUBELog logger = new GCUBELog(GHNHandler.class);
	
	public static final String tableName="GHN";
		
	public List<Ghn> initialize() throws Exception{
		
		ISClient client= GHNContext.getImplementation(ISClient.class);
		GCUBEGHNQuery query=client.getQuery(GCUBEGHNQuery.class);
		query.addAtomicConditions(new AtomicCondition("/Profile/GHNDescription/Type","Dynamic"));
		query.addAtomicConditions(new AtomicCondition("/Profile/GHNDescription/Status","certified"));
		List<GCUBEHostingNode> gcubeHostingNodeList= client.execute(query, ServiceContext.getContext().getScope());
		List<Ghn> ghns = new ArrayList<Ghn>();
		for (GCUBEHostingNode gcubeHostingNode:gcubeHostingNodeList)
			try{
				Ghn ghn = new Ghn(gcubeHostingNode.getID(), gcubeHostingNode.getNodeDescription().getName(),gcubeHostingNode.getSite().getLocation(), 
						gcubeHostingNode.getSite().getCountry(), gcubeHostingNode.getSite().getDomain(),gcubeHostingNode.getNodeDescription().getMemory().getAvailable(), gcubeHostingNode.getNodeDescription().getLocalAvailableSpace(), false);
				ghn.setSecurityEnabled(gcubeHostingNode.getNodeDescription().isSecurityEnabled());
				insert(ghn);
				ghns.add(ghn);
			}catch(Exception e){logger.error("error inserting values in "+tableName, e);}
		return ghns;
	}
	
	private void insert(Ghn ghn) throws Exception {
		logger.trace("adding a GHN with id "+ghn.getId());
		RunningInstancesHandler riHandler= new RunningInstancesHandler(ghn);
		riHandler.initialize();
		Dao<Ghn, String> ghnDao =
	            DaoManager.createDao(DBInterface.connect(), Ghn.class);
		if (ghnDao.idExists(ghn.getId()))
			ghnDao.update(ghn);
		else ghnDao.create(ghn);
	}

	public void add(Ghn resource) throws Exception {
		this.insert(resource);
		
	}

	public void drop(String ghnId) throws Exception {
		Dao<Ghn, String> ghnDao =
	            DaoManager.createDao(DBInterface.connect(), Ghn.class);
		ghnDao.deleteById(ghnId);
	}
	
}
