/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl.deploy;

import java.util.Arrays;
import net.java.dev.jaxb.array.StringArray;
import org.apache.axis.client.Stub;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.eolusclient.Eolus;
import org.gcube.common.eolusclient.EolusServiceLocator;
import org.gcube.common.eolusclient.startContainer;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.stubs.deployreport.GHNonCloudReport;
import org.gcube.vremanagement.vremodeler.stubs.deployreport.Status;

public class DeployGHNsOnCloud {
    private static GCUBELog logger = new GCUBELog(DeployGHNsOnCloud.class);
    int numberOfVMs;
    private String vreName;
    private GHNonCloudReport report;

    public DeployGHNsOnCloud(int numberOfVMs, String vreName) {
        this.numberOfVMs = numberOfVMs;
        this.vreName = vreName;
        this.report = new GHNonCloudReport();
        this.report.setStatus(Status.Waiting);
    }

    public GHNonCloudReport getReport() {
        return this.report;
    }

    public String[] run() throws Exception {
        this.report.setStatus(Status.Running);
        String username = "gcube";
        String password = "gcube.cloud.2010";
        EolusServiceLocator servicelocator = new EolusServiceLocator();
        Eolus eolus = servicelocator.getEolusPort();
        ((Stub)eolus)._setProperty("javax.xml.rpc.security.auth.username", (Object)username);
        ((Stub)eolus)._setProperty("javax.xml.rpc.security.auth.password", (Object)password);
        this.report.setDeployingState(new Status[this.numberOfVMs]);
        Arrays.fill(this.report.getDeployingState(), Status.Waiting);
        VM[] hostnames = this.createVMs(eolus);
        this.configureAndStartContainers(eolus, hostnames);
        Thread.sleep(60000L);
        this.checkGHNAvailability(hostnames);
        String[] ghns = new String[hostnames.length];
        for (int i = 0; i < hostnames.length; ++i) {
            ghns[i] = hostnames[i].getName();
        }
        this.report.setStatus(Status.Finished);
        return ghns;
    }

    private VM[] createVMs(Eolus eolus) throws Exception {
        String[] nets = new String[]{"public"};
        StringArray vnets = new StringArray();
        vnets.setItem(nets);
        String template = eolus.getTemplates().getItem()[0];
        logger.trace((Object)("got the template: " + template));
        VM[] vmsNames = new VM[this.numberOfVMs];
        eolus.createVM(template, this.vreName + "ResourceManager", 2, 1024, vnets);
        vmsNames[0] = new VM(this.vreName + "ResourceManager");
        logger.trace((Object)("creating the first VM for ResourceManager " + this.vreName + "ResourceManager"));
        this.report.getDeployingState()[0] = Status.Running;
        for (int i = 1; i < this.numberOfVMs; ++i) {
            eolus.createVM(template, this.vreName + i, 2, 2048, vnets);
            vmsNames[i] = new VM(this.vreName + i);
            this.report.getDeployingState()[i] = Status.Running;
            logger.trace((Object)("creating the VM" + i + "  " + this.vreName + i));
        }
        logger.trace((Object)"checking the VMs Availability");
        Thread.sleep(30000L);
        boolean[] arrayCheck = new boolean[this.numberOfVMs];
        Arrays.fill(arrayCheck, false);
        while (!this.and(arrayCheck)) {
            Thread.sleep(30000L);
            for (int i = 0; i < this.numberOfVMs; ++i) {
                try {
                    String vmState;
                    if (arrayCheck[i] || !(vmState = eolus.getVMStatus(vmsNames[i].getName())).equalsIgnoreCase("running")) continue;
                    arrayCheck[i] = true;
                    vmsNames[i].setIp(eolus.getVMIP(vmsNames[i].getName()));
                    logger.trace((Object)("the VM " + vmsNames[i].getName() + " is RUNNING with ip " + vmsNames[i].getIp()));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("error deploying " + vmsNames[i].getName()), (Throwable)e);
                    this.report.getDeployingState()[i] = Status.Failed;
                    throw e;
                }
            }
        }
        Thread.sleep(180000L);
        return vmsNames;
    }

    private void configureAndStartContainers(Eolus eolus, VM[] hostnames) throws Exception {
        int i;
        Thread.sleep(30000L);
        String[] scopes = ServiceContext.getContext().getScope().toString().split("/");
        String cmdtorun = "configureGHN.sh " + scopes[1] + " " + scopes[2];
        logger.trace((Object)("configuring ghns with command " + cmdtorun));
        for (i = 0; i < hostnames.length; ++i) {
            String[] res = eolus.execCMD(cmdtorun, hostnames[i].getName()).getItem();
            logger.trace((Object)("configuring the GHN on host for VM " + hostnames[i].getName() + " got the following report:"));
            logger.trace((Object)("std output " + res[0]));
            if (res.length <= 2) continue;
            this.report.getDeployingState()[i] = Status.Failed;
            logger.trace((Object)("std error " + res[1]));
        }
        Thread.sleep(60000L);
        for (i = 0; i < hostnames.length; ++i) {
            startContainer startcontainerthread = new startContainer(eolus, hostnames[i].getName());
            startcontainerthread.start();
        }
    }

    private void checkGHNAvailability(VM[] hostnames) throws Exception {
        boolean[] arrayCheck = new boolean[hostnames.length];
        Arrays.fill(arrayCheck, false);
        while (!this.and(arrayCheck)) {
            logger.trace((Object)"checking published GHNs");
            Thread.sleep(40000L);
            for (int i = 0; i < hostnames.length; ++i) {
                if (!arrayCheck[i]) continue;
            }
        }
    }

    private boolean and(boolean ... array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i]) continue;
            return false;
        }
        return true;
    }

    public class VM {
        private String ip = null;
        private String name;
        private String ghnId = null;

        public VM(String name) {
            this.name = name;
        }

        public String getIp() {
            return this.ip;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getGhnId() {
            return this.ghnId;
        }

        public void setGhnId(String ghnId) {
            this.ghnId = ghnId;
        }
    }
}

