/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.vremodeler.impl;

import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.DaoManager;
import com.j256.ormlite.support.ConnectionSource;
import java.util.List;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.types.VOID;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.vremodeler.db.DBInterface;
import org.gcube.vremanagement.vremodeler.impl.ModelerContext;
import org.gcube.vremanagement.vremodeler.impl.ModelerResource;
import org.gcube.vremanagement.vremodeler.impl.ServiceContext;
import org.gcube.vremanagement.vremodeler.impl.peristentobjects.VRE;
import org.gcube.vremanagement.vremodeler.stubs.GetExistingNamesResponseMessage;
import org.gcube.vremanagement.vremodeler.stubs.Report;
import org.gcube.vremanagement.vremodeler.stubs.ReportList;
import org.globus.wsrf.ResourceKey;

public class ModelFactoryService {
    private GCUBELog logger = new GCUBELog(ModelFactoryService.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public EndpointReferenceType createResource() throws GCUBEFault {
        String id = uuidGen.nextUUID();
        this.logger.trace((Object)("resource " + id + " created"));
        try {
            ModelerContext pctx = ModelerContext.getPortTypeContext();
            ModelerResource mr = (ModelerResource)pctx.getWSHome().create(pctx.makeKey(id), new Object[]{id});
            mr.store();
            return mr.getEPR();
        }
        catch (Exception e) {
            this.logger.error((Object)"error creating resource", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public GetExistingNamesResponseMessage getExistingNamesVREs(VOID arg) throws GCUBEFault {
        try {
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            List vres = vreDao.query(vreDao.queryBuilder().selectColumns(new String[]{"name"}).prepare());
            String[] toReturn = new String[vres.size()];
            for (int i = 0; i < vres.size(); ++i) {
                toReturn[i] = ((VRE)vres.get(i)).getName();
            }
            GetExistingNamesResponseMessage response = new GetExistingNamesResponseMessage();
            response.setNames(toReturn);
            return response;
        }
        catch (Exception e) {
            this.logger.error((Object)"error on DB", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public void initDB(VOID arg) throws GCUBEFault {
        this.logger.debug((Object)"initDB method");
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ServiceContext.getContext().intializeDB();
                }
                catch (Exception e) {
                    ModelFactoryService.this.logger.error((Object)"DB inizialization failed", (Throwable)e);
                }
            }
        };
        t.start();
    }

    public ReportList getAllVREs(VOID arg) throws GCUBEFault {
        try {
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            List vres = vreDao.queryForAll();
            Report[] toReturn = new Report[vres.size()];
            for (int i = 0; i < vres.size(); ++i) {
                Report reportItem;
                VRE vreItem = (VRE)vres.get(i);
                toReturn[i] = reportItem = new Report(vreItem.getDescription(), vreItem.getId(), vreItem.getName(), vreItem.getStatus());
            }
            return new ReportList(toReturn);
        }
        catch (Exception e) {
            this.logger.error((Object)"error on DB", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public VOID removeVRE(String id) throws GCUBEFault {
        this.logger.trace((Object)("Deleting resource with id " + id));
        try {
            ModelerContext pctx = ModelerContext.getPortTypeContext();
            Dao vreDao = DaoManager.createDao((ConnectionSource)DBInterface.connect(), VRE.class);
            vreDao.deleteById((Object)id);
            pctx.getWSHome().remove((ResourceKey)pctx.makeKey(id));
            return new VOID();
        }
        catch (Exception e) {
            this.logger.error((Object)"error removing resource", (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[0]);
        }
    }

    public EndpointReferenceType getEPRbyId(String id) throws GCUBEFault {
        ModelerContext pctx = ModelerContext.getPortTypeContext();
        try {
            return pctx.getWSHome().find((ResourceKey)pctx.makeKey(id)).getEPR();
        }
        catch (Exception e) {
            this.logger.error((Object)("resource with id " + id + " not found"), (Throwable)e);
            throw new GCUBEFault((Throwable)e, new String[]{"resource with id " + id + " not found"});
        }
    }
}

