/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.virtualplatform.image;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.gcube.vremanagement.virtualplatform.image.ParentLastClassLoader;

class PlatformLoader {
    ParentLastClassLoader cl;

    PlatformLoader(File[] resources) throws MalformedURLException {
        this.create(resources);
    }

    private void create(File[] resources) throws MalformedURLException {
        URL[] urls = new URL[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            urls[i] = new URL("file://" + resources[i].getAbsolutePath());
        }
        this.cl = new ParentLastClassLoader(urls, this.getClass().getClassLoader());
    }

    public Object invoke(Object obj, String method, Object ... params) throws Exception {
        try {
            return obj.getClass().getMethod(method, new Class[0]).invoke(obj, params);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public Class<?> load(String name) throws ClassNotFoundException {
        return this.cl.loadClass(name);
    }

    public Object getInstanceOf(String name, Object ... params) throws Exception {
        Constructor<?> constructor = this.cl.loadClass(name).getConstructor(new Class[0]);
        return constructor.newInstance(params != null ? params : new Object[]{});
    }
}

