package org.gcube.vremanagement.virtualplatform.tomcat;

import java.io.File;
import java.util.Properties;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.vremanagement.virtualplatform.model.DeployedPackage;
import org.gcube.vremanagement.virtualplatform.model.Package;

/**
 * A deployed web application
 * 
 * @author Manuele Simi (ISTI-CNR)
 *
 */
public class DeployedWebapp implements DeployedPackage {

	private Webapp app;
	private String[] endpoints = new String[]{};
	private boolean success = false;
	
	public DeployedWebapp(Webapp app) {
		this.app = app;
	}
	
	/**
	 * @return
	 * @see org.gcube.vremanagement.deployer.client.common.BasePackage#getName()
	 */
	public String getName() {
		return app.getName();
	}
	/**
	 * @return
	 * @see org.gcube.vremanagement.virtualplatform.tomcat.Webapp#getTargetPlatform()
	 */
	public String getTargetPlatform() {
		return app.getTargetPlatform();
	}
	/**
	 * @return
	 * @see org.gcube.vremanagement.deployer.client.common.BasePackage#getServiceName()
	 */
	public String getServiceName() {
		return app.getServiceName();
	}
	/**
	 * @return
	 * @see org.gcube.vremanagement.deployer.client.common.BasePackage#getServiceClass()
	 */
	public String getServiceClass() {
		return app.getServiceClass();
	}
	/**
	 * @return
	 * @see org.gcube.vremanagement.deployer.client.common.BasePackage#getScope()
	 */
	public GCUBEScope getScope() {
		return app.getScope();
	}
	/**
	 * @return
	 * @see org.gcube.vremanagement.deployer.client.common.BasePackage#getFolder()
	 */
	public File getFolder() {
		return app.getFolder();
	}
	/**
	 * @return
	 * @see org.gcube.vremanagement.deployer.client.common.BasePackage#getPropeties()
	 */
	public Properties getPropeties() {
		return app.getPropeties();
	}
	/**
	 * @return
	 * @see org.gcube.vremanagement.deployer.client.common.BasePackage#getProfile()
	 */
	public String getProfile() {
		return app.getProfile();
	}

	@Override
	public boolean isSuccess() {
		return this.success;
	}
	
	public void setSuccess(boolean success) {
		this.success = success;
	}
	
	@Override
	public boolean verify() {
		return false;
	}
	@Override
	public Package getSourcePackage() {
		return this.app;
	}

	@Override
	public String[] getEndpoints() {
		return this.endpoints;
	}

	public void setEndpoints(String[] endpoints) {
		this.endpoints = endpoints;
	}

	

}
