/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwarerepository.stubs.testsuite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.vremanagement.softwarerepository.stubs.SoftwareRepositoryPortType;
import org.gcube.vremanagement.softwarerepository.stubs.Store;
import org.gcube.vremanagement.softwarerepository.stubs.StoreItem;
import org.gcube.vremanagement.softwarerepository.stubs.service.SoftwareRepositoryServiceAddressingLocator;

public class StoreTest {
    private static String scope = "/gcube/testing";

    public static void main(String[] args) {
        List<StoreItem> storeItemsList;
        if (args.length < 3 || args.length > 4) {
            System.out.println("Usage:");
            System.out.println("\tjava  StoreTest  SoftwareRepositoryEPR  txtURL  ReportFileName  scope[default:/gcube/testing] \n\n");
            System.out.println("Example:");
            System.out.println("\tjava  StoreTest  http://grid6.4dsoft.hu:8080/wsrf/services/gcube/vremanagement/softwarerepository/SoftwareRepository  http://grids16.eng.it/BuildReport/builds/recent%20builds/org.gcube.HEAD/latest/packages.txt  report.xml  /gcube/testing \n\n");
            System.out.println("The txt must cointains an URL for each row. Each row is analized and only the one with \"servicearchive\" contained will be submitted to Software Repository\n\n");
            return;
        }
        File reportFile = new File(args[2]);
        if (reportFile.exists()) {
            System.out.println("The store report xml file already exist and it will be replaced");
        }
        if (args.length == 4) {
            scope = args[3];
        }
        GCUBEScope gCubeScope = GCUBEScope.getScope((String)scope);
        EndpointReferenceType epr = new EndpointReferenceType();
        String serviceURI = args[0];
        try {
            epr.setAddress(new AttributedURI(serviceURI));
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
            return;
        }
        SoftwareRepositoryServiceAddressingLocator locator = new SoftwareRepositoryServiceAddressingLocator();
        SoftwareRepositoryPortType portType = null;
        try {
            portType = locator.getSoftwareRepositoryPortTypePort(epr);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        try {
            portType = (SoftwareRepositoryPortType)GCUBERemotePortTypeContext.getProxy((Remote)portType, (GCUBEScope)gCubeScope, (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            e.printStackTrace();
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String txtURL = args[1];
        try {
            storeItemsList = StoreTest.parseTxtFile(txtURL);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        StoreItem[] storeItems = new StoreItem[storeItemsList.size()];
        for (int i = 0; i < storeItems.length; ++i) {
            storeItems[i] = storeItemsList.get(i);
            System.out.println("storeMessages[" + i + "] URL = " + storeItems[i].getURL() + "\n\n");
        }
        Store store = new Store();
        store.setStoreMessage(storeItems);
        try {
            String ret = portType.store(store);
            StoreTest.stringToFile(ret, reportFile);
            System.out.println(ret + "\n\n");
        }
        catch (GCUBEFault e) {
            System.out.println("Error storing one or more service archives \n\n");
            e.printStackTrace();
            return;
        }
        catch (RemoteException e) {
            System.out.println("Error storing one or more service archives \n\n");
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            System.out.println("Error writing xml report on file \n\n");
            e.printStackTrace();
            return;
        }
    }

    private static void stringToFile(String str, File targetFile) throws IOException {
        FileWriter fw = new FileWriter(targetFile);
        fw.write(str);
        fw.flush();
        fw.close();
    }

    private static List<StoreItem> parseTxtFile(String txtURL) throws IOException {
        ArrayList<StoreItem> ret = new ArrayList<StoreItem>();
        try {
            System.out.println("Opening URL connection to " + txtURL);
            URL url = new URL(txtURL);
            HttpURLConnection httpURLConnection = (HttpURLConnection)url.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setUseCaches(false);
            System.out.println("Getting data from given URL " + txtURL);
            InputStream is = httpURLConnection.getInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            System.out.println("Connection return code: " + httpURLConnection.getResponseCode());
            System.out.println("Bytes available: " + is.available() + "\n\n\n");
            String nextStr = bufferedReader.readLine();
            while (nextStr != null) {
                String row = nextStr.toLowerCase();
                if (!row.contains("servicearchive")) {
                    System.out.println(nextStr + " does not contain a service archive\n\n");
                    nextStr = bufferedReader.readLine();
                    continue;
                }
                System.out.println("Row: " + nextStr);
                String serviceClass = "Class";
                System.out.println("Service Class = " + serviceClass);
                String serviceName = "Name";
                System.out.println("Service Name = " + serviceName);
                String version = nextStr.split("-servicearchive-")[1];
                version = version.split("-")[0];
                System.out.println("Version = " + version);
                String softwareArchiveURL = nextStr;
                System.out.println("URL = " + nextStr);
                String description = "ETICS Client programmed Description";
                System.out.println("Description = " + description + "\n\n\n");
                String[] scopes = new String[]{scope};
                StoreItem storeItem = new StoreItem();
                storeItem.setServiceClass(serviceClass);
                storeItem.setServiceName(serviceName);
                storeItem.setServiceVersion(version);
                storeItem.setURL(softwareArchiveURL);
                storeItem.setDescription(description);
                storeItem.setScopes(scopes);
                ret.add(storeItem);
                nextStr = bufferedReader.readLine();
            }
            bufferedReader.close();
            httpURLConnection.disconnect();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        System.out.flush();
        return ret;
    }
}

