package org.gcube.vremanagement.softwaregateway.client;

import java.rmi.RemoteException;

import javax.xml.rpc.ServiceException;

import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI.MalformedURIException;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
import org.gcube.vremanagement.softwaregateway.stubs.AccessPortType;
import org.gcube.vremanagement.softwaregateway.stubs.GetPackageResponse;
import org.gcube.vremanagement.softwaregateway.stubs.LocationItem;
import org.gcube.vremanagement.softwaregateway.stubs.PackageCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.ServiceCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.service.AccessServiceAddressingLocator;

public class GetPackagesClient {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		for (int i=0; i<args.length;i++) 
			System.out.println("param N." +i + ": " + args[i]);
		
		if(args.length != 5 ){
			System.out.println("Usage:");
			System.out.println("\tjava  GetPackagesClient   SoftwareGatewayEPR  scope  ServiceName   ServiceClass   ServiceVersion \n\n");
			System.out.println("Example:");
			System.out.println("\tjava  GetPackagesClient  http://node2.d.d4science.research-infrastructures.eu:9001/wsrf/services/gcube/vremanagement/softwaregateway/Registration /gcube/devsec Test3 TestProfile3 1.00.00 \n\n");
			return;
		}
		EndpointReferenceType endpoint = new EndpointReferenceType();
		try {
			endpoint.setAddress(new AttributedURI(args[0]));
		} catch (MalformedURIException e) {
			e.printStackTrace();
			return;
		}
		AccessPortType stub;
		try {
			stub = new AccessServiceAddressingLocator().getAccessPortTypePort(endpoint);
		} catch (ServiceException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return;
		}
		try {
			stub=GCUBERemotePortTypeContext.getProxy(stub,GCUBEScope.getScope(args[1]));
		} catch (MalformedScopeExpressionException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
		String serviceClass=args[2];
		String serviceName=args[3];
		String serviceVersion=args[4];
		ServiceCoordinates sc=new ServiceCoordinates();
		sc.setServiceClass(serviceClass);
		sc.setServiceName(serviceName);
		sc.setServiceVersion(serviceVersion);
		GetPackageResponse response=null;
		try {
			response = stub.getPackages(sc);
		} catch (GCUBEFault e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (RemoteException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		if(response != null){
			LocationItem [] items=response.getItems();
			if(items != null){
				System.out.println("List of packages founded: \n"+items.length);
				for (LocationItem item : items){
					System.out.println(" found package: "+item.getPackageName()+"  version: "+item.getPackageVersion());
				}
			}
		}
	}

}
