/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.impl.repositorymanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.FileUtils;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.Coordinates;
import org.gcube.vremanagement.softwaregateway.impl.coordinates.MavenCoordinates;
import org.gcube.vremanagement.softwaregateway.impl.exceptions.ServiceNotAvaiableFault;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.RepositoryManager;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.cache.NexusCache;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.parsing.XmlParse;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.ArchiveManagement;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.FileUtilsExtended;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.NexusRestConnector;
import org.xml.sax.SAXException;

public class NexusRepositoryManager
extends RepositoryManager {
    public static final String TEMPORARY_SA_FILE_NAME = "sa_tar_file.tar.gz";
    protected final GCUBELog logger = new GCUBELog(NexusRepositoryManager.class);
    private HttpClient client;
    public NexusCache cache = null;
    public static NexusRepositoryManager singleton;

    public NexusRepositoryManager(String[] mavenServerList, boolean cacheEnabled) {
        super(mavenServerList);
        this.cacheEnabled = cacheEnabled;
        if (cacheEnabled) {
            this.cache = NexusCache.getInstance(mavenServerList);
        }
    }

    @Override
    public String get(Object mavenC, String extension, String classifier) throws MalformedURLException, ServiceNotAvaiableFault {
        this.logger.debug((Object)("get method: get maven object with extension " + extension + ""));
        MavenCoordinates mc = (MavenCoordinates)mavenC;
        this.logger.debug((Object)("mavenCoordinates " + mc.getGroupId() + " " + mc.getArtifactId() + " " + mc.getVersion()));
        if (mc != null) {
            String url = null;
            if (this.cacheEnabled) {
                this.logger.debug((Object)"cache enabled ");
                url = this.cache.get(mavenC, extension, classifier);
            }
            if (url != null) {
                this.logger.debug((Object)"url found in cache");
                return url;
            }
            this.logger.debug((Object)("and coordinates: g: " + mc.getGroupId() + " a: " + mc.getArtifactId() + " v: " + mc.getVersion()));
            if (servers == null) {
                this.logger.debug((Object)" list of servers is null ");
            } else {
                this.logger.debug((Object)("list of servers is not null " + servers));
            }
            this.logger.debug((Object)("number of servers founded: " + servers.length));
            for (int i = 0; i < servers.length; ++i) {
                this.logger.debug((Object)(" get method search artifact: " + mc.getArtifactId() + "  with extension: " + extension));
                url = extension.equalsIgnoreCase("pom") ? this.searchArtifact(servers[i], mc.getGroupId(), mc.getArtifactId(), "jar", mc.getVersion(), true, classifier) : this.searchArtifact(servers[i], mc.getGroupId(), mc.getArtifactId(), extension, mc.getVersion(), false, classifier);
                if (url == null || url.isEmpty() || !this.cacheEnabled) continue;
                String cacheCoordinates = this.cache.buildMavenCoordinatesCacheInputString(mc, extension, classifier);
                this.cache.put(cacheCoordinates, url);
                break;
            }
            this.logger.debug((Object)("get Method url returned: " + url));
            if (url == null) {
                throw new ServiceNotAvaiableFault("url is null ");
            }
            return url;
        }
        this.logger.debug((Object)"invalid maven coordinates");
        return null;
    }

    @Override
    public String extractDepsFromMavenEmb(String url) throws ServiceNotAvaiableFault {
        this.logger.debug((Object)("extractDepsFromMavenEmb method with url: " + url));
        NexusRestConnector nc = new NexusRestConnector();
        String result = null;
        if (this.cacheEnabled) {
            result = this.cache.extractDepsFromMavenEmb(url);
        }
        if (result != null) {
            return result;
        }
        try {
            byte[] pom = nc.getAsByteArray(new URL(url));
            this.logger.debug((Object)"pom converted in byte array");
            this.logger.debug((Object)("extract deps from pom: " + pom + " and first server" + servers[0]));
            result = nc.extractDepsFromPomByMavenEmb(pom, servers);
            if (this.cacheEnabled) {
                this.cache.put(url, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new ServiceNotAvaiableFault(e.getMessage());
        }
    }

    private File downloadSA(File targetDirectory, String fromURL) throws IOException {
        this.logger.debug((Object)("Trying to download Archive from: " + fromURL + ", to = " + targetDirectory));
        if (targetDirectory.exists()) {
            this.logger.debug((Object)("Deleting old tmp directory\ntmp directory path = " + targetDirectory.getAbsolutePath()));
            FileUtilsExtended.recursiveDeleteDirectory(targetDirectory);
        }
        this.logger.debug((Object)("Creating tmp directory\ntmp directory path = " + targetDirectory.getAbsolutePath()));
        targetDirectory.mkdirs();
        Object archive = null;
        NexusRestConnector nc = new NexusRestConnector();
        byte[] saByte = nc.getAsByteArray(new URL(fromURL));
        String cfgDir = (String)ServiceContext.getContext().getProperty("configDir", new boolean[]{false});
        File sa = nc.byteToFile(cfgDir, System.currentTimeMillis() + "-" + TEMPORARY_SA_FILE_NAME, saByte);
        return sa;
    }

    @Override
    public String searchArtifact(String baseUrl, String groupName, String artifact, String extension, String ver, boolean pom, String classifier) throws MalformedURLException {
        this.logger.debug((Object)("searchArtifact method from " + baseUrl + " with coordinates gId: " + groupName + " aId: " + artifact + " version: " + ver + " and extension: " + extension + " and classifier " + classifier));
        this.client = this.getClient();
        StringBuffer param = new StringBuffer();
        String artifactId = artifact;
        String classifierId = classifier;
        if (artifact.contains("#")) {
            String[] splitting = artifact.split("\\#");
            artifactId = splitting[0];
            classifierId = splitting[1];
        }
        if (ver != null) {
            param.append("g=" + groupName.trim() + "&a=" + artifactId.trim() + "&v=" + ver);
        } else {
            param.append("g=" + groupName.trim() + "&a=" + artifactId.trim() + "&v=LATEST");
        }
        String localUrl = baseUrl + "/service/local/data_index/repo_groups/mycompany/content?" + param.toString();
        String centralUrl = null;
        centralUrl = baseUrl + "/service/local/artifact/maven/redirect?r=central&" + param.toString();
        this.logger.debug((Object)("getMethod with url: " + localUrl));
        GetMethod method = new GetMethod(localUrl);
        this.logger.debug((Object)"connect to server ");
        String xml = this.connect(method);
        this.logger.debug((Object)(" server response: " + xml));
        XmlParse p = new XmlParse();
        String artifactUrl = null;
        try {
            artifactUrl = p.getURlFromSearch(xml, groupName, artifactId, extension, ver, pom, classifierId);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        if (artifactUrl != null) {
            return artifactUrl;
        }
        if (classifier.equalsIgnoreCase("servicearchive")) {
            try {
                artifactUrl = p.getURlFromSearch(xml, groupName, artifactId, extension, ver, pom, null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
        }
        if (artifactUrl != null) {
            return artifactUrl;
        }
        method = new GetMethod(centralUrl);
        try {
            int statusCode = this.getClient().executeMethod((HttpMethod)method);
            if (statusCode == 200) {
                this.logger.info((Object)("found artifact in maven Central, status code returned: " + statusCode));
                return centralUrl;
            }
        }
        catch (HttpException e) {
            this.logger.error((Object)(" HttpException in maven Central " + e.getMessage()));
        }
        catch (IOException e) {
            this.logger.error((Object)(" IOException in maven Central " + e.getMessage()));
        }
        return null;
    }

    private HttpClient getClient() {
        if (this.client == null) {
            this.client = new HttpClient();
        }
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String connect(GetMethod method) {
        this.logger.debug((Object)"Try to connect to the server: connect method");
        String result = null;
        try {
            int statusCode = this.getClient().executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                this.logger.error((Object)("Method failed: " + method.getStatusCode()));
            }
            byte[] responseBody = method.getResponseBody();
            result = new String(responseBody);
        }
        catch (HttpException e) {
            this.logger.error((Object)("Fatal protocol violation: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e1) {
            this.logger.error((Object)("Fatal transport error: " + e1.getMessage()));
            e1.printStackTrace();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectAndDownload(GetMethod method, String path) {
        try {
            int statusCode = this.getClient().executeMethod((HttpMethod)method);
            if (statusCode != 200) {
                System.err.println("Method failed: " + method.getStatusCode());
            }
            byte[] responseBody = method.getResponseBody();
            FileOutputStream os = new FileOutputStream(path);
            ((OutputStream)os).write(responseBody);
        }
        catch (HttpException e) {
            this.logger.error((Object)("Fatal protocol violation: " + e.getMessage()));
            e.printStackTrace();
        }
        catch (IOException e) {
            this.logger.error((Object)("Fatal transport error: " + e.getMessage()));
            e.printStackTrace();
        }
        finally {
            method.releaseConnection();
        }
    }

    private String getLocalSAURL(File tar, File profile, ArchiveManagement arcManager, Coordinates coordinates) {
        tar.setExecutable(true);
        tar.setReadable(true);
        String relativePath = File.separator + coordinates.getServiceClass() + File.separator + coordinates.getServiceName() + File.separator + coordinates.getPackageName() + File.separator + coordinates.getPackageVersion();
        File urlDirectory = new File(ServiceContext.getContext().getHttpServerBasePath().getAbsolutePath() + File.separator + ServiceContext.getContext().getMavenRelativeDir() + relativePath);
        if (!urlDirectory.exists()) {
            boolean created = urlDirectory.mkdir();
            if (created) {
                this.logger.debug((Object)("Directory " + urlDirectory.getAbsolutePath() + " created"));
            } else {
                this.logger.warn((Object)("Directory " + urlDirectory.getAbsolutePath() + " not created"));
            }
        }
        urlDirectory.setWritable(true);
        urlDirectory.setExecutable(true);
        this.logger.debug((Object)("directory on the server is: " + urlDirectory.getAbsolutePath()));
        try {
            this.logger.debug((Object)("copy file " + tar.getAbsolutePath() + " in directory: " + urlDirectory.getAbsolutePath()));
            FileUtils.copyFileToDirectory((File)tar, (File)urlDirectory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String hostName = GHNContext.getContext().getHostname();
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(hostName).append(":" + ServiceContext.getContext().getHttpServerPort()).append("/" + ServiceContext.getContext().getMavenRelativeDir() + relativePath + File.separator + tar.getName());
        this.logger.debug((Object)(" local url for sa created: " + sb.toString()));
        return sb.toString();
    }

    public String getSALocation(File tmpTargetDirectory, List mcList, Coordinates coordinates) throws MalformedURLException, ServiceNotAvaiableFault, IOException, Exception {
        this.logger.debug((Object)"getSALocation method ");
        String url = null;
        if (this.cacheEnabled) {
            url = this.cache.getSALocation(tmpTargetDirectory, mcList, coordinates);
        }
        if (url != null) {
            this.logger.info((Object)("CACHE FETCHED " + url));
            return url;
        }
        this.logger.debug((Object)"not element retrieved in cache ");
        url = this.get(mcList.get(0), "tar.gz", "servicearchive");
        if (url != null && this.cacheEnabled) {
            this.logger.info((Object)"insert entry in cache ");
            String cacheString = this.cache.buildGCubeCoordinatesCacheInputString(coordinates, "tar.gz", "servicearchive");
            this.cache.put(cacheString, url);
        }
        return url;
    }
}

