package org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util;

import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.gcube.common.core.utils.logging.GCUBELog;
//import org.gcube.vremanagement.softwarerepository.impl.ServiceContext;
import org.gcube.vremanagement.softwaregateway.impl.repositorymanager.util.FileUtilsExtended;
import org.gcube.vremanagement.softwaregateway.impl.porttypes.ServiceContext;

/**
 * @author Luca Frosini (ISTI-CNR), Marko Mikulicic (ISTI-CNR), Roberto Cirillo (ISTI-CNR)
 */
public class MavenExecutor {

	/**
	 * Class logger. 
	 */
	private static final GCUBELog logger = new GCUBELog(MavenExecutor.class);

	/**
	 * Maven Embedder
	 */
	private MavenEmbedder mavenEmbedder;

	/**
	 * Maven Execution Request
	 */
	private MavenExecutionRequest request;
	
	/**
	 * Maven logger
	 */
//	private SRMavenEmbedderLogger srMavenEmbedderLogger = new SRMavenEmbedderLogger();
	
	
	private File createSettingsFile(String repository) throws Exception{
		String cfgDir= (String)ServiceContext.getContext().getProperty("configDir", false);
		logger.debug("ConfigDir: "+cfgDir);
		logger.debug("path to file: " +cfgDir+File.separator+"settings.xml");
		File file = new File(cfgDir+File.separator+"settings.xml");
		return file;
//		return new File("target/settings.xml");
	}
	
	/**
	 * Prepare the enviroment for MavenEmbedder execution
	 * @param projectDirectory project directory where is pom.xml file
	 * @throws Exception if fails
	 */
	public MavenExecutor(File projectDirectory, String repository, File userSettings) throws Exception {
		logger.debug("Searching settings file...");
		if(userSettings== null)
			userSettings = createSettingsFile("");//repository);
				
		Configuration configuration = new DefaultConfiguration();
		configuration.setUserSettingsFile(userSettings).setClassLoader(Thread.currentThread().getContextClassLoader());

		ConfigurationValidationResult validationResult = MavenEmbedder.validateConfiguration(configuration);
		
		logger.info("MavenExecutor configured");
		
		if(validationResult!=null){
			if (validationResult.isValid()) {
				logger.info("MavenExecutor valid results");
				mavenEmbedder = new MavenEmbedder(configuration);

				//mavenEmbedder.setLogger(srMavenEmbedderLogger);
				request = new DefaultMavenExecutionRequest();
				request.setBaseDirectory(projectDirectory);
//				request.addRemoteRepository("");
				logger.trace("Maven excecutor created");
			}else {
				logger.info("MavenExecutor invalid results");
				
				String error = "User configuration file for maven not valid";
				/*
				if (!validationResult.isUserSettingsFilePresent()) {
					error = "The specific user settings file '" + userSettings + "' is not present.";
				} else if (!validationResult.isUserSettingsFileParses()) {
					error = "Please check your settings file, it is not well formed XML.";
				}*/
				logger.error(error);
				throw new Exception(error);
			}
		}else{
			logger.error("Validation Result NULL");
			throw new Exception("Validation Result NULL");
		}


	}

	/**
	 * 
	 * @param goal goal
	 * @param properties properties couple
	 * @throws Exception if fails
	 */
	@SuppressWarnings("unchecked")
	public void exec(String goal, String[][] properties) throws Exception {
		logger.debug("exec method with goal: "+goal);
		logger.info("executing MavenExcecutor");
		StringBuilder stringBuilder = new StringBuilder();
		//ex. request.setGoals( Arrays.asList(new String[]{"dependency:tree"}));
		request.setGoals( Arrays.asList(new String[]{goal}));
		
		stringBuilder.append("Goal = ").append(goal).append("\n");
		
		if(properties[0].length!=2){
			Exception e = new Exception("Invalid Properties array size");
			logger.error(e);
			throw e;
		}

		for(int i=0; i<properties.length; i++){
			//ex. request.setProperty("outputFile", "resultTree.txt");
			logger.info("MAVEN request: setProperty("+properties[i][0]+", "+properties[i][1]);
			request.setProperty(properties[i][0], properties[i][1]);
			stringBuilder.append("option n.").append(i).append(" ").append(properties[i][0]).append(" = ").append(properties[i][1]).append("\n");
			logger.info("reading the properties");
		}
		logger.info("the string is:"+stringBuilder.toString());		
//		System.out.println("request to goal: "+request.getBaseDirectory()+" "+(request.getRemoteRepositories()));
		MavenExecutionResult mavenResult = mavenEmbedder.execute(request);
		
		if (mavenResult.hasExceptions()) {
			List<Exception> exceptionList = mavenResult.getExceptions();
			int i=1;
			for (Exception exception : exceptionList) {
				logger.info("Maven Exception n." + i++ + ":\n" + exception);
				
				if(exception instanceof org.apache.maven.lifecycle.LifecycleExecutionException) {
					logger.info("exception instanceof org.apache.maven.lifecycle.LifecycleExecutionException ");
					LifecycleExecutionException lifecycleExecutionException = (LifecycleExecutionException) exception;
					if (lifecycleExecutionException.getCause() instanceof org.apache.maven.artifact.resolver.MultipleArtifactsNotFoundException) {
						MultipleArtifactsNotFoundException multipleArtifactsNotFoundException = (MultipleArtifactsNotFoundException) lifecycleExecutionException.getCause();
						logger.info("MultipleArtifactsNotFoundException ");
						int j=1;
						List resolvedArtifacts = multipleArtifactsNotFoundException.getResolvedArtifacts();
						for (Iterator iter = resolvedArtifacts.iterator(); iter.hasNext();) {
							DefaultArtifact defaultArtifact = (DefaultArtifact) iter.next();
							logger.info("Resolved Artifact n. " + j++ + " : " + defaultArtifact);
							
						}
						
						j=1;
						List missingArtifacts = multipleArtifactsNotFoundException.getMissingArtifacts();
						for (Iterator iter = missingArtifacts.iterator(); iter.hasNext();) {
							DefaultArtifact defaultArtifact = (DefaultArtifact) iter.next();
							logger.info("Missing Artifact n. " + j++ + " : " + defaultArtifact);
							
						}
											
						
					}					
				}
				
			}
			throw exceptionList.get(0);
		}
		
	}
}
