/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.softwaregateway.client;

import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.apache.axis.types.URI;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.vremanagement.softwaregateway.stubs.AccessPortType;
import org.gcube.vremanagement.softwaregateway.stubs.GetPluginResponse;
import org.gcube.vremanagement.softwaregateway.stubs.LocationItem;
import org.gcube.vremanagement.softwaregateway.stubs.PluginCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.service.AccessServiceAddressingLocator;

public class GetPluginsClient {
    public static void main(String[] args) {
        LocationItem[] items;
        AccessPortType stub;
        int i = 0;
        while (i < args.length) {
            System.out.println("param N." + i + ": " + args[i]);
            ++i;
        }
        if (args.length != 7) {
            System.out.println("Usage:");
            System.out.println("\tjava  GetPluginsClient   SoftwareGatewayEPR  scope  ServiceName   ServiceClass   ServiceVersion PackageName PackageVersion\n\n");
            System.out.println("Example:");
            System.out.println("\tjava  GetPluginsClient  http://node2.d.d4science.research-infrastructures.eu:9001/wsrf/services/gcube/vremanagement/softwaregateway/Access /gcube/devsec sn sc sv pn pv\n\n");
            return;
        }
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress(new AttributedURI(args[0]));
        }
        catch (URI.MalformedURIException e) {
            e.printStackTrace();
            return;
        }
        try {
            stub = new AccessServiceAddressingLocator().getAccessPortTypePort(endpoint);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return;
        }
        try {
            stub = (AccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)stub, (GCUBEScope)GCUBEScope.getScope((String)args[1]), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        String serviceClass = args[2];
        String serviceName = args[3];
        String serviceVersion = args[4];
        String packageName = args[5];
        String packageVersion = args[6];
        PluginCoordinates pc = new PluginCoordinates();
        pc.setServiceClass(serviceClass);
        pc.setServiceName(serviceName);
        pc.setServiceVersion(serviceVersion);
        pc.setPackageName(packageName);
        pc.setPackageVersion(packageVersion);
        GetPluginResponse response = null;
        try {
            response = stub.getPlugins(pc);
        }
        catch (GCUBEFault e) {
            e.printStackTrace();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        if (response != null && (items = response.getItems()) != null) {
            System.out.println("Number of packages founded: \n" + items.length);
            LocationItem[] locationItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                LocationItem item = locationItemArray[n2];
                System.out.println(" found package: " + item.getPackageName() + "  version: " + item.getPackageVersion() + " in service: sc: " + item.getServiceClass() + " sn: " + item.getServiceName() + " sv: " + item.getServiceVersion());
                ++n2;
            }
        }
    }
}

