/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.client.plugins;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.vremanagement.resourcemanager.client.exceptions.InvalidOptionsException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.InvalidScopeException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.NoSuchReportException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.ResourcesCreationException;
import org.gcube.vremanagement.resourcemanager.client.exceptions.ResourcesRemovalException;
import org.gcube.vremanagement.resourcemanager.client.fws.Types;

public abstract class AbstractPlugin<S, P>
implements Plugin<S, P> {
    public final String name;

    AbstractPlugin(String name) {
        this.name = name;
    }

    public String serviceClass() {
        return "VREManagement";
    }

    public String serviceName() {
        return "ResourceManager";
    }

    public String name() {
        return this.name;
    }

    public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
        if (fault instanceof Types.InvalidScopeFault) {
            return new InvalidScopeException(fault);
        }
        if (fault instanceof Types.InvalidOptionsFault) {
            return new InvalidOptionsException(fault);
        }
        if (fault instanceof Types.NoSuchReportFault) {
            return new NoSuchReportException(fault);
        }
        if (fault instanceof Types.ResourcesCreationFault) {
            return new ResourcesCreationException(fault);
        }
        if (fault instanceof Types.ResourcesRemovalFault) {
            return new ResourcesRemovalException(fault);
        }
        return fault;
    }
}

