/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.impl.resources.ResourceStorageManager;
import org.gcube.vremanagement.resourcebroker.impl.resources.SingletonResourceStorage;
import org.gcube.vremanagement.resourcebroker.impl.services.ISClientRequester;
import org.gcube.vremanagement.resourcebroker.impl.support.notifications.GHNUpdateSubscriber;
import org.gcube.vremanagement.resourcebroker.impl.support.notifications.RICreationSubscriber;
import org.gcube.vremanagement.resourcebroker.impl.support.threads.TUpdateGHNProfiles;
import org.gcube.vremanagement.resourcebroker.impl.support.threads.TimedThreadsStorage;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNDescriptor;
import org.gcube.vremanagement.resourcebroker.impl.support.types.GHNReservation;
import org.gcube.vremanagement.resourcebroker.utils.assertions.Assertion;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanBuilderIdentifier;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;

public final class GHNReservationHandler {
    private GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX"));
    private static final GHNReservationHandler SINGLETON = new GHNReservationHandler();
    private static final String KEY_GLOBAL_GHNs = "GLOBAL_GHN_KEY";
    private static final String KEY_RESERVED_GHNs = "RESERVED_GHN_KEY";

    public static GHNReservationHandler getInstance() {
        return SINGLETON;
    }

    private GHNReservationHandler() {
    }

    public synchronized GHNDescriptor getGHNByID(PlanBuilderIdentifier wfID, GCUBEScope scope, String ghnID) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(scope != null, new GCUBEFault(new String[]{"Invalid scope parameter. null not allowed."}));
        checker.validate(ghnID != null && ghnID.trim().length() > 0, new GCUBEFault(new String[]{"Invalid ID for ghn to retrieve. null or empty string not allowed."}));
        ghnID = ghnID.trim();
        List<GHNDescriptor> globalGHNs = this.getGlobalGHNsForScope(scope, false);
        for (GHNDescriptor elem : globalGHNs) {
            if (elem.getID().compareTo(ghnID) != 0) continue;
            return elem;
        }
        if (wfID == null) {
            return null;
        }
        List<GHNDescriptor> reservedGHNs = this.getReservedGHNs(scope, wfID);
        if (reservedGHNs == null) {
            return null;
        }
        for (GHNDescriptor elem : reservedGHNs) {
            if (elem.getID().compareTo(ghnID) != 0) continue;
            return elem;
        }
        return null;
    }

    public synchronized GHNDescriptor getNextMatchingGHN(GCUBEScope scope, PlanBuilderIdentifier wfID, Requirement[] requirements, boolean reserve) throws GCUBEFault {
        List<GHNDescriptor> reservedGHNs;
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(scope != null, new GCUBEFault(new String[]{"Invalid scope parameter."}));
        List<GHNDescriptor> globalGHNs = this.getGlobalGHNsForScope(scope, false);
        Vector<GHNDescriptor> searchList = new Vector<GHNDescriptor>();
        if (globalGHNs != null && globalGHNs.size() != 0) {
            searchList.addAll(globalGHNs);
        }
        if (wfID != null && (reservedGHNs = this.getReservedGHNs(scope, wfID)) != null) {
            searchList.addAll(reservedGHNs);
        }
        if (searchList.size() == 0) {
            return null;
        }
        Collections.sort(searchList);
        for (GHNDescriptor ghn : searchList) {
            if (!ghn.hasProfile() || !ghn.satisfies(requirements)) continue;
            if (reserve) {
                this.reserveGHN(wfID, ghn);
            }
            return ghn;
        }
        return null;
    }

    public synchronized void addGHNDescriptor(GHNDescriptor ghn) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(ghn != null && ghn.getID() != null && ghn.getScope() != null, new GCUBEFault(new String[]{"Invalid parameter."}));
        List<GHNDescriptor> ghns = this.getGlobalGHNsForScope(ghn.getScope(), false);
        if (ghns != null && !ghns.contains(ghn)) {
            ghns.add(ghn);
        }
    }

    public List<GHNDescriptor> getGlobalGHNsForScope(GCUBEScope scope, boolean applySorting) throws GCUBEFault {
        List<GHNDescriptor> retval;
        SingletonResourceStorage status = null;
        try {
            status = ResourceStorageManager.INSTANCE.getResource();
        }
        catch (Exception e) {
            this.logger.error((Object)"cannot retrieve the singleton persistent resource.");
        }
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(scope != null, new GCUBEFault(new String[]{"Invalid scope"}));
        checker.validate(status != null, new GCUBEFault(new String[]{"Persistent resource not available"}));
        String RES_KEY = KEY_GLOBAL_GHNs + scope.toString();
        if (!status.containsKey(RES_KEY)) {
            this.logger.debug((Object)("[RES-GET] Creating a new ghn list for scope: " + scope.toString()));
            try {
                this.logger.debug((Object)"[RES-GET] Accessing the Information System [IS]");
                retval = ISClientRequester.getRIOnGHNs(scope);
                if (retval == null || retval.size() == 0) {
                    this.logger.error((Object)"[RES-GET] Error while accessing the Information System [IS]");
                    throw new GCUBEFault(new String[]{"Access to the IS returned an empty list. Try later on!"});
                }
                status.addElement(RES_KEY, retval);
            }
            catch (Exception e) {
                this.logger.error((Object)("[RES-GET-ERROR] while accessing IS for scope: " + scope.toString()));
                this.logger.error((Object)e);
                throw new GCUBEFault(new String[]{"Access to the IS failed"});
            }
            if (BrokerConfiguration.getBoolProperty("ENABLE_UPDATE_GHN_HANDLER")) {
                TimedThreadsStorage.registerThread(new TUpdateGHNProfiles((long)BrokerConfiguration.getIntProperty("GHN_PROFILE_UPDATER_TTL_MINUTES") * 60000L, scope), true);
            }
            if (BrokerConfiguration.getBoolProperty("ENABLE_GHN_NOTIFICATIONS")) {
                new GHNUpdateSubscriber(scope, (long)BrokerConfiguration.getIntProperty("GHN_PROFILE_UPDATER_TTL_MINUTES") * 60000L);
            }
            if (BrokerConfiguration.getBoolProperty("ENABLE_RI_NOTIFICATIONS")) {
                new RICreationSubscriber(scope, (long)BrokerConfiguration.getIntProperty("GHN_PROFILE_UPDATER_TTL_MINUTES") * 60000L);
            }
        }
        if (status.getElem(RES_KEY) == null) {
            return null;
        }
        retval = (List<GHNDescriptor>)status.getElem(RES_KEY);
        if (applySorting) {
            Collections.sort(retval);
        }
        return retval;
    }

    public synchronized GHNDescriptor getNextGHN(GCUBEScope scope, PlanBuilderIdentifier wfID, boolean reserve) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(scope != null, new GCUBEFault(new String[]{"Invalid scope parameter."}));
        checker.validate(wfID != null, new GCUBEFault(new String[]{"Invalid wfID parameter. null not allowed."}));
        List<GHNDescriptor> globalGHNs = null;
        try {
            globalGHNs = this.getGlobalGHNsForScope(scope, false);
        }
        catch (Exception e) {
            this.logger.error((Object)"[GETNEXT] An exception occured here", (Throwable)e);
        }
        if (globalGHNs == null || globalGHNs.size() == 0) {
            this.logger.error((Object)"[GETNEXT] no global GHNs registered in the scope");
            return null;
        }
        Vector<GHNDescriptor> searchList = new Vector<GHNDescriptor>();
        searchList.addAll(globalGHNs);
        List<GHNDescriptor> reservedGHNs = this.getReservedGHNs(scope, wfID);
        if (reservedGHNs != null) {
            searchList.addAll(reservedGHNs);
        }
        Collections.sort(searchList);
        for (GHNDescriptor ghn : searchList) {
            if (!ghn.isReservableBy(wfID)) continue;
            if (reserve) {
                this.reserveGHN(wfID, ghn);
            }
            return ghn;
        }
        return null;
    }

    public synchronized List<GHNDescriptor> getReservedGHNs(GCUBEScope scope, PlanBuilderIdentifier wfID) throws GCUBEFault {
        SingletonResourceStorage status = ResourceStorageManager.INSTANCE.getResource();
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(status != null, new GCUBEFault(new String[]{"The resource cannot be found."}));
        checker.validate(scope != null, new GCUBEFault(new String[]{"Invalid scope parameter. null received."}));
        checker.validate(wfID != null, new GCUBEFault(new String[]{"Invalid wfID parameter. null received."}));
        if (status.getElem(KEY_RESERVED_GHNs) == null) {
            return null;
        }
        Map reservations = (Map)status.getElem(KEY_RESERVED_GHNs);
        if (reservations.containsKey(wfID)) {
            return ((GHNReservation)reservations.get(wfID)).getGHNsForScope(scope);
        }
        return null;
    }

    public synchronized void reserveGHN(PlanBuilderIdentifier wfID, GHNDescriptor ghn) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(ghn != null && wfID != null, new GCUBEFault(new String[]{"Invalid parameter. null not allowed"}));
        checker.validate(ghn.isReservableBy(wfID), new GCUBEFault(new String[]{"The ghn: " + ghn.getID() + " cannot be reserved by " + wfID + (ghn.isReserved() ? " it is already locked by plan: " + ghn.getOwner().getID() : "")}));
        GHNReservation reservation = this.getReservationFor(wfID);
        reservation.addGHN(ghn);
        ghn.reserve(wfID);
        this.logger.debug((Object)("[RES-ADD] added a reservation for GHN: " + (String)ghn.getElement() + " for plan: " + wfID));
    }

    public synchronized void revokeExpiredReservations() throws GCUBEFault {
        SingletonResourceStorage status = ResourceStorageManager.INSTANCE.getResource();
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(status != null, new GCUBEFault(new String[]{"Persistent resource not available."}));
        if (!status.containsKey(KEY_RESERVED_GHNs)) {
            return;
        }
        Map reservations = (Map)status.getElem(KEY_RESERVED_GHNs);
        if (reservations == null || reservations.values() == null || reservations.values().size() == 0) {
            return;
        }
        Vector<GHNReservation> elemsToRemove = new Vector<GHNReservation>();
        Iterator resList = reservations.values().iterator();
        GHNReservation res = null;
        while (resList.hasNext()) {
            res = (GHNReservation)resList.next();
            if (!res.isExpired()) continue;
            this.logger.debug((Object)("[RES-REMOVE] Removing reservations for Plan: " + ((PlanBuilderIdentifier)res.getElement()).getID()));
            res.revoke();
            elemsToRemove.add(res);
        }
        for (GHNReservation elemToRemove : elemsToRemove) {
            reservations.remove(elemToRemove.getElement());
        }
    }

    public synchronized void revokeFailedReservation(PlanBuilderIdentifier wfID) throws GCUBEFault {
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(wfID != null, new GCUBEFault(new String[]{"Invalid parameter."}));
        this.logger.debug((Object)("[RES-REMOVE] Removing reservations for failed Plan: " + wfID.getID()));
        if (!this.containsReservationFor(wfID)) {
            return;
        }
        SingletonResourceStorage status = ResourceStorageManager.INSTANCE.getResource();
        checker.validate(status != null, new GCUBEFault(new String[]{"Persistent resource not available."}));
        Map reservations = (Map)status.getElem(KEY_RESERVED_GHNs);
        GHNReservation toremove = (GHNReservation)reservations.get(wfID);
        if (toremove == null) {
            return;
        }
        toremove.revoke();
        reservations.remove(wfID);
    }

    public synchronized boolean containsReservationFor(PlanBuilderIdentifier wfID) {
        SingletonResourceStorage status;
        try {
            status = ResourceStorageManager.INSTANCE.getResource();
            if (status == null || wfID == null) {
                this.logger.error((Object)"[RES-LOOKUP] looking up reservation for plan: null [NOT FOUND]");
                return false;
            }
        }
        catch (GCUBEFault e) {
            this.logger.error((Object)("[RES-LOOKUP] looking up reservation for plan: " + wfID.getID() + " [NOT FOUND]"));
            return false;
        }
        if (!status.containsKey(KEY_RESERVED_GHNs)) {
            this.logger.error((Object)("[RES-LOOKUP] looking up reservation for plan: " + wfID.getID() + " [NOT FOUND]"));
            return false;
        }
        Map reservations = (Map)status.getElem(KEY_RESERVED_GHNs);
        if (reservations == null || reservations.values() == null || reservations.values().size() == 0 || !reservations.containsKey(wfID)) {
            this.logger.error((Object)("[RES-LOOKUP] looking up reservation for plan: " + wfID.getID() + " [NOT FOUND]"));
            return false;
        }
        if (reservations.get(wfID) != null) {
            this.logger.debug((Object)("[RES-LOOKUP] looking up reservation for plan: " + wfID.getID() + " [FOUND]"));
            return true;
        }
        this.logger.error((Object)("[RES-LOOKUP] looking up reservation for plan: " + wfID.getID() + " [NOT FOUND]"));
        return false;
    }

    public GHNReservation getReservationFor(PlanBuilderIdentifier wfID) throws GCUBEFault {
        Map reservations;
        SingletonResourceStorage status = ResourceStorageManager.INSTANCE.getResource();
        Assertion<GCUBEFault> checker = new Assertion<GCUBEFault>();
        checker.validate(status != null, new GCUBEFault(new String[]{"Persistent resource not available."}));
        checker.validate(wfID != null, new GCUBEFault(new String[]{"The parameter wfID cannot be null."}));
        if (!status.containsKey(KEY_RESERVED_GHNs)) {
            status.addElement(KEY_RESERVED_GHNs, new HashMap());
        }
        if (!(reservations = (Map)status.getElem(KEY_RESERVED_GHNs)).containsKey(wfID)) {
            reservations.put(wfID, new GHNReservation(wfID, (long)BrokerConfiguration.getIntProperty("GHN_RESERVATION_TTL_MINUTES") * 60000L));
        }
        return (GHNReservation)reservations.get(wfID);
    }

    public boolean isResourceLoaded() {
        try {
            ResourceStorageManager.INSTANCE.getResource();
        }
        catch (GCUBEFault e) {
            return false;
        }
        return true;
    }
}

