/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.support.queries;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.resources.ResourceStorageManager;
import org.gcube.vremanagement.resourcebroker.impl.resources.SingletonResourceStorage;
import org.gcube.vremanagement.resourcebroker.impl.support.queries.QueryPath;

public class QueryLoader {
    private static GCUBELog logger = new GCUBELog(QueryLoader.class, "BMM");
    private static final String MEM_XQUERY_KEY = "CustomXQueries";

    public static String getQuery(QueryPath query) throws Exception {
        logger.info((Object)("[QUERY] loading " + query.name()));
        HashMap cachedQueries = null;
        try {
            SingletonResourceStorage status = ResourceStorageManager.INSTANCE.getResource();
            if (status != null) {
                if (!status.containsKey(MEM_XQUERY_KEY)) {
                    status.addElement(MEM_XQUERY_KEY, new HashMap());
                } else {
                    cachedQueries = (HashMap)status.getElem(MEM_XQUERY_KEY);
                }
            } else {
                logger.error((Object)"[QUERY] STATUS NOT AVAILABLE");
            }
        }
        catch (GCUBEFault e) {
            logger.error((Object)"[QUERY] Resource not ready");
        }
        if (cachedQueries != null && cachedQueries.containsKey((Object)query)) {
            return (String)cachedQueries.get((Object)query);
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(query.getFileName()));
        StringBuilder retval = new StringBuilder();
        String currLine = null;
        while ((currLine = in.readLine()) != null) {
            if (currLine.trim().length() > 0 && currLine.trim().startsWith("#") || currLine.trim().length() == 0) continue;
            retval.append(currLine + System.getProperty("line.separator"));
        }
        in.close();
        if (cachedQueries != null) {
            cachedQueries.put(query, retval.toString());
        }
        return retval.toString();
    }
}

