/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.impl.resources;

import java.util.HashMap;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.impl.configuration.BrokerConfiguration;
import org.gcube.vremanagement.resourcebroker.utils.console.PrettyFormatter;

public class SingletonResourceStorage
extends GCUBEWSResource {
    private GCUBELog logger = new GCUBELog((Object)this, BrokerConfiguration.getProperty("LOGGING_PREFIX"));
    private HashMap<String, Object> state = null;

    protected final synchronized void initialise(Object ... arg0) throws Exception {
        this.logger.debug((Object)("[RESOURCE-INIT] " + ((Object)((Object)this)).getClass().getSimpleName() + ": creating the singleton resource storage. The service is now " + PrettyFormatter.bold("[READY]")));
        this.state = new HashMap();
    }

    public final synchronized Object getElem(String key) {
        if (key != null) {
            return this.state.get(key.trim());
        }
        return null;
    }

    public final synchronized void addElement(String key, Object value) {
        this.logger.debug((Object)("[RESOURCE-ADD] adding elem: " + key));
        if (key != null) {
            this.state.put(key.trim(), value);
        }
    }

    public final synchronized void deleteElement(String key) {
        this.logger.debug((Object)("[RESOURCE-DEL] removing elem: " + key));
        if (key != null) {
            this.state.remove(key.trim());
        }
    }

    public final synchronized boolean containsKey(String key) {
        if (this.state != null && key != null) {
            return this.state.containsKey(key.trim());
        }
        return false;
    }

    public final synchronized boolean containsValue(Object value) {
        return this.state.containsValue(value);
    }

    public final synchronized HashMap<String, Object> getState() {
        return this.state;
    }
}

