/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.serialization.parser.xstream;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageGroup;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanRequest;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PlanResponse;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.DeployNode;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.Feedback;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XStreamTransformer {
    private GCUBELog logger = new GCUBELog((Object)this, "BMM");
    private XStream xstreamRequestHandler = null;
    private XStream xstreamResponseHandler = null;
    private XStream xstreamFeedbackHandler = null;

    private synchronized void initGlobalParams(XStream xstream) {
        xstream.addDefaultImplementation(Vector.class, List.class);
        xstream.alias("PackageGroup", PackageGroup.class);
        xstream.alias("Package", PackageElem.class);
        xstream.alias("Requirement", Requirement.class);
        xstream.alias("DeployNode", DeployNode.class);
        xstream.addImplicitCollection(PackageGroup.class, "packages");
    }

    private synchronized void initRequestHandler() {
        this.logger.debug((Object)"[XSTREAM] initializing the request handler");
        if (this.xstreamRequestHandler != null) {
            return;
        }
        QNameMap qmap = new QNameMap();
        qmap.registerMapping(new QName(SupportedTypes.XML_PLAN_REQUEST.namespace(), SupportedTypes.XML_PLAN_REQUEST.value()), PlanRequest.class);
        StaxDriver driver = new StaxDriver(qmap);
        driver.setRepairingNamespace(false);
        this.xstreamRequestHandler = new XStream((HierarchicalStreamDriver)driver);
        this.xstreamRequestHandler.processAnnotations(PlanRequest.class);
        this.xstreamRequestHandler.addImplicitCollection(PlanRequest.class, "packageGroups");
        this.initGlobalParams(this.xstreamRequestHandler);
    }

    private synchronized void initResponseHandler() {
        this.logger.debug((Object)"[XSTREAM] initializing the response handler");
        if (this.xstreamResponseHandler != null) {
            return;
        }
        QNameMap qmap = new QNameMap();
        qmap.registerMapping(new QName(SupportedTypes.XML_PLAN_RESPONSE.namespace(), SupportedTypes.XML_PLAN_RESPONSE.value()), PlanResponse.class);
        StaxDriver driver = new StaxDriver(qmap);
        driver.setRepairingNamespace(false);
        this.xstreamResponseHandler = new XStream((HierarchicalStreamDriver)driver);
        this.xstreamResponseHandler.processAnnotations(PlanResponse.class);
        this.xstreamResponseHandler.addImplicitCollection(PlanResponse.class, "packageGroups");
        this.initGlobalParams(this.xstreamResponseHandler);
    }

    private synchronized void initFeedbackHandler() {
        this.logger.debug((Object)"[XSTREAM] initializing the feedback handler");
        if (this.xstreamFeedbackHandler != null) {
            return;
        }
        QNameMap qmap = new QNameMap();
        qmap.registerMapping(new QName(SupportedTypes.XML_PLAN_FEEDBACK.namespace(), SupportedTypes.XML_PLAN_FEEDBACK.value()), Feedback.class);
        StaxDriver driver = new StaxDriver(qmap);
        driver.setRepairingNamespace(false);
        this.xstreamFeedbackHandler = new XStream((HierarchicalStreamDriver)driver);
        this.xstreamFeedbackHandler.processAnnotations(Feedback.class);
        this.xstreamFeedbackHandler.addImplicitCollection(Feedback.class, "deployNodes");
        this.initGlobalParams(this.xstreamFeedbackHandler);
    }

    private String formatXML(String param) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource(new StringReader(param));
        Document document = db.parse(is);
        OutputFormat format = new OutputFormat(document);
        format.setLineWidth(65);
        format.setIndenting(true);
        format.setIndent(2);
        StringWriter out = new StringWriter();
        XMLSerializer serializer = new XMLSerializer((Writer)out, format);
        serializer.serialize(document);
        return ((Object)out).toString();
    }

    public final String toXML(PlanRequest request) throws GCUBEFault {
        if (request == null) {
            throw new GCUBEFault(new String[]{"Invalid " + SupportedTypes.XML_PLAN_REQUEST.value() + ": null value not allowed."});
        }
        this.initRequestHandler();
        String unformattedXml = this.xstreamRequestHandler.toXML((Object)request);
        try {
            return this.formatXML(unformattedXml);
        }
        catch (Exception e) {
            return unformattedXml;
        }
    }

    public final String toXML(PlanResponse response) throws GCUBEFault {
        if (response == null) {
            throw new GCUBEFault(new String[]{"Invalid " + SupportedTypes.XML_PLAN_RESPONSE.value() + ": null value not allowed."});
        }
        this.initResponseHandler();
        String unformattedXml = this.xstreamResponseHandler.toXML((Object)response);
        try {
            return this.formatXML(unformattedXml);
        }
        catch (Exception e) {
            return unformattedXml;
        }
    }

    public final String toXML(Feedback feedback) throws GCUBEFault {
        if (feedback == null) {
            throw new GCUBEFault(new String[]{"Invalid " + SupportedTypes.XML_PLAN_FEEDBACK.value() + ": null value not allowed."});
        }
        this.initFeedbackHandler();
        String unformattedXml = this.xstreamFeedbackHandler.toXML((Object)feedback);
        try {
            return this.formatXML(unformattedXml);
        }
        catch (Exception e) {
            return unformattedXml;
        }
    }

    public final PlanRequest getRequestFromXML(String xml, boolean validate) throws GCUBEFault {
        if (xml == null) {
            throw new GCUBEFault(new String[]{"Null value received during XML serialization of " + SupportedTypes.XML_PLAN_REQUEST.value()});
        }
        if (validate) {
            try {
                if (!this.validate(SupportedTypes.XML_PLAN_REQUEST.validationSchema(), xml)) {
                    throw new GCUBEFault(new String[]{"The given " + SupportedTypes.XML_PLAN_REQUEST.value() + " is not valid."});
                }
            }
            catch (IOException e) {
                throw new GCUBEFault(new String[]{"The validation schema " + SupportedTypes.XML_PLAN_REQUEST.validationSchema() + " for " + SupportedTypes.XML_PLAN_REQUEST.value() + " cannot be found."});
            }
            catch (SAXException e) {
                throw new GCUBEFault(new String[]{"The " + SupportedTypes.XML_PLAN_REQUEST.value() + " given is not valid."});
            }
        }
        this.initRequestHandler();
        PlanRequest retval = (PlanRequest)this.xstreamRequestHandler.fromXML(xml);
        this.initPackageGroups(retval.getPackageGroups());
        return retval;
    }

    public final Feedback getFeedbackFromXML(String xml, boolean validate) throws GCUBEFault {
        if (xml == null) {
            throw new GCUBEFault(new String[]{"Null value received during XML serialization of " + SupportedTypes.XML_PLAN_FEEDBACK.value()});
        }
        if (validate) {
            try {
                if (!this.validate(SupportedTypes.XML_PLAN_FEEDBACK.validationSchema(), xml)) {
                    throw new GCUBEFault(new String[]{"The given " + SupportedTypes.XML_PLAN_FEEDBACK.value() + " is not valid."});
                }
            }
            catch (IOException e) {
                throw new GCUBEFault((Throwable)e, new String[]{"The validation schema " + SupportedTypes.XML_PLAN_FEEDBACK.validationSchema() + " for " + SupportedTypes.XML_PLAN_FEEDBACK.value() + " cannot be found."});
            }
            catch (SAXException e) {
                throw new GCUBEFault((Throwable)e, new String[]{"The " + SupportedTypes.XML_PLAN_FEEDBACK.value() + " given is not valid."});
            }
        }
        this.initFeedbackHandler();
        Feedback retval = (Feedback)this.xstreamFeedbackHandler.fromXML(xml);
        return retval;
    }

    private void initPackageGroups(List<PackageGroup> pgs) {
        if (pgs == null || pgs.size() == 0) {
            return;
        }
        int i = 1;
        for (PackageGroup pg : pgs) {
            if (pg.getID() != null) continue;
            pg.setID(String.valueOf(i++));
        }
    }

    public final PlanResponse getResponseFromXML(String xml, boolean validate) throws GCUBEFault {
        if (xml == null) {
            throw new GCUBEFault(new String[]{"Null value received during XML serialization of " + SupportedTypes.XML_PLAN_RESPONSE.value()});
        }
        if (validate) {
            try {
                if (!this.validate(SupportedTypes.XML_PLAN_RESPONSE.validationSchema(), xml)) {
                    throw new GCUBEFault(new String[]{"The given " + SupportedTypes.XML_PLAN_RESPONSE.value() + " is not valid."});
                }
            }
            catch (IOException e) {
                throw new GCUBEFault(new String[]{"The validation schema for " + SupportedTypes.XML_PLAN_RESPONSE.value() + " cannot be found."});
            }
            catch (SAXException e) {
                throw new GCUBEFault(new String[]{"The " + SupportedTypes.XML_PLAN_RESPONSE.value() + " given is not valid."});
            }
        }
        this.initResponseHandler();
        PlanResponse retval = (PlanResponse)this.xstreamResponseHandler.fromXML(xml);
        this.initPackageGroups(retval.getPackageGroups());
        return retval;
    }

    private boolean validate(String schemaFilePath, String xml) throws SAXException, IOException {
        if (schemaFilePath == null) {
            throw new IOException("The Schema file has not been specified.");
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        File schemaLocation = new File(schemaFilePath);
        if (!schemaLocation.exists()) {
            System.err.println("*** The Schema file has not been specified. " + schemaFilePath);
            throw new IOException("The Schema file has not been specified.");
        }
        Schema schema = factory.newSchema(schemaLocation);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new StringReader(xml));
        validator.validate(source);
        return true;
    }

    static enum SupportedTypes {
        XML_PLAN_REQUEST("PlanRequest", "http://gcube-system.org/namespaces/resourcebroker/broker/xsd/deployRequest", "share/schema/org.gcube.vremanagement.resourcebroker/deployRequest.xsd"),
        XML_PLAN_RESPONSE("PlanResponse", "http://gcube-system.org/namespaces/resourcebroker/broker/xsd/deployResponse", "share/schema/org.gcube.vremanagement.resourcebroker/deployResponse.xsd"),
        XML_PLAN_FEEDBACK("Feedback", "http://gcube-system.org/namespaces/resourcebroker/broker/xsd/deployFeedback", "share/schema/org.gcube.vremanagement.resourcebroker/deployFeedback.xsd");

        private String value = null;
        private String namespace = null;
        private String validationSchema = null;

        private SupportedTypes(String value, String namespace, String validationSchema) {
            this.value = value;
            this.namespace = namespace;
            this.validationSchema = validationSchema;
        }

        public String value() {
            return this.value;
        }

        public String namespace() {
            return this.namespace;
        }

        public String validationSchema() {
            return this.validationSchema;
        }
    }
}

