/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.serialization.types;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.List;
import java.util.Vector;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.PackageElem;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.requirements.Requirement;

public class PackageGroup
implements Cloneable {
    public static final String NODE_TAG = "PackageGroup";
    private List<PackageElem> packages = new Vector<PackageElem>();
    @XStreamAlias(value="GHN")
    private String ghn = null;
    @XStreamAsAttribute
    @XStreamAlias(value="ID")
    private String key = null;
    @XStreamAsAttribute
    @XStreamAlias(value="service")
    private String serviceName = null;
    @XStreamAlias(value="Requirements")
    private List<Requirement> requirements = null;

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public void setID(String id) {
        this.key = id == null || id.length() == 0 ? new BigInteger(64, new SecureRandom()).toString(32) : id;
    }

    public String getID() {
        return this.key;
    }

    public PackageGroup() {
        this.setID(null);
    }

    protected PackageGroup(String id) {
        this.setID(id);
    }

    public void addPackage(PackageElem p) {
        this.packages.add(p);
    }

    public void setGHN(String ghn) {
        this.ghn = ghn;
    }

    public String getGHN() {
        return this.ghn;
    }

    public List<PackageElem> getPackages() {
        return this.packages;
    }

    public PackageGroup clone() throws CloneNotSupportedException {
        PackageGroup retval = new PackageGroup(this.key);
        retval.setServiceName(this.serviceName);
        retval.setGHN(this.ghn);
        for (PackageElem p : this.getPackages()) {
            retval.addPackage(new PackageElem(p.isReuse(), p.getServiceClass(), p.getServiceName(), p.getServiceVersion(), p.getPackageName(), p.getPackageVersion()));
        }
        return retval;
    }

    public final void addRequirement(Requirement requirement) {
        if (this.requirements == null) {
            this.requirements = new Vector<Requirement>();
        }
        this.requirements.add(requirement);
    }

    public final void addRequirements(Requirement[] requirements) {
        if (requirements != null) {
            for (Requirement req : requirements) {
                this.addRequirement(req);
            }
        }
    }

    public final boolean hasRequirements() {
        return this.requirements != null && this.requirements.size() > 0;
    }

    public final List<Requirement> getRequirements() {
        return this.requirements;
    }
}

