/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcebroker.utils.serialization.types;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import org.gcube.vremanagement.resourcebroker.utils.serialization.types.feedback.FeedbackStatus;

public class PackageElem {
    public static final String NODE_TAG = "Package";
    @XStreamAlias(value="ServiceClass")
    private String serviceClass = null;
    @XStreamAlias(value="ServiceName")
    private String serviceName = null;
    @XStreamAlias(value="ServiceVersion")
    private String serviceVersion = null;
    @XStreamAlias(value="PackageName")
    private String packageName = null;
    @XStreamAlias(value="PackageVersion")
    private String packageVersion = null;
    @XStreamAlias(value="reuse")
    @XStreamAsAttribute
    private boolean reuse = false;
    @XStreamAlias(value="status")
    @XStreamAsAttribute
    private FeedbackStatus status = null;

    public PackageElem() {
    }

    public PackageElem(PackageElem p) {
        this();
        this.reuse = p.isReuse();
        this.packageName = p.getPackageName();
        this.packageVersion = p.getPackageVersion();
        this.serviceClass = p.getServiceClass();
        this.serviceName = p.getServiceName();
        this.serviceVersion = p.getServiceVersion();
    }

    public PackageElem(boolean reuse, String serviceClass, String serviceName, String serviceVersion, String packageName, String packageVersion) {
        this.reuse = reuse;
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
        this.packageName = packageName;
        this.packageVersion = packageVersion;
    }

    public PackageElem(boolean reuse, String serviceClass, String serviceName, String serviceVersion, String packageName, String packageVersion, FeedbackStatus status) {
        this(reuse, serviceClass, serviceName, serviceVersion, packageName, packageVersion);
        this.setStatus(status);
    }

    public final void setServiceClass(String serviceClass) {
        this.serviceClass = serviceClass;
    }

    public final void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public final void setServiceVersion(String serviceVersion) {
        this.serviceVersion = serviceVersion;
    }

    public final void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public final void setPackageVersion(String packageVersion) {
        this.packageVersion = packageVersion;
    }

    public final String getServiceClass() {
        return this.serviceClass;
    }

    public final String getServiceName() {
        return this.serviceName;
    }

    public final String getServiceVersion() {
        return this.serviceVersion;
    }

    public final String getPackageName() {
        return this.packageName;
    }

    public final String getPackageVersion() {
        return this.packageVersion;
    }

    public final boolean isReuse() {
        return this.reuse;
    }

    public final void setReuse(boolean reuse) {
        this.reuse = reuse;
    }

    public final FeedbackStatus getStatus() {
        return this.status;
    }

    public final void setStatus(FeedbackStatus status) {
        this.status = status;
    }
}

