/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state.observers;

import org.gcube.vremanagement.resourcemanager.impl.state.ProfileDate;
import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.ScopeObserver;

public class Publisher
extends ScopeObserver {
    @Override
    protected void scopeChanged(ScopeState scopeState) {
        if (scopeState.getLastOperationPerformed() == ScopeState.OPERATION.PUBLISHED) {
            return;
        }
        try {
            PublishedScopeResource resource = PublishedScopeResource.getResource(scopeState.getScope());
            try {
                this.logger.trace((Object)("PUBLISHER: Start time " + ProfileDate.toXMLDateAndTime(scopeState.getStartTime())));
                resource.synchWithLocalState(scopeState);
                resource.publish();
                scopeState.setLastOperationPerformed(ScopeState.OPERATION.PUBLISHED);
                scopeState.notifyObservers();
            }
            catch (Exception e) {
                this.logger.fatal((Object)"Can't publish the Scope Resource in the IS");
                throw e;
            }
        }
        catch (Exception e) {
            this.logger.fatal((Object)"An error occured in the resource's publishing", (Throwable)e);
        }
    }
}

