/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Observable;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.resourcemanager.impl.reporting.Session;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedSoftware;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ServiceNotFoundException;
import org.gcube.vremanagement.resourcemanager.impl.resources.software.GCUBEPackage;
import org.gcube.vremanagement.resourcemanager.impl.state.ProfileDate;
import org.gcube.vremanagement.resourcemanager.impl.state.RawScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNodeList;

public final class ScopeState
extends Observable {
    protected GCUBELog logger = new GCUBELog((Object)this);
    protected OPERATION lastOperationPerformed;
    private RawScopeState rawState;
    private Session report;
    private boolean isDisposed = false;
    private VirtualNodeList nodes;

    protected ScopeState() {
    }

    protected void initialize(GCUBEScope scope, String name, boolean securityEnabled, String ... description) {
        this.rawState = new RawScopeState();
        this.rawState.initialize(scope);
        this.rawState.data.put("NAME", name);
        this.lastOperationPerformed = OPERATION.CREATED;
        if (!this.rawState.data.containsKey("STARTTIME")) {
            this.rawState.data.put("STARTTIME", Calendar.getInstance().getTime());
        }
        this.rawState.data.put("ENDTIME", null);
        if (!this.rawState.data.containsKey("DESCRIPTION") && description.length > 0) {
            this.rawState.data.put("DESCRIPTION", description[0]);
        }
        this.rawState.data.put("SECURITYENABLED", securityEnabled);
        this.nodes = new VirtualNodeList(scope);
        this.nodes.loadFromState(this.rawState);
    }

    public synchronized void setManager(String manager) {
        this.rawState.data.put("MANAGER", manager);
        this.notifyObservers();
    }

    public synchronized void setDesigner(String designer) {
        this.rawState.data.put("DESIGNER", designer);
        this.notifyObservers();
    }

    public synchronized void changeDescription(String description) {
        this.rawState.data.put("DESCRIPTION", description);
        this.notifyObservers();
    }

    public synchronized void addResources(Set<ScopedResource> newresources) {
        for (ScopedResource resource : newresources) {
            this.logger.trace((Object)("Adding resource " + resource.getId() + " to scope state " + this.getScope().toString()));
            resource.setStatus(ScopedResource.STATUS.ADDREQUESTED);
            if (this.rawState.resources.primaryKeySet().contains(resource.getId())) {
                this.rawState.resources.removeValuesByPrimaryKey(resource.getId());
            }
            this.rawState.resources.put(resource.getId(), resource.getType(), resource);
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.notifyObservers();
    }

    public synchronized Set<ScopedResource> getResourcesByType(String type) {
        return this.rawState.resources.getValuesBySecondaryKey(type);
    }

    public synchronized ScopedResource getResource(String id) {
        return this.rawState.resources.getValuesByPrimaryKey(id).iterator().next();
    }

    public boolean containsResource(String id) {
        return this.rawState.resources.primaryKeySet().contains(id);
    }

    public synchronized void removeAllResourcesByType(String type) {
        for (ScopedResource resource : this.rawState.resources.getValuesBySecondaryKey(type)) {
            resource.setStatus(ScopedResource.STATUS.REMOVEREQUESTED);
            this.rawState.resources.put(resource.getId(), resource.getType(), resource);
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.notifyObservers();
        this.rawState.resources.removeValuesBySecondaryKey(type);
    }

    public synchronized void removeResources(Set<ScopedResource> oldresources) throws VirtualNode.NoGHNFoundException {
        this.logger.trace((Object)"ScopeState: removeResource method: resources must be in the state in order to be removed ");
        for (ScopedResource resource : oldresources) {
            this.logger.debug((Object)("set REMOVEREQUESTED status to " + resource.getId() + " type of resource: " + resource.getType()));
            resource.setStatus(ScopedResource.STATUS.REMOVEREQUESTED);
            if (this.rawState.resources.getValuesByPrimaryKey(resource.getId()) != null) {
                this.logger.debug((Object)"the resource is already present on rawState with the same id . Deleting it...");
                Set<ScopedResource> resourceset = this.rawState.resources.getValuesByPrimaryKey(resource.getId());
                for (ScopedResource r : resourceset) {
                    this.rawState.resources.removeValue(r);
                    this.logger.debug((Object)("r " + r + " deleted "));
                }
                this.logger.debug((Object)("put new value " + resource.getId() + " " + resource.getType().trim()));
            }
            this.rawState.resources.put(resource.getId(), resource.getType().trim(), resource);
            if (resource.getType().compareToIgnoreCase("Service") != 0) continue;
            VirtualNode node = this.nodes.getNode(((ScopedDeployedSoftware)resource).getTargetNodeName());
            ((ScopedDeployedSoftware)resource).scheduleUndeploy(node);
            ((ScopedDeployedSoftware)resource).setCallbackID(this.getLastReport().getId());
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.logger.debug((Object)"ScopeState notify observers ");
        this.notifyObservers();
        this.logger.debug((Object)"ScopeState removing the resources...");
        for (ScopedResource resource : oldresources) {
            this.logger.debug((Object)("Removing resource " + resource + " from the scope state"));
            if (resource.getStatus() == ScopedResource.STATUS.UNPUBLISHED) {
                this.rawState.resources.removeValuesByPrimaryKey(resource.getId());
                this.logger.debug((Object)"...removed");
                continue;
            }
            this.logger.warn((Object)("Resource " + resource + " is still PUBLISHED in the scope state, can't be removed. The resource status is: " + (Object)((Object)resource.getStatus())));
        }
        this.notifyObservers();
    }

    public synchronized void forceResourceRemoval(Set<ScopedResource> resources) {
        for (ScopedResource resource : resources) {
            this.logger.debug((Object)("Removing resource " + resources + " from the scope state"));
            this.rawState.resources.removeValuesByPrimaryKey(resource.getId());
        }
    }

    protected synchronized void removeAllResources() {
        for (ScopedResource resource : this.rawState.resources.values()) {
            resource.setStatus(ScopedResource.STATUS.REMOVEREQUESTED);
        }
        this.setLastOperationPerformed(OPERATION.TOBEMANAGED);
        this.notifyObservers();
        this.rawState.resources.clean();
    }

    public GCUBEScope getScope() {
        return this.rawState.getScope();
    }

    @Override
    public synchronized void notifyObservers(Object whatschanged) {
        this.setChanged();
        super.notifyObservers(whatschanged);
    }

    @Override
    public synchronized void notifyObservers() {
        this.setChanged();
        super.notifyObservers();
    }

    public synchronized Collection<ScopedResource> getAllResources() {
        return Collections.unmodifiableCollection(this.rawState.resources.values());
    }

    public String getManager() {
        return (String)this.rawState.data.get("MANAGER");
    }

    public String getDesigner() {
        return (String)this.rawState.data.get("DESIGNER");
    }

    public String getDescription() {
        return (String)this.rawState.data.get("DESCRIPTION");
    }

    public String getName() {
        return (String)this.rawState.data.get("NAME");
    }

    public Date getEndTime() {
        return (Date)this.rawState.data.get("ENDTIME");
    }

    public Date getStartTime() {
        return (Date)this.rawState.data.get("STARTTIME");
    }

    public boolean isSecurityEnabled() {
        return (Boolean)this.rawState.data.get("SECURITYENABLED");
    }

    public void setEndTime(Date endTime) {
        this.rawState.data.put("ENDTIME", endTime);
        this.notifyObservers();
    }

    public void setStartTime(Date startTime) {
        this.logger.trace((Object)("setStartTime: Start time " + ProfileDate.toXMLDateAndTime(startTime)));
        this.rawState.data.put("STARTTIME", startTime);
        this.notifyObservers();
    }

    public void setName(String name) {
        this.rawState.data.put("NAME", name);
        this.notifyObservers();
    }

    public OPERATION getLastOperationPerformed() {
        return this.lastOperationPerformed;
    }

    public synchronized void setLastOperationPerformed(OPERATION operation) {
        this.lastOperationPerformed = operation;
    }

    public RawScopeState getRawScopeState() {
        return this.rawState;
    }

    public void setRawScopeState(RawScopeState state) {
        this.rawState = state;
        this.nodes = new VirtualNodeList(state.getScope());
        this.nodes.loadFromState(this.rawState);
        this.lastOperationPerformed = OPERATION.CREATED;
    }

    public void setSecurity(boolean securityEnabled) {
        this.rawState.data.put("SECURITYENABLED", securityEnabled);
    }

    public Session getLastReport() {
        return this.report;
    }

    public void setLastSession(Session report) {
        this.report = report;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    public void markAsDisposed() {
        this.isDisposed = true;
        this.notifyObservers();
    }

    public VirtualNode getNode(String name) throws VirtualNode.NoGHNFoundException {
        return this.nodes.getNode(name);
    }

    public VirtualNode getNodeById(String id) throws VirtualNode.NoGHNFoundException {
        return this.nodes.getNodeById(id);
    }

    public ScopedDeployedSoftware getRelatedDeployedSoftware(GCUBEPackage sourceService) throws ServiceNotFoundException {
        for (ScopedResource resource : this.getResourcesByType("Service")) {
            ScopedDeployedSoftware service;
            if (resource == null || !(service = (ScopedDeployedSoftware)resource).getSourcePackage().equals(sourceService)) continue;
            this.logger.debug((Object)"Source service found");
            return service;
        }
        this.logger.error((Object)"Unable to find a source service ");
        throw new ServiceNotFoundException();
    }

    public static enum OPERATION {
        CREATED,
        LOADED,
        TOBEMANAGED,
        PUBLISHED,
        SERIALIZED,
        EXECUTED;

    }
}

