/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.porttypes;

import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.vremanagement.resourcemanager.impl.contexts.ServiceContext;
import org.gcube.vremanagement.resourcemanager.impl.reporting.Session;
import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.porttypes.ResourceManagerPortType;
import org.gcube.vremanagement.resourcemanager.porttypes.ScopeUtils;
import org.gcube.vremanagement.resourcemanager.stubs.common.InvalidScopeFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.CreateScopeParameters;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.InvalidOptionsFaultType;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.OptionsParameters;
import org.gcube.vremanagement.resourcemanager.stubs.scontroller.ScopeOption;
import org.globus.wsrf.NoSuchResourceException;

public class ScopeController
extends ResourceManagerPortType {
    public synchronized String disposeScope(String targetScope) throws InvalidScopeFaultType, GCUBEFault {
        this.logger.info((Object)"Dispose Scope invoked... the entire scope is going to be thrown away!!");
        GCUBEScope scope = ScopeUtils.validate(targetScope.trim());
        if (!ScopeUtils.exists(scope, this)) {
            this.logger.warn((Object)("Target scope " + scope.toString() + " does not exists and cannot be disposed"));
            throw new InvalidScopeFaultType();
        }
        ScopeUtils.removeFromInstance(scope, this);
        try {
            scope.getServiceMap();
        }
        catch (GCUBEScopeNotSupportedException e) {
            this.logger.error((Object)("Scope not supported " + targetScope));
            throw new InvalidScopeFaultType();
        }
        try {
            Session report = new Session(UUIDGenFactory.getUUIDGen().nextUUID(), Session.OPERATION.Dispose, scope);
            this.getInstanceState().addSession(scope, report);
            this.getInstanceState().disposeState(scope, report);
            return report.getId();
        }
        catch (NoSuchResourceException e) {
            this.logger.error((Object)"No resource found for this scope", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("No resource found for this scope", e).toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to dispose the scope: " + e.getMessage()), (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to dispose the scope: " + e.getMessage(), e).toFault(new String[0]);
        }
    }

    public synchronized void createScope(CreateScopeParameters params) throws InvalidScopeFaultType, InvalidOptionsFaultType, GCUBEFault {
        GCUBEScope scope = ScopeUtils.validate(params.getTargetScope().trim());
        if (ScopeUtils.exists(scope, this)) {
            this.logger.warn((Object)("Target scope " + scope.toString() + " already exits and cannot be re-created"));
            throw new InvalidScopeFaultType();
        }
        try {
            scope.getServiceMap();
        }
        catch (GCUBEScope.MalformedScopeExpressionException e) {
            throw new InvalidScopeFaultType();
        }
        catch (GCUBEScopeNotSupportedException e) {
            params.getServiceMap();
        }
        try {
            this.getInstanceState().createState(scope);
            ScopeUtils.addToInstance(scope, this);
        }
        catch (Exception e) {
            this.logger.error((Object)("Failed to create the scope: " + scope.toString()), (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to add this Resource Managet to the scope: " + e.getMessage(), e).toFault(new String[0]);
        }
        if (params.getOptionsParameters() != null) {
            params.getOptionsParameters().setTargetScope(params.getTargetScope());
            this.changeScopeOptions(params.getOptionsParameters());
        }
    }

    public void changeScopeOptions(OptionsParameters options) throws InvalidOptionsFaultType, InvalidOptionsFaultType, GCUBEFault {
        PublishedScopeResource scoperesource = null;
        GCUBEScope scope = ScopeUtils.validate(options.getTargetScope().trim());
        if (!ScopeUtils.exists(scope, this)) {
            this.logger.warn((Object)("Target scope " + scope.toString() + " does not exists and cannot be modified"));
            throw new InvalidScopeFaultType();
        }
        try {
            scoperesource = this.getInstanceState().getPublishedScopeResource(scope);
        }
        catch (NoSuchResourceException e) {
            this.logger.error((Object)"No resource found for this scope", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("No resource found for this scope", e).toFault(new String[0]);
        }
        catch (Exception e) {
            this.logger.error((Object)"Change Scope Options fault: ", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Change Scope Options fault: ", e).toFault(new String[0]);
        }
        for (ScopeOption option : options.getScopeOptionList()) {
            if (option == null) continue;
            this.logger.trace((Object)("ScopeOption received: " + option.getName() + "=" + option.getValue()));
            try {
                scoperesource.setOption(option.getName().trim(), option.getValue().trim());
            }
            catch (PublishedScopeResource.UnknownScopeOptionException e) {
                this.logger.warn((Object)("Unknown option: " + option.getName()));
                throw new InvalidOptionsFaultType();
            }
            catch (Exception e) {
                this.logger.warn((Object)("Unable to read option: " + option.getName()));
                throw new InvalidOptionsFaultType();
            }
        }
        try {
            scoperesource.publish();
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to publish the ScopeResouce", (Throwable)e);
            throw ServiceContext.getContext().getDefaultException("Unable to publish the ScopeResouce", e).toFault(new String[0]);
        }
    }
}

