/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.impl.state.observers;

import java.util.HashSet;
import org.gcube.vremanagement.resourcemanager.impl.operators.Operator;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedDeployedSoftware;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedResource;
import org.gcube.vremanagement.resourcemanager.impl.resources.ScopedRunningInstance;
import org.gcube.vremanagement.resourcemanager.impl.resources.ServiceNotFoundException;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;
import org.gcube.vremanagement.resourcemanager.impl.state.VirtualNode;
import org.gcube.vremanagement.resourcemanager.impl.state.observers.ScopeObserver;

public class Executor
extends ScopeObserver {
    @Override
    protected void scopeChanged(ScopeState scopeState) {
        if (scopeState.getLastOperationPerformed() == ScopeState.OPERATION.EXECUTED) {
            return;
        }
        boolean managed = false;
        HashSet<ScopedResource> toRemoveFromScope = new HashSet<ScopedResource>();
        HashSet<ScopedResource> toRemoveFromState = new HashSet<ScopedResource>();
        for (ScopedResource ri : scopeState.getResourcesByType("RunningInstance")) {
            switch (ri.getStatus()) {
                case ADDREQUESTED: {
                    this.addResourceToScope(ri);
                    managed = true;
                    break;
                }
                case REMOVEREQUESTED: {
                    try {
                        if (((ScopedRunningInstance)ri).isUndeployNeeded()) {
                            try {
                                ScopedDeployedSoftware relatedSoftware = scopeState.getRelatedDeployedSoftware(((ScopedRunningInstance)ri).getSourcePackage());
                                this.logger.debug((Object)("Removing " + relatedSoftware + " from the scope"));
                                scopeState.getLastReport().addResource(relatedSoftware);
                                scopeState.getLastReport().addService(relatedSoftware);
                                toRemoveFromScope.add(relatedSoftware);
                                ((ScopedRunningInstance)ri).wasSuccessful();
                                ri.setStatus(ScopedResource.STATUS.REMOVED);
                            }
                            catch (ServiceNotFoundException e) {
                                ((ScopedRunningInstance)ri).reportFailureOnSourceService("Unable to find the source package. It might not be deployed in this scope", e);
                                ri.setStatus(ScopedResource.STATUS.LOST);
                                toRemoveFromState.add(ri);
                            }
                        } else {
                            this.removeResourceFromScope(ri);
                            toRemoveFromState.add(ri);
                        }
                    }
                    catch (ScopedResource.ResourceNotFound e) {
                        ri.setStatus(ScopedResource.STATUS.LOST);
                    }
                    managed = true;
                }
            }
        }
        for (ScopedResource resource : scopeState.getAllResources()) {
            if (resource.getType().equalsIgnoreCase("RunningInstance")) continue;
            switch (resource.getStatus()) {
                case ADDREQUESTED: {
                    this.addResourceToScope(resource);
                    managed = true;
                    break;
                }
                case REMOVEREQUESTED: {
                    this.removeResourceFromScope(resource);
                    toRemoveFromState.add(resource);
                    managed = true;
                }
            }
        }
        if (managed) {
            scopeState.setLastOperationPerformed(ScopeState.OPERATION.EXECUTED);
            scopeState.notifyObservers();
        }
        if (toRemoveFromScope.size() > 0) {
            try {
                scopeState.removeResources(toRemoveFromScope);
                toRemoveFromState.addAll(toRemoveFromScope);
            }
            catch (VirtualNode.NoGHNFoundException e) {
                this.logger.error((Object)"cannot remove one of the software its hosting node:", (Throwable)e);
            }
        }
        scopeState.forceResourceRemoval(toRemoveFromState);
    }

    private void addResourceToScope(ScopedResource resource) {
        try {
            resource.doAction(Operator.ACTION.ADD);
            resource.setStatus(ScopedResource.STATUS.ADDED);
        }
        catch (ScopedResource.ResourceNotFound e) {
            resource.setStatus(ScopedResource.STATUS.REMOVED);
        }
        catch (Exception e) {
            resource.setStatus(ScopedResource.STATUS.LOST);
        }
    }

    private void removeResourceFromScope(ScopedResource resource) {
        try {
            resource.doAction(Operator.ACTION.REMOVE);
            resource.setStatus(ScopedResource.STATUS.REMOVED);
        }
        catch (ScopedResource.ResourceNotFound e) {
            resource.setStatus(ScopedResource.STATUS.REMOVED);
        }
        catch (Exception e) {
            resource.setStatus(ScopedResource.STATUS.LOST);
        }
    }
}

