package org.gcube.vremanagement.resourcemanager.impl.state.observers;

import org.gcube.vremanagement.resourcemanager.impl.state.PublishedScopeResource;
import org.gcube.vremanagement.resourcemanager.impl.state.ScopeState;

/**
 * Performs scope disposal operations
 * @author manuele simi (CNR)
 *
 */
public class Disposer extends ScopeObserver {

	@Override
	protected void scopeChanged(ScopeState scopeState) {
		if (scopeState.isDisposed()) {
			logger.info("Disposer activated for " + scopeState.getScope().toString());
			//remove the serialized state
			Serializer.getSerializationFile(scopeState.getScope()).delete();
			//remove the resource from the IS
			try {
				PublishedScopeResource.getResource(scopeState.getScope()).dismiss();
			} catch (Exception e) {
				logger.error("Unable to delete the resource from the IS for " + scopeState.getScope().toString(),e);
			}

		}
	}

}
