/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.ghnmanager.impl.platforms;

import java.util.Collection;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.ghnmanager.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.ghnmanager.impl.platforms.PlatformApplication;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;
import org.gcube.vremanagement.virtualplatform.model.Package;
import org.gcube.vremanagement.virtualplatform.model.PackageSet;

public class PlatformCall {
    private final GCUBELog logger = new GCUBELog(PlatformCall.class);
    private VirtualPlatform platform;
    private Package app;

    public PlatformCall(VirtualPlatform platform) {
        this.platform = platform;
    }

    public void initialize() throws Exception {
        this.platform.initialize();
        if (this.platform.isAvailable()) {
            this.activateAllInstances();
        }
    }

    public void shutdown() throws Exception {
        if (this.platform.isAvailable()) {
            this.deactivateAllInstances();
        }
        this.platform.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateAllInstances() {
        Collection instances = GHNContext.getContext().getLocalInstanceContext().getAllInstances();
        for (GCUBERunningInstance instance : instances) {
            if (!instance.getPlatform().getName().equalsIgnoreCase(this.platform.getName()) || instance.getPlatform().getVersion() != this.platform.getVersion()) continue;
            PlatformCall call = new PlatformCall(this.platform);
            try {
                this.logger.info((Object)("Deactivating instance " + instance.getDeploymentData().getInstanceName()));
                PlatformApplication app = call.deactivate(instance);
                app.publish(instance.getScopes().values(), (GCUBESecurityManager)ServiceContext.getContext(), GCUBEServiceContext.Status.DOWN);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to deactivate instance " + instance.getDeploymentData().getInstanceName()), (Throwable)e);
            }
            finally {
                try {
                    GHNContext.getContext().getLocalInstanceContext().registerInstance(instance);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Failed to register in down state the instance " + instance.getDeploymentData().getInstanceName()), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateAllInstances() {
        Collection instances = GHNContext.getContext().getLocalInstanceContext().getAllInstances();
        for (GCUBERunningInstance instance : instances) {
            if (!instance.getPlatform().getName().equalsIgnoreCase(this.platform.getName()) || instance.getPlatform().getVersion() != this.platform.getVersion()) continue;
            PlatformCall call = new PlatformCall(this.platform);
            try {
                this.logger.info((Object)("Activating instance " + instance.getDeploymentData().getInstanceName()));
                PlatformApplication app = call.activate(instance);
                app.publish(instance.getScopes().values(), (GCUBESecurityManager)ServiceContext.getContext(), GCUBEServiceContext.Status.READIED);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed to activate instance " + instance.getDeploymentData().getInstanceName()), (Throwable)e);
            }
            finally {
                try {
                    GHNContext.getContext().getLocalInstanceContext().registerInstance(instance);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Failed to register in down state the instance " + instance.getDeploymentData().getInstanceName()), (Throwable)e);
                }
            }
        }
    }

    public PlatformApplication activate(GCUBERunningInstance instance) throws Exception {
        this.app = this.platform.getNewAppInstance();
        this.app.setTargetPath(instance.getDeploymentData().getLocalPath());
        this.app.setName(instance.getDeploymentData().getInstanceName());
        PackageSet packages = new PackageSet();
        packages.add((Object)this.app);
        if (!this.platform.activate(packages)) {
            throw new Exception("Failed to activate " + instance.getDeploymentData().getInstanceName());
        }
        this.logger.debug((Object)("Application " + instance.getDeploymentData().getInstanceName() + " successfully activated"));
        return new PlatformApplication(instance);
    }

    public PlatformApplication deactivate(GCUBERunningInstance instance) throws Exception {
        this.app = this.platform.getNewAppInstance();
        this.app.setTargetPath(instance.getDeploymentData().getLocalPath());
        this.app.setName(instance.getDeploymentData().getInstanceName());
        PackageSet packages = new PackageSet();
        packages.add((Object)this.app);
        if (!this.platform.deactivate(packages)) {
            throw new Exception("Failed to deactivate " + instance.getDeploymentData().getInstanceName());
        }
        this.logger.debug((Object)("Application " + instance.getDeploymentData().getInstanceName() + " successfully deactivated"));
        return new PlatformApplication(instance);
    }
}

