/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.stubs;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.utils.logging.GCUBEClientLog;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.executor.stubs.MappingRegistry;
import org.gcube.vremanagement.executor.stubs.TaskProxy;
import org.gcube.vremanagement.executor.stubs.Utils;
import org.globus.wsrf.NotifyCallback;
import org.oasis.wsn.Subscribe;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;

public abstract class TaskMonitor
implements NotifyCallback {
    static GCUBELog logger = new GCUBEClientLog(TaskMonitor.class, new Properties[0]);
    private List<TaskTopic> topics;
    private TaskProxy proxy;

    public TaskMonitor(TaskTopic ... topics) {
        this.topics = Arrays.asList(topics != null && topics.length > 0 ? topics : TaskTopic.values());
    }

    public List<TaskTopic> getTopics() {
        return this.topics;
    }

    protected void subscribe(EndpointReferenceType epr) throws Exception {
        for (TaskTopic topic : this.getTopics()) {
            logger.trace((Object)("subscribing for " + (Object)((Object)topic)));
            EndpointReferenceType consumerEPR = MappingRegistry.manager.createNotificationConsumer((NotifyCallback)this);
            Subscribe subscriptionRequest = new Subscribe();
            subscriptionRequest.setUseNotify(Boolean.TRUE);
            subscriptionRequest.setConsumerReference(consumerEPR);
            TopicExpressionType topicExpression = new TopicExpressionType();
            topicExpression.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
            topicExpression.setValue((Object)topic.getQName());
            subscriptionRequest.setTopicExpression(topicExpression);
            new WSBaseNotificationServiceAddressingLocator().getNotificationProducerPort(epr).subscribe(subscriptionRequest);
        }
        try {
            logger.trace((Object)"post-subscription delivery");
            this.proxy = new TaskProxy(epr);
            for (TaskTopic topic : this.getTopics()) {
                topic.callback(this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"could not process event", (Throwable)e);
        }
    }

    public void deliver(List topicPath, EndpointReferenceType producer, Object message) {
        try {
            QName topic = (QName)topicPath.get(0);
            logger.trace((Object)("processing event for " + topic));
            this.proxy.synchronize();
            for (TaskTopic t : this.getTopics()) {
                if (!topic.equals(t.getQName())) continue;
                t.callback(this);
            }
        }
        catch (Exception e) {
            logger.error((Object)"could not process event", (Throwable)e);
        }
    }

    protected void onStateChange(TaskProxy proxy) throws Exception {
    }

    protected void onOutputChange(TaskProxy proxy) throws Exception {
    }

    public static enum TaskTopic {
        STATECHANGE{

            @Override
            public QName getQName() {
                return Utils.TASK_STATE_RP;
            }

            @Override
            public void callback(TaskMonitor monitor) throws Exception {
                monitor.onStateChange(monitor.proxy);
            }
        }
        ,
        OUTPUTCHANGE{

            @Override
            public QName getQName() {
                return Utils.TASK_OUTPUT_RP;
            }

            @Override
            public void callback(TaskMonitor monitor) throws Exception {
                monitor.onOutputChange(monitor.proxy);
            }
        };


        abstract QName getQName();

        abstract void callback(TaskMonitor var1) throws Exception;
    }
}

