/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.state;

import java.util.Calendar;
import java.util.Map;
import javax.naming.OperationNotSupportedException;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeManager;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.handlers.GCUBEScheduledHandler;
import org.gcube.common.core.utils.handlers.events.Event;
import org.gcube.common.core.utils.handlers.events.Monitor;
import org.gcube.common.core.utils.handlers.events.Topic;
import org.gcube.common.core.utils.handlers.lifetime.State;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.vremanagement.executor.contexts.ServiceContext;
import org.gcube.vremanagement.executor.plugin.ExecutorPluginContext;
import org.gcube.vremanagement.executor.plugin.ExecutorTask;
import org.gcube.vremanagement.executor.state.TaskRuntime;
import org.gcube.vremanagement.executor.stubs.AnyMap;
import org.gcube.vremanagement.executor.stubs.TaskDescription;
import org.gcube.vremanagement.executor.stubs.Utils;
import org.globus.wsrf.ResourceProperty;

public class TaskResource
extends GCUBEWSResource {
    static final String RP_TYPE = "Type";
    static final String RP_START_TIME = "Started";
    static final String RP_STATE = "State";
    static final String RP_PARAMS = "Inputs";
    static final String RP_OUTPUT = "Outputs";
    static final String RP_LOG = "Log";
    static final String RP_ERROR = "Error";
    private static String[] RPNames = new String[]{"Type", "Started", "Inputs", "Log", "Error"};
    private static String[] TopicNames = new String[]{"Outputs", "State"};
    private static final int LOG_LINE_SIZE = 10;
    transient ExecutorPluginContext context;
    transient boolean isScheduled = false;
    transient ExecutorTask task;
    transient TaskRuntime runtime;

    public String[] getPropertyNames() {
        return RPNames;
    }

    protected String[] getTopicNames() {
        return TopicNames;
    }

    protected void initialise(Object ... args) throws Exception {
        if (args.length != 2) {
            throw new IllegalArgumentException("plugin context and task inputs expected");
        }
        this.setContext((ExecutorPluginContext)((Object)args[0]));
        this.setInputs(Utils.intern((AnyMap)((AnyMap)args[1])));
        this.setStartTime(Calendar.getInstance());
        this.launch(this.getServiceContext().getScope());
    }

    public ExecutorPluginContext getContext() {
        return this.context;
    }

    public void setContext(ExecutorPluginContext context) {
        this.context = context;
        this.setType(context.getDescription());
    }

    public ExecutorTask getTask() {
        return this.task;
    }

    public void setStartTime(Calendar value) {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_START_TIME);
        prop.clear();
        prop.add((Object)value);
    }

    public Calendar getStartTime() {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_START_TIME);
        return (Calendar)prop.get(0);
    }

    protected void setType(TaskDescription value) {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_TYPE);
        prop.clear();
        prop.add((Object)value);
    }

    public synchronized void setState(String value) {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_STATE);
        prop.clear();
        prop.add((Object)value);
    }

    public void setInputs(Map<String, Object> inputs) {
        if (inputs == null) {
            return;
        }
        ResourceProperty prop = this.getResourcePropertySet().get(RP_PARAMS);
        prop.clear();
        prop.add((Object)Utils.extern(inputs));
    }

    public Map<String, Object> getInputs() {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_PARAMS);
        return prop.size() == 0 ? null : Utils.intern((AnyMap)((AnyMap)prop.get(0)));
    }

    public synchronized void setOutputs(Map<String, Object> outputs) {
        if (outputs == null) {
            return;
        }
        ResourceProperty prop = this.getResourcePropertySet().get(RP_OUTPUT);
        prop.clear();
        prop.add((Object)Utils.extern(outputs));
        this.store();
    }

    public synchronized Map<String, Object> getOutputs() {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_OUTPUT);
        return prop.size() == 0 ? null : Utils.intern((AnyMap)((AnyMap)prop.get(0)));
    }

    public synchronized void setError(String value) {
        if (value == null) {
            return;
        }
        ResourceProperty prop = this.getResourcePropertySet().get(RP_ERROR);
        prop.clear();
        prop.add((Object)value);
        this.store();
    }

    public String getError() {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_ERROR);
        return prop.size() > 0 ? (String)prop.get(0) : null;
    }

    private synchronized void log(String msg) {
        msg = "[" + Calendar.getInstance().getTime() + "] " + msg;
        ResourceProperty prop = this.getResourcePropertySet().get(RP_LOG);
        StringBuilder log = new StringBuilder(this.getLog() == null ? "" : (String)prop.get(0));
        log.append(msg + "\n");
        if (log.toString().split("\n").length > 10) {
            log.delete(0, log.indexOf("\n") + 1);
        }
        this.setLog(log.toString());
        this.store();
    }

    public synchronized void setLog(String value) {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_LOG);
        prop.clear();
        prop.add((Object)("\n" + value.toString()));
    }

    public synchronized String getLog() {
        ResourceProperty prop = this.getResourcePropertySet().get(RP_LOG);
        return prop.size() == 0 ? null : (String)prop.get(0);
    }

    public void stop() throws OperationNotSupportedException, Exception {
        this.getTask().stop();
    }

    public void launch(GCUBEScope scope) throws Exception {
        this.task = this.context.getTaskClass().newInstance();
        this.task.setName(this.context.getPlugin().getServiceName());
        this.runtime = new TaskRuntime(this);
        this.task.setHandled(this.runtime);
        TaskLog runtimeLogger = new TaskLog((Object)this);
        this.task.setLogger(runtimeLogger);
        this.task.setScopeManager((GCUBEScopeManager)this.getServiceContext());
        this.task.setSecurityManager((GCUBESecurityManager)this.getServiceContext());
        if (GCUBEScheduledHandler.class.isAssignableFrom(this.task.getClass())) {
            this.isScheduled = true;
            GCUBEScheduledHandler scheduler = (GCUBEScheduledHandler)this.task;
            scheduler.getScheduled().setHandled((Object)this.runtime);
            scheduler.getScheduled().setLogger(scheduler.getLogger());
            ServiceContext.getContext().getPluginManager().subscribe((GCUBEPluginManager.PluginConsumer)new ScheduledTaskConsumer(), new GCUBEPluginManager.PluginTopic[]{GCUBEPluginManager.PluginTopic.DEREGISTRATION});
        }
        this.task.subscribe(new TaskMonitor(), new Topic[0]);
        this.setState(this.task.getState().toString());
        Thread t = new Thread("task-" + ((GCUBEWSResourceKey)this.getID()).getValue() + "-execution"){

            @Override
            public void run() {
                try {
                    TaskResource.this.task.run();
                }
                catch (Exception e) {
                    TaskResource.this.logger.trace((Object)("task " + TaskResource.this.task.getName() + " failed"), (Throwable)e);
                    TaskResource.this.runtime.throwException(e);
                    TaskResource.this.setState(State.Failed.INSTANCE.toString());
                }
            }
        };
        this.getServiceContext().setScope(t, scope);
        this.getServiceContext().useCallerCredentials(new Thread[]{t});
        t.start();
    }

    public void store() {
        if (!this.isScheduled) {
            return;
        }
        super.store();
    }

    private class TaskMonitor
    extends Monitor {
        private TaskMonitor() {
        }

        protected void onCompletion(Event.Done e) {
            this.setExpirationTime();
        }

        protected void onFailure(Event.Failed e) {
            this.setExpirationTime();
        }

        private void setExpirationTime() {
            Calendar time = Calendar.getInstance();
            time.add(12, Math.min(TaskResource.this.getContext().getTimeToLive(), 60));
            TaskResource.this.setTerminationTime(time);
            TaskResource.this.store();
        }

        protected void onAnyEvent(Event<?, ?> e) {
            super.onAnyEvent(e);
            if (e instanceof Event.LifetimeEvent) {
                TaskResource.this.setState(((GCUBEHandler)((Event.LifetimeEvent)e).getPayload()).getState().toString());
            }
        }
    }

    public class TaskLog
    extends GCUBELog {
        public TaskLog(Object obj) {
            super(obj);
        }

        public void error(Object arg0) {
            super.error(arg0);
            TaskResource.this.log("ERROR:" + arg0.toString());
        }

        public void error(Object arg0, Throwable arg1) {
            super.error(arg0, arg1);
            TaskResource.this.log("ERROR:" + arg0.toString());
        }

        public void fatal(Object arg0) {
            super.fatal(arg0);
            TaskResource.this.log("FATAL:" + arg0.toString());
        }

        public void fatal(Object arg0, Throwable arg1) {
            super.fatal(arg0, arg1);
            TaskResource.this.log("FATAL:" + arg0.toString());
        }

        public void info(Object arg0) {
            super.info(arg0);
            TaskResource.this.log("INFO:" + arg0.toString());
        }

        public void info(Object arg0, Throwable arg1) {
            super.info(arg0, arg1);
            TaskResource.this.log("INFO:" + arg0.toString());
        }

        public void warn(Object arg0) {
            super.warn(arg0);
            TaskResource.this.log("WARN:" + arg0.toString());
        }

        public void warn(Object arg0, Throwable arg1) {
            super.warn(arg0, arg1);
            TaskResource.this.log("WARN:" + arg0.toString());
        }
    }

    private class ScheduledTaskConsumer
    extends GCUBEPluginManager.PluginConsumer<ExecutorPluginContext> {
        private ScheduledTaskConsumer() {
        }

        protected void onDeregistration(GCUBEEvent<? extends GCUBEPluginManager.PluginTopic, ? extends ExecutorPluginContext> event) {
            if (event.getPayload() == TaskResource.this.getContext()) {
                ((GCUBEScheduledHandler)TaskResource.this.getTask()).stop();
            }
        }
    }
}

