package org.gcube.vremanagement.executor.contexts;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.vremanagement.executor.state.EngineResource;

/**
 * The context of the <code>Engine</code> port-type of the service.
 * @author Fabio Simeoni (University of Strathclyde).
 **/
public class EnginePTContext extends GCUBEStatefulPortTypeContext {
	
	/** Port-type JNDI name. */
	static public final String PORTTYPE_NAME = "gcube/vremanagement/executor/engine";
	
	/**  Port-type namespace. */
	static public final String PORTTYPE_NAMESPACE = "http://gcube-system.org/namespaces/vremanagement/executor";
	
	/** Singleton engine identifier. */
	private static final String SINGLETON_ENGINE_ID = "engine";

	/** Singleton instance. */
	protected static EnginePTContext cache = new EnginePTContext();

	/** Creates an instance . */
	private EnginePTContext(){}
	
	/** Returns a context instance.
	 * @return the context.*/
	public static EnginePTContext getContext() {return cache;}
	
	/**{@inheritDoc}*/
	public String getJNDIName() {return PORTTYPE_NAME ;}

	/** {@inheritDoc}*/
	public String getNamespace() {return PORTTYPE_NAMESPACE;}
	
	/**
	 * Returns the singleton {@link EngineResource} of the port-type.. 
	 * @return the engine.
	 * @throws Exception if the engine could not be returned.
	 */
	public EngineResource getEngine() throws Exception {
		return (EngineResource) getWSHome().find(makeKey(SINGLETON_ENGINE_ID));
	}
	
	/**
	 * Creates th singleton {@link EngineResource} of the port-type.
	 * @throws Exception if the engine could not be created.
	 */
	public EngineResource createEngine() throws Exception {
		return (EngineResource) getWSHome().create(makeKey(SINGLETON_ENGINE_ID));
		
	}
	
	/**{@inheritDoc} */
	public GCUBEServiceContext getServiceContext() {return ServiceContext.getContext();}

}
