package org.gcube.vremanagement.executor.state;

import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.vremanagement.executor.contexts.EnginePTContext;
import org.globus.wsrf.ResourceException;

/**
 * Extends {@link GCUBEWSHome} for the singleton {@link EngineResource}.
 * @author Fabio Simeoni (University of Strathclyde)
 */
public class EngineHome extends GCUBEWSHome{

	/**{@inheritDoc}*/
	public GCUBEStatefulPortTypeContext getPortTypeContext() { return EnginePTContext.getContext(); }
	
	//synchronise initialisation and creation to avoid engine creation occurs before home is ready
	
	@Override
	/**{@inheritDoc}*/
	protected synchronized void onInitialisation() throws Exception {
		super.onInitialisation();
	}
	
	@Override
	/**{@inheritDoc}*/
	public synchronized GCUBEWSResource create(GCUBEWSResourceKey id, Object... params) throws ResourceException {
		return super.create(id, params);
	}

}
