/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.deployment;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.vremanagement.softwaregateway.stubs.AccessPortType;
import org.gcube.vremanagement.softwaregateway.stubs.PackageCoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.SACoordinates;
import org.gcube.vremanagement.softwaregateway.stubs.service.AccessServiceAddressingLocator;

public class Downloader {
    protected AntRunner run;
    protected final GCUBELog logger = new GCUBELog(Downloader.class);
    public String packagename = "";
    protected String packageVersion = "";
    public File downloadedFile;
    protected String serviceID;
    protected String serviceName = "";
    protected String serviceKey = "";
    protected static final String REPOSITORY_ENDPOINT = "gcube/vremanagement/softwaregateway/Access";
    protected static final String REPOSITORY_NAME = "SoftwareGateway";
    protected static final String REPOSITORY_CLASS = "VREManagement";
    protected String serviceClass = "";
    protected String serviceVersion = "";
    protected String packagedir;
    private String packageFilesDir;
    protected boolean update = false;
    protected PackageType packagetype = PackageType.UNKNOWN;

    public Downloader(PackageInfo deployable_package, boolean ... update) throws DeployException, Exception {
        this.packagename = deployable_package.getName();
        this.serviceKey = deployable_package.getServiceClass() + "-" + deployable_package.getServiceName() + "-" + deployable_package.getServiceVersion();
        this.packagedir = Configuration.BASEDEPLOYDIR + File.separator + this.serviceKey;
        this.packageFilesDir = this.packagedir + File.separator + this.packagename;
        this.serviceClass = deployable_package.getServiceClass();
        this.serviceName = deployable_package.getServiceName();
        this.serviceVersion = deployable_package.getServiceVersion();
        this.packageVersion = deployable_package.getVersion();
        if (update == null || update.length == 0) {
            this.update = false;
        } else if (update[0]) {
            this.update = true;
            this.removeFiles();
        }
        this.initAntContext();
    }

    private void initAntContext() throws Exception {
        try {
            this.run = new AntRunner();
            this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
        }
        catch (Exception e) {
            this.logger.error((Object)("Package deployer is unable to initialize the deployment environment for " + this.packagename), (Throwable)e);
            throw new Exception("Package deployer is unable to initialize the deployment environment for " + this.packagename);
        }
    }

    public String downloadPackage(GCUBEScope ... scope) throws UnreachablePackageException, Exception {
        block10: {
            this.logger.trace((Object)("downloading the package " + this.packagename + "... "));
            if (scope != null && scope.length > 0) {
                if (scope[0].getType() == GCUBEScope.Type.VRE) {
                    scope[0] = scope[0].getEnclosingScope();
                }
                try {
                    return this.downloadPackageFromScope(scope[0]);
                }
                catch (UnreachablePackageException voe) {
                    this.logger.warn((Object)("Unable to download the package from the Scope " + scope[0]));
                    if (scope[0].getType() != GCUBEScope.Type.VO && scope[0].getType() != GCUBEScope.Type.VRE) break block10;
                    return this.downloadPackageFromScope(scope[0].getEnclosingScope());
                }
            }
        }
        for (GCUBEScope instancescope : ServiceContext.getContext().getInstance().getScopes().values()) {
            try {
                return this.downloadPackageFromScope(instancescope);
            }
            catch (Exception voe) {
                this.logger.warn((Object)("Unable to download the package from the scope " + instancescope));
                for (GCUBEScope ghnscope : GHNContext.getContext().getGHN().getScopes().values()) {
                    try {
                        return this.downloadPackageFromScope(ghnscope);
                    }
                    catch (Exception upe) {
                        this.logger.warn((Object)("Unable to download the package from the Scope " + ghnscope));
                    }
                }
            }
        }
        throw new UnreachablePackageException();
    }

    public String downloadPackage(File file) throws DeployException, IOException, InvalidPackageArchiveException {
        String filePathName = Configuration.BASESOURCEDIR + File.separator + this.packagename;
        if (!file.exists()) {
            throw new IOException("The package cannot be downloaded, the local path " + file.getCanonicalPath() + " does not exist");
        }
        this.logger.trace((Object)("Copying " + file.getCanonicalPath() + " to " + filePathName));
        this.downloadedFile = new File(filePathName);
        this.copy(file, this.downloadedFile);
        return filePathName;
    }

    private void copy(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public String downloadPatch(URI uri) throws UnreachablePackageException, DeployException, InvalidPackageArchiveException {
        return this.internalHTTPdownload(Configuration.BASEPATCHDIR, uri);
    }

    public String downloadPackage(URI uri) throws UnreachablePackageException, DeployException, InvalidPackageArchiveException {
        return this.internalHTTPdownload(Configuration.BASESOURCEDIR, uri);
    }

    protected String internalHTTPdownload(String baseDir, URI uri) throws UnreachablePackageException, DeployException, InvalidPackageArchiveException {
        this.logger.trace((Object)("Downloading the package " + this.packagename + "... "));
        String filePathName = baseDir + File.separator + this.packagename;
        DataInputStream is = null;
        int code = -999;
        try {
            HttpURLConnection urlC = (HttpURLConnection)new URL(uri.toString()).openConnection();
            urlC.setRequestMethod("GET");
            urlC.setDoInput(true);
            urlC.setDoOutput(true);
            urlC.setDoOutput(true);
            urlC.setUseCaches(false);
            urlC.setInstanceFollowRedirects(true);
            this.logger.trace((Object)("Getting data from " + uri.toString() + "..."));
            is = new DataInputStream(urlC.getInputStream());
            code = urlC.getResponseCode();
        }
        catch (Exception e) {
            this.logger.error((Object)"", (Throwable)e);
            throw new UnreachablePackageException();
        }
        FilterOutputStream o = null;
        try {
            this.logger.trace((Object)("Connection return code: " + code));
            this.logger.trace((Object)("Bytes available out: " + is.available()));
            this.logger.trace((Object)"Open URL connection and saving to local cache..");
            o = new DataOutputStream(new FileOutputStream(filePathName));
            this.logger.trace((Object)("Saving package to = " + filePathName));
            while (true) {
                byte b = is.readByte();
                ((DataOutputStream)o).writeByte(b);
            }
        }
        catch (EOFException ee) {
            try {
                o.close();
            }
            catch (Exception e) {}
        }
        catch (Exception e) {
            try {
                this.logger.error((Object)("Unable to download  the package from the URI " + uri), (Throwable)e);
                throw new UnreachablePackageException();
            }
            catch (Throwable throwable) {
                try {
                    o.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.downloadedFile = new File(filePathName);
        return filePathName;
    }

    private String downloadPackageFromScope(GCUBEScope scope) throws UnreachablePackageException, DeployException, InvalidPackageArchiveException {
        String filePathName;
        block24: {
            this.logger.debug((Object)("The Deployer is trying to download the package from Scope " + scope + "..."));
            filePathName = Configuration.BASESOURCEDIR + File.separator + this.packagename;
            String packageURI = null;
            for (EndpointReferenceType epr : this.findInstances(scope)) {
                AccessPortType pt;
                try {
                    AccessServiceAddressingLocator locator = new AccessServiceAddressingLocator();
                    pt = locator.getAccessPortTypePort(epr);
                    pt = (AccessPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)scope, (GCUBESecurityManager[])new GCUBESecurityManager[]{ServiceContext.getContext()});
                }
                catch (Exception e) {
                    this.logger.error((Object)"Unable to contact the Software Gateway service", (Throwable)e);
                    throw new UnreachablePackageException();
                }
                StringBuilder messageAsString = new StringBuilder();
                messageAsString.append("downloading ");
                messageAsString.append("ServiceClass=").append(this.serviceClass);
                messageAsString.append(", ServiceName=").append(this.serviceName);
                messageAsString.append(", ServiceVersion=").append(this.serviceVersion);
                messageAsString.append(", PackageName=").append(this.packagename);
                messageAsString.append(", PackageVersion=").append(this.packageVersion);
                messageAsString.append(" from ").append(epr.toString());
                this.logger.debug((Object)messageAsString);
                try {
                    SACoordinates coordinates = new SACoordinates();
                    coordinates.setPackageName(this.packagename);
                    coordinates.setServiceClass(this.serviceClass);
                    coordinates.setServiceName(this.serviceName);
                    coordinates.setServiceVersion(this.serviceVersion);
                    coordinates.setPackageVersion(this.packageVersion);
                    packageURI = pt.getSALocation(coordinates);
                    this.logger.debug((Object)("returned URL for SA = " + packageURI));
                    if (packageURI != null && packageURI.compareTo("") != 0) break;
                    this.logger.error((Object)("Unable to retrieve the package '" + this.packagename + "' from the SoftwareRepository service"));
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Unable to retrieve the SA from the Software Gateway service in scope " + scope), (Throwable)e);
                    this.logger.debug((Object)"Trying to directly access the package");
                    try {
                        PackageCoordinates coordinates = new PackageCoordinates();
                        coordinates.setPackageName(this.packagename);
                        coordinates.setServiceClass(this.serviceClass);
                        coordinates.setServiceName(this.serviceName);
                        coordinates.setServiceVersion(this.serviceVersion);
                        coordinates.setPackageVersion(this.packageVersion);
                        packageURI = pt.getLocation(coordinates);
                        this.logger.debug((Object)("returned URL for package = " + packageURI));
                    }
                    catch (Exception e2) {
                        this.logger.warn((Object)("Unable to retrieve the package from the Software Gateway service in scope " + scope), (Throwable)e);
                    }
                    if (packageURI != null && packageURI.compareTo("") != 0) break;
                    this.logger.error((Object)("Unable to retrieve the package '" + this.packagename + "' from the SoftwareRepository service"));
                    throw new UnreachablePackageException();
                }
            }
            if (packageURI != null) {
                FilterInputStream is = null;
                HttpURLConnection urlC = null;
                int code = -999;
                try {
                    urlC = (HttpURLConnection)new URL(packageURI).openConnection();
                    urlC.setRequestMethod("GET");
                    urlC.setDoInput(true);
                    urlC.setDoOutput(true);
                    urlC.setDoOutput(true);
                    urlC.setUseCaches(false);
                    urlC.setInstanceFollowRedirects(true);
                    this.logger.trace((Object)"getting data from returned URL...");
                    is = new DataInputStream(urlC.getInputStream());
                    code = urlC.getResponseCode();
                }
                catch (MalformedURLException e) {
                    this.logger.error((Object)"Malformed URL Exception ", (Throwable)e);
                }
                catch (FileNotFoundException e) {
                    this.logger.error((Object)"File Not FoundException ", (Throwable)e);
                }
                catch (IOException e) {
                    this.logger.error((Object)"IO Exception ", (Throwable)e);
                }
                FilterOutputStream o = null;
                try {
                    this.logger.trace((Object)("connection return code: " + code));
                    this.logger.trace((Object)("bytes available out: " + is.available()));
                    this.logger.trace((Object)"open URL connection and saving to local cache...");
                    filePathName = filePathName + this.getFileExtension(packageURI, urlC);
                    File f = new File(filePathName);
                    if (f.exists()) {
                        f.delete();
                    }
                    o = new DataOutputStream(new FileOutputStream(filePathName));
                    this.logger.trace((Object)("Saving package to = " + filePathName));
                    while (true) {
                        byte b = ((DataInputStream)is).readByte();
                        ((DataOutputStream)o).writeByte(b);
                    }
                }
                catch (EOFException ee) {
                    this.logger.trace((Object)"Package successfully downloaded");
                    try {
                        o.close();
                    }
                    catch (Exception e) {}
                    break block24;
                }
                catch (Exception e) {
                    try {
                        this.logger.error((Object)"", (Throwable)e);
                        throw new UnreachablePackageException();
                    }
                    catch (Throwable throwable) {
                        try {
                            o.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            this.logger.error((Object)("Unable to download the package from the Software Gateway service beloging the Scope " + scope + ", the service replies with a null value"));
            throw new UnreachablePackageException();
        }
        this.downloadedFile = new File(filePathName);
        return filePathName;
    }

    private String getFileExtension(String packageURI, HttpURLConnection urlC) throws InvalidPackageArchiveException {
        if (packageURI.contains("e=tar.gz") || packageURI.contains("e=tgz")) {
            this.packagetype = PackageType.SERVICEARCHIVE;
            return ".tar.gz";
        }
        if (packageURI.contains("e=jar")) {
            this.packagetype = PackageType.JAR;
            return ".jar";
        }
        String type = urlC.getContentType().trim();
        this.logger.trace((Object)("Dectected content type: " + type));
        if (type.contentEquals("application/x-gzip") || type.contentEquals("application/gzip") || type.contentEquals("application/x-tar-gz")) {
            this.packagetype = PackageType.SERVICEARCHIVE;
            return ".tar.gz";
        }
        if (type.contentEquals("application/java-archive")) {
            this.packagetype = PackageType.JAR;
            return ".jar";
        }
        throw new InvalidPackageArchiveException("Unrecognized package extension");
    }

    protected void removeFiles() throws DeployException {
        try {
            AntRunner local_run = new AntRunner();
            local_run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("folder", Configuration.BASEDEPLOYDIR + File.separator + this.serviceID + File.separator + this.packagename);
            try {
                local_run.setProperties(properties, true);
                local_run.runTarget("deleteFolder");
            }
            catch (AntInterfaceException aie) {
                throw new DeployException(aie.getMessage());
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Unable to remove the package files for " + this.packagename), (Throwable)e);
            throw new DeployException("Unable to remove the package files for " + this.packagename);
        }
    }

    protected Set<EndpointReferenceType> findInstances(GCUBEScope scopeToCheckIn) {
        HashSet<EndpointReferenceType> endpoints = new HashSet<EndpointReferenceType>();
        this.logger.debug((Object)"Looking for SR instances...");
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERIQuery lookupQuery = (GCUBERIQuery)client.getQuery(GCUBERIQuery.class);
            lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", REPOSITORY_NAME)});
            lookupQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceClass", REPOSITORY_CLASS)});
            this.logger.debug((Object)("Quering in scope " + scopeToCheckIn));
            List list = client.execute((ISQuery)lookupQuery, scopeToCheckIn);
            this.logger.debug((Object)("Found N." + list.size() + " instances"));
            for (GCUBERunningInstance instance : list) {
                EndpointReferenceType epr = instance.getAccessPoint().getEndpoint(REPOSITORY_ENDPOINT);
                this.logger.trace((Object)("Found EPR " + epr.getAddress().toString()));
                endpoints.add(epr);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to query for SR's instances", (Throwable)e);
        }
        return endpoints;
    }

    public String getPackagename() {
        return this.packagename;
    }

    public String getPackagedir() {
        return this.packagedir;
    }

    public String getPackageFilesDir() {
        return this.packageFilesDir;
    }

    public String getServiceKey() {
        return this.serviceKey;
    }

    public PackageType getPackagetype() {
        return this.packagetype;
    }

    public boolean isUpdate() {
        return this.update;
    }

    public static class UnreachablePackageException
    extends Exception {
        private static final long serialVersionUID = 1324255717533638292L;
    }

    public static enum PackageType {
        JAR,
        SERVICEARCHIVE,
        UNKNOWN;

    }
}

