/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.deployment;

import java.io.File;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Extractor;

public abstract class BaseExtractor
implements Extractor {
    protected final GCUBELog logger = new GCUBELog(Extractor.class);
    protected AntRunner run;
    protected Downloader downloader;

    public BaseExtractor(Downloader downloader) throws Exception {
        this.downloader = downloader;
        this.initAntContext();
    }

    private void initAntContext() throws Exception {
        try {
            this.run = new AntRunner();
            this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
        }
        catch (Exception e) {
            this.logger.error((Object)"Package extractor is unable to initialize the deployment environment", (Throwable)e);
            throw new Exception("Package extractor is unable to initialize the deployment environment");
        }
    }

    public File getDownloadedFile() {
        return this.downloader.downloadedFile;
    }

    public String getServiceClass() {
        return this.downloader.serviceClass;
    }

    public String getServiceName() {
        return this.downloader.serviceName;
    }

    public String getName() {
        return this.downloader.packagename;
    }

    public String getVersion() {
        return this.downloader.packageVersion;
    }

    public String getServiceVersion() {
        return this.downloader.serviceVersion;
    }

    public String getServiceKey() {
        return this.downloader.getServiceKey();
    }

    public String getPackageFilesDir() {
        return this.downloader.getPackageFilesDir();
    }

    public boolean isUpdate() {
        return this.downloader.isUpdate();
    }

    public String getPackagedir() {
        return this.downloader.getPackagedir();
    }
}

