/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.undeployment;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.undeployment.UndeployablePackage;

public class UndeployableMainPackage
extends UndeployablePackage {
    private static final long serialVersionUID = -3848609283797739276L;
    protected transient AntRunner run;

    public UndeployableMainPackage(BaseTypedPackage base) {
        super(base);
        try {
            this.run = new AntRunner();
            this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
        }
        catch (Exception e) {
            this.logger.error((Object)"Package deployer is unable to initialize the deployment environment ", (Throwable)e);
        }
    }

    @Override
    public void packageUndeploy(Set<GCUBEScope> scopes, boolean cleanState) throws DeployException, InvalidPackageArchiveException {
        this.logger.trace((Object)("Undeploy operation called on a " + this.getType().name() + " package"));
        try {
            GHNContext.getContext().getServiceContext(this.getKey().getServiceClass(), this.getKey().getServiceName()).setStatus(GCUBEServiceContext.Status.DOWN);
        }
        catch (GCUBEServiceContext.IllegalStateTransitionException e) {
            this.logger.warn((Object)"Cannot move the RI to DOWN status from the current status");
        }
        catch (GCUBEServiceContext.StateTransitionException e) {
            this.logger.warn((Object)"Failed to move the RI to DOWN status");
        }
        catch (Exception e) {
            throw new DeployException(e.getMessage());
        }
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("gar.name", this.getProperty("gar.name"));
            this.run.setProperties(properties, true);
            this.run.runTarget("undeployWSRFService");
            if (cleanState) {
                File state = new File(GHNContext.getContext().getStorageRoot() + File.separator + this.getKey().getServiceName());
                this.logger.debug((Object)("Cleaning up the package state in " + GHNContext.getContext().getStorageRoot() + File.separator + this.getKey().getServiceName()));
                if (state.exists()) {
                    if (!this.deleteState(state)) {
                        this.logger.error((Object)"Unable to clean up the package state");
                        throw new DeployException("Unable to clean up the package state");
                    }
                } else {
                    this.logger.debug((Object)"The package has no state to clean up");
                }
            } else {
                this.logger.debug((Object)"The client has requested to keep the actual state of the package");
            }
        }
        catch (AntInterfaceException aie) {
            this.logger.error((Object)"Unable to undeploy the package ", (Throwable)aie);
            throw new DeployException(aie.getMessage());
        }
        catch (Exception e) {
            throw new DeployException(e.getMessage());
        }
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        this.logger.debug((Object)("Verifying folder " + GHNContext.getContext().getLocation() + File.separator + "etc" + File.separator + this.getProperty("gar.name")));
        return !new File(GHNContext.getContext().getLocation() + File.separator + "etc" + File.separator + this.getProperty("gar.name")).exists();
    }

    @Override
    public boolean requireRestart() {
        return true;
    }

    private boolean deleteState(File state) {
        if (state.exists()) {
            for (File file : state.listFiles()) {
                if (file.isDirectory()) {
                    this.deleteState(file);
                    continue;
                }
                this.logger.trace((Object)("Deleting state file " + file.getAbsolutePath()));
                file.delete();
            }
        }
        return state.delete();
    }
}

