/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.contexts;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.contexts.ghn.Events;
import org.gcube.common.core.contexts.ghn.GHNConsumer;
import org.gcube.common.core.plugins.GCUBEPluginManager;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBEResource;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Dependency;
import org.gcube.common.core.resources.service.MainPackage;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.contexts.RIConsumer;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.resources.BasePackage;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.Converter;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DMainPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DPlugin;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;

class HDeployerCompleteGHNState
extends GCUBEHandler<DeployerResource> {
    protected final GCUBELog logger = new GCUBELog(HDeployerCompleteGHNState.class);
    private DeployerResource resource;

    HDeployerCompleteGHNState() {
    }

    public void run() throws Exception {
        if (!GHNContext.getContext().isGHNReady()) {
            throw new Exception();
        }
        this.resource = (DeployerResource)((Object)this.getHandled());
        this.completeGHNProfile();
        try {
            this.manageLastReport();
        }
        catch (Exception e) {
            this.logger.warn((Object)"There is no last deployment report to manage", (Throwable)e);
        }
        GHNContext.getContext().setStatus(GHNContext.Status.UPDATED, new String[0]);
    }

    private void manageLastReport() {
        Report report = null;
        try {
            report = this.resource.getLastReport();
        }
        catch (Report.ReportNotFoundException e) {
            this.logger.warn((Object)"There is no last deployment report to manage");
            return;
        }
        this.logger.debug((Object)"Managing last deployment report");
        Set<? extends BasePackage> packages = this.resource.getPackagesToUpdate();
        for (BaseTypedPackage baseTypedPackage : packages) {
            this.logger.debug((Object)("Updating status for package: " + baseTypedPackage.getKey().toString()));
            this.logger.debug((Object)("Package type: " + baseTypedPackage.getType().name()));
            this.logger.debug((Object)("Package Class: " + baseTypedPackage.getClass().getSimpleName()));
            if (baseTypedPackage instanceof DMainPackage) {
                this.manageMainPackage(baseTypedPackage, report);
            } else if (baseTypedPackage instanceof DPlugin) {
                this.managePlugin(baseTypedPackage, report);
            } else {
                this.logger.debug((Object)"nothing to manage for this package");
            }
            baseTypedPackage.notifiyTargetsAdded(baseTypedPackage.getTargetsToAdd());
        }
        if (report != null) {
            report.close();
            try {
                report.send();
                this.resource.clearLastDeployment();
                report.delete();
            }
            catch (Exception e) {
                this.logger.warn((Object)"Unable to sent the last deployment report ", (Throwable)e);
            }
        }
    }

    private void completeGHNProfile() throws Exception {
        HashSet<GCUBEHostingNode.Package> ghnPackages = new HashSet<GCUBEHostingNode.Package>();
        ghnPackages.addAll(GHNContext.getContext().getGHN().getDeployedPackages());
        this.logger.trace((Object)("# of packages found in the GHN profile " + GHNContext.getContext().getGHN().getDeployedPackages().size()));
        if (ghnPackages.size() > 0 && !GHNContext.getContext().getGHN().getDeployedPackages().removeAll(ghnPackages)) {
            throw new Exception("unable to clean up the GHN profile's package list");
        }
        block0: for (GCUBEServiceContext s : GHNContext.getContext().getServiceContexts()) {
            List packages = s.getService().getPackages();
            for (Package servicePackage : packages) {
                if (!MainPackage.class.isAssignableFrom(servicePackage.getClass()) || this.contains(ghnPackages, servicePackage, s)) continue;
                this.logger.trace((Object)("Adding package " + servicePackage.getName()));
                GCUBEHostingNode.Package ghnP = new GCUBEHostingNode.Package();
                ghnP.setPackageName(servicePackage.getName());
                ghnP.setPackageVersion(servicePackage.getVersion());
                ghnP.setServiceClass(s.getService().getServiceClass());
                ghnP.setServiceName(s.getService().getServiceName());
                ghnP.setServiceVersion(s.getService().getVersion());
                ghnPackages.add(ghnP);
                for (Dependency dep : servicePackage.getDependencies()) {
                    if (dep.getScope() != Package.ScopeLevel.GHN || dep.getOptional().booleanValue() || this.contains(ghnPackages, dep)) continue;
                    this.logger.trace((Object)("Adding package " + dep.getPackage()));
                    GCUBEHostingNode.Package depP = new GCUBEHostingNode.Package();
                    depP.setPackageName(dep.getPackage());
                    depP.setPackageVersion(dep.getVersion());
                    depP.setServiceClass(dep.getService().getClazz());
                    depP.setServiceName(dep.getService().getName());
                    if (dep.getService().getVersion() == null || dep.getService().getVersion().compareToIgnoreCase("") == 0) {
                        depP.setServiceVersion("");
                    } else {
                        depP.setServiceVersion(dep.getService().getVersion());
                    }
                    ghnPackages.add(depP);
                }
                continue block0;
            }
        }
        GHNContext.getContext().getGHN().getDeployedPackages().removeAll(GHNContext.getContext().getGHN().getDeployedPackages());
        GHNContext.getContext().getGHN().getDeployedPackages().addAll(ghnPackages);
        this.logger.debug((Object)("GHNProfile completed: # of packages in the GHN profile " + GHNContext.getContext().getGHN().getDeployedPackages().size()));
        GHNConsumer ghnconsumer = new GHNConsumer(){

            protected synchronized void onRIRegistration(Events.GHNRIRegistrationEvent event) {
                try {
                    ((GCUBEServiceContext)event.getPayload()).getInstance().subscribeResourceEvents((GCUBEResource.ResourceConsumer)new RIConsumer(((GCUBEServiceContext)event.getPayload()).getService(), HDeployerCompleteGHNState.this.resource), new GCUBEResource.ResourceTopic[]{GCUBEResource.ResourceTopic.ADDSCOPE, GCUBEResource.ResourceTopic.REMOVESCOPE});
                }
                catch (Exception e) {
                    HDeployerCompleteGHNState.this.logger.error((Object)"Deployer was unable to subscribe to other RI events", (Throwable)e);
                }
            }
        };
        this.logger.info((Object)"registering for GHNTopic.RIREGISTRATION events");
        GHNContext.getContext().subscribeGHNEvents(ghnconsumer, new Events.GHNTopic[]{Events.GHNTopic.RIREGISTRATION});
    }

    private boolean contains(Set<GCUBEHostingNode.Package> ghnPackages, Dependency dep) {
        if (ghnPackages == null) {
            return false;
        }
        for (GCUBEHostingNode.Package ghnPackage : ghnPackages) {
            if (ghnPackage.getPackageName().compareToIgnoreCase(dep.getPackage()) != 0 || ghnPackage.getServiceClass().compareToIgnoreCase(dep.getService().getClazz()) != 0 || ghnPackage.getServiceName().compareToIgnoreCase(dep.getService().getName()) != 0 || ghnPackage.getServiceVersion().compareToIgnoreCase(dep.getService().getVersion()) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Set<GCUBEHostingNode.Package> ghnPackages, Package servicePackage, GCUBEServiceContext s) {
        if (ghnPackages == null) {
            return false;
        }
        for (GCUBEHostingNode.Package ghnPackage : ghnPackages) {
            if (ghnPackage.getPackageName().compareToIgnoreCase(servicePackage.getName()) != 0 || ghnPackage.getServiceClass().compareToIgnoreCase(s.getService().getServiceClass()) != 0 || ghnPackage.getServiceName().compareToIgnoreCase(s.getService().getServiceName()) != 0 || ghnPackage.getServiceVersion().compareToIgnoreCase(s.getService().getVersion()) != 0) continue;
            return true;
        }
        return false;
    }

    private void manageMainPackage(BaseTypedPackage p, Report report) {
        try {
            GHNContext.getContext().getServiceContext(p.getKey().getServiceClass(), p.getKey().getServiceName());
        }
        catch (Exception e) {
            this.logger.warn((Object)"the service is not registered in the GHN");
            report.updatePackageStatus(Converter.toPackageInfo(p), Report.PACKAGESTATUS.FAILED, "The service did not start properly");
        }
        this.logger.debug((Object)"the service is registered in the GHN");
        report.updatePackageStatus(Converter.toPackageInfo(p), Report.PACKAGESTATUS.RUNNING, new String[0]);
    }

    private void managePlugin(BaseTypedPackage p, Report report) {
        GCUBEServiceContext service = null;
        try {
            service = GHNContext.getContext().getServiceContext(p.getProperty("Class"), p.getProperty("Name"));
        }
        catch (Exception e) {
            this.logger.debug((Object)"the plugin's target service is not registered in the GHN...");
            report.updatePackageStatus(Converter.toPackageInfo(p), Report.PACKAGESTATUS.FAILED, "The plugin cannot be registerd: the target service (" + p.getProperty("Class") + "," + p.getProperty("Name") + ") is not available");
            return;
        }
        try {
            this.logger.debug((Object)"the plugin's target service is registered in the GHN...");
            GCUBEService pluginProfile = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
            pluginProfile.load((Reader)new StringReader(p.getProperty("SerializedProfile")));
            GCUBEPluginManager manager = service.getPluginManager();
            manager.registerPlugin(pluginProfile, new boolean[0]);
            report.updatePackageStatus(Converter.toPackageInfo(p), Report.PACKAGESTATUS.REGISTERED, new String[0]);
        }
        catch (GCUBEPluginManager.PluginAlreadyRegisteredException e) {
            this.logger.warn((Object)"Unable to register the plugin: plugin already registered", (Throwable)e);
            report.updatePackageStatus(Converter.toPackageInfo(p), Report.PACKAGESTATUS.ALREADYREGISTERED, e.getMessage());
        }
        catch (Exception e) {
            this.logger.warn((Object)"Unable to register the plugin", (Throwable)e);
            report.updatePackageStatus(Converter.toPackageInfo(p), Report.PACKAGESTATUS.FAILED, "The plugin's activation cannot be managed");
        }
    }
}

