/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.handlers.GCUBEHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.operators.DeployerOperator;
import org.gcube.common.vremanagement.deployer.impl.operators.common.Report;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.ExternalPackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.PackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;
import org.gcube.common.vremanagement.deployer.impl.state.DeployerResource;
import org.gcube.common.vremanagement.deployer.stubs.common.PackageInfo;
import org.gcube.common.vremanagement.deployer.stubs.deployer.UpdateParameters;

public class UpdateOperator
extends GCUBEHandler<GCUBEHandler<?>> {
    protected final GCUBELog logger = new GCUBELog(UpdateOperator.class);
    private UpdateParameters params;
    private boolean rollback = false;
    private GCUBEScope callerScope = null;
    private DeployerResource resource = null;

    public UpdateOperator(DeployerResource deployerResource, UpdateParameters params, GCUBEScope callerScope) {
        this.params = params;
        this.resource = deployerResource;
    }

    public void run() throws Exception {
        PackageInfo[] packages = this.params.get_package();
        DeployerOperator.deployLock.lock();
        Report finalreport = new Report(this.params.getEndpointReference(), this.params.getCallbackID(), packages.length, Report.TYPE.DEPLOY, this.callerScope);
        this.resource.setLastDeployment(this.params.getCallbackID());
        for (int i = 0; i < packages.length; ++i) {
            PackageInfo deployable_package = packages[i];
            finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.WAITING, i, new String[0]);
        }
        boolean restart = false;
        for (int i = 0; i < packages.length; ++i) {
            PackageInfo deployable_package = packages[i];
            this.logger.info((Object)("updating the package " + deployable_package.getName() + "... "));
            if (this.rollback) {
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.SKIPPED, i, new String[0]);
                this.logger.warn((Object)("the package " + deployable_package.getName() + " could not be updated due to a previous error in another package"));
                continue;
            }
            try {
                this.logger.debug((Object)("initialising the downloader for package " + deployable_package.getName() + "... "));
                Downloader manager = new Downloader(deployable_package, true);
                manager.downloadPackage(new GCUBEScope[0]);
                Deployable pack = null;
                if (manager.getPackagetype() == Downloader.PackageType.SERVICEARCHIVE) {
                    pack = new PackageExtractor(manager).getPackage();
                } else if (manager.getPackagetype() == Downloader.PackageType.JAR) {
                    pack = new ExternalPackageExtractor(manager).getPackage();
                }
                if (pack != null) {
                    pack.deploy(null);
                    finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.UPDATED, i, new String[0]);
                    this.logger.info((Object)("the package " + deployable_package.getName() + " has been successfully updated"));
                    if (!pack.requireRestart()) continue;
                    restart = true;
                    continue;
                }
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.FAILED, i, new String[0]);
                this.logger.warn((Object)("the package " + deployable_package.getName() + " has NOT been successfully updated"));
                this.rollback = true;
                continue;
            }
            catch (Exception e) {
                this.logger.warn((Object)("the package " + deployable_package.getName() + " has NOT been successfully updated"), (Throwable)e);
                finalreport.addPackage(deployable_package, Report.PACKAGESTATUS.FAILED, i, new String[0]);
                this.rollback = true;
            }
        }
        if (this.rollback) {
            this.rollback();
        }
        if (restart) {
            finalreport.send();
            finalreport.save();
            GHNContext.getContext().restart(new String[0]);
        } else {
            finalreport.close();
            finalreport.send();
            finalreport.save();
        }
        DeployerOperator.deployLock.unlock();
    }

    private void rollback() {
    }
}

