/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vremanagement.deployer.impl.contexts.ServiceContext;
import org.gcube.common.vremanagement.deployer.impl.resources.KeyData;

public class BasePackage
implements Serializable {
    public transient GCUBELog logger;
    private static final long serialVersionUID = 8475576257671061501L;
    private Set<String> scopes = new HashSet<String>();
    private Set<String> scopesToAdd = new HashSet<String>();
    protected List<File> packageFiles = new ArrayList<File>();
    protected List<String> installScripts = new ArrayList<String>();
    protected List<String> rebootScripts = new ArrayList<String>();
    protected List<String> uninstallScripts = new ArrayList<String>();
    protected Set<KeyData> dependencies = new HashSet<KeyData>();
    protected KeyData key;
    protected Map<String, String> properties = new HashMap<String, String>();
    protected ArrayList<String> targetsToAdd = new ArrayList();

    protected BasePackage() {
    }

    public BasePackage(String serviceClass, String serviceName, String serviceVersion, String packagename, String packageVersion) {
        this.key = new KeyData(serviceClass, serviceName, serviceVersion, packagename, packageVersion);
        this.logger = new GCUBELog(BasePackage.class);
    }

    public KeyData getKey() {
        return this.key;
    }

    public File getSerializationFile() {
        return ServiceContext.getContext().getPersistentFile(this.buildSerializationFilePath(), new boolean[]{true});
    }

    private String buildSerializationFilePath() {
        return this.getKey().getServiceClass() + File.separator + this.getKey().getServiceClass() + File.separator + this.getKey().getServiceClass() + File.separator + this.getKey().getServiceName() + File.separator + this.getKey().getServiceVersion() + File.separator + "package_profile.xml";
    }

    public List<File> getPackageFileList() {
        return this.packageFiles;
    }

    public void addFile2Package(File file) {
        this.packageFiles.add(file);
    }

    public void removeFileFromPackage(File file) {
        this.packageFiles.remove(file);
    }

    public void printFiles() {
        if (this.getPackageFileList().size() == 0) {
            return;
        }
        this.logger.debug((Object)"The files belonging the package are:");
        for (File file : this.getPackageFileList()) {
            this.logger.debug((Object)file.getAbsolutePath());
        }
    }

    public List<String> getInstallScripts() {
        return this.installScripts;
    }

    public void addInstallScript(String installScript) {
        this.installScripts.add(installScript);
    }

    public List<String> getRebootScripts() {
        return this.rebootScripts;
    }

    public void addRebootScript(String rebootScript) {
        this.rebootScripts.add(rebootScript);
    }

    public List<String> getUninstallScripts() {
        return this.uninstallScripts;
    }

    public void addUninstallScript(String uninstallScript) {
        this.uninstallScripts.add(uninstallScript);
    }

    public Set<GCUBEScope> getScopes() {
        HashSet<GCUBEScope> retScope = new HashSet<GCUBEScope>();
        for (String scope : this.scopes) {
            retScope.add(GCUBEScope.getScope((String)scope));
        }
        return retScope;
    }

    public void setScopes(Set<GCUBEScope> scopes) {
        for (GCUBEScope scope : scopes) {
            this.scopes.add(scope.toString());
        }
    }

    public void addScope(GCUBEScope scope) {
        this.scopes.add(scope.toString());
    }

    public void removeScope(GCUBEScope scope) {
        this.scopes.remove(scope.toString());
    }

    public void removeScopes(Set<GCUBEScope> scopes) {
        for (GCUBEScope scope : scopes) {
            this.scopes.remove(scope.toString());
        }
    }

    public Set<GCUBEScope> getScopesToAdd() {
        HashSet<GCUBEScope> retScope = new HashSet<GCUBEScope>();
        for (String scope : this.scopesToAdd) {
            retScope.add(GCUBEScope.getScope((String)scope));
        }
        return retScope;
    }

    public void setScopesToAdd(Set<GCUBEScope> scopesToAdd) {
        for (GCUBEScope scope : scopesToAdd) {
            this.scopesToAdd.add(scope.toString());
        }
    }

    public Set<KeyData> getDependencies() {
        return this.dependencies;
    }

    public void addDependencies(Set<KeyData> dependencies) {
        this.dependencies.addAll(dependencies);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        return "BasePackage [key=" + this.key + "]";
    }

    public PlatformDescription getTargetPlatform() {
        if (!this.properties.containsKey("PlatformName")) {
            this.logger.warn((Object)("No platform information available for the package " + this.getKey()));
            return null;
        }
        PlatformDescription desc = new PlatformDescription();
        desc.setName(this.getProperty("PlatformName"));
        if (this.properties.containsKey("PlatformVersion")) {
            desc.setVersion(Short.valueOf(this.getProperty("PlatformVersion")).shortValue());
        }
        if (this.properties.containsKey("PlatformMinorVersion")) {
            desc.setMinorVersion(Short.valueOf(this.getProperty("PlatformMinorVersion")).shortValue());
        }
        return desc;
    }

    public void setTargetPlatform(PlatformDescription description) {
        this.setProperty("PlatformName", description.getName());
        this.setProperty("PlatformVersion", String.valueOf(description.getVersion()));
        this.setProperty("PlatformMinorVersion", String.valueOf(description.getMinorVersion()));
    }

    public final List<GCUBEScope> getTargetsToAdd() {
        ArrayList<GCUBEScope> ret = new ArrayList<GCUBEScope>();
        for (String scope : this.targetsToAdd) {
            ret.add(GCUBEScope.getScope((String)scope));
        }
        return ret;
    }

    public final void setTargetsToAdd(List<GCUBEScope> targetsToAdd) {
        for (GCUBEScope scope : targetsToAdd) {
            this.targetsToAdd.add(scope.toString());
        }
    }

    public final void notifiyTargetsAdded(List<GCUBEScope> targets) {
        for (GCUBEScope scope : targets) {
            this.targetsToAdd.remove(scope.toString());
        }
    }
}

