/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.resources.deployment;

import java.util.HashMap;
import java.util.Set;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntRunner;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.ExternalPackageExtractor;
import org.gcube.common.vremanagement.deployer.impl.resources.BaseTypedPackage;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;

public abstract class ExternalDeployablePackage
extends BaseTypedPackage
implements Deployable {
    private static final long serialVersionUID = -3579799875441746995L;
    protected transient AntRunner run;
    protected transient ExternalPackageExtractor extractor;

    ExternalDeployablePackage(ExternalPackageExtractor extractor) throws Exception {
        super(extractor.getServiceClass(), extractor.getServiceName(), extractor.getServiceVersion(), extractor.getName(), extractor.getVersion());
        this.logger.debug((Object)("ExternalDeployablePackage created for: " + this.getKey()));
        this.extractor = extractor;
        this.setType(BaseTypedPackage.TYPE.EXTERNAL);
        try {
            this.run = new AntRunner();
            this.run.init(Configuration.DEPLOYFILE, Configuration.BASEDIR);
        }
        catch (Exception e) {
            this.logger.error((Object)("Package deployer is unable to initialize the deployment environment for " + this.extractor.getName()), (Throwable)e);
            throw new Exception("Package deployer is unable to initialize the deployment environment for " + this.extractor.getName());
        }
    }

    @Override
    public boolean verify() throws InvalidPackageArchiveException {
        return true;
    }

    @Override
    public void preDeploy() throws InvalidPackageArchiveException, DeployException {
    }

    @Override
    public void postDeploy() throws InvalidPackageArchiveException, DeployException {
    }

    @Override
    public void clean() throws DeployException {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("package.source.dir", Configuration.BASESOURCEDIR);
            properties.put("base.deploy.dir", Configuration.BASEDEPLOYDIR);
            this.run.setProperties(properties, true);
            this.run.runTarget("deleteTempFiles");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException("Unable to cleanup the package " + this.key.getPackageName() + ": " + aie.getMessage());
        }
    }

    @Override
    public boolean requireRestart() {
        return false;
    }

    @Override
    public BaseTypedPackage getSourcePackage() {
        return this;
    }

    @Override
    public final void deploy(Set<GCUBEScope> targets) throws DeployException, InvalidPackageArchiveException {
        this.preDeploy();
        this.deployPackage(targets);
        this.setScopes(targets);
        this.postDeploy();
    }

    public abstract void deployPackage(Set<GCUBEScope> var1) throws DeployException, InvalidPackageArchiveException;
}

