/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.deployment;

import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import java.util.HashMap;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBEService;
import org.gcube.common.core.resources.service.Package;
import org.gcube.common.vremanagement.deployer.impl.contexts.Configuration;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.DeployException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.InvalidPackageArchiveException;
import org.gcube.common.vremanagement.deployer.impl.operators.common.PackageFinder;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.BaseExtractor;
import org.gcube.common.vremanagement.deployer.impl.operators.deployment.Downloader;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.Deployable;
import org.gcube.common.vremanagement.deployer.impl.resources.deployment.DeployablePackageFactory;

public class PackageExtractor
extends BaseExtractor {
    protected String serviceprofileFullPath = "";
    protected GCUBEService serviceProfile;
    protected Package packageprofile;
    protected String serviceprofileFileName = "";

    public PackageExtractor(Downloader downloader) throws Exception {
        super(downloader);
        this.manageDownloadedFile();
        this.extractProfile();
    }

    private void manageDownloadedFile() throws DeployException, InvalidPackageArchiveException {
        this.logger.trace((Object)"Uncompressing the package...");
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("package.name", this.downloader.packagename);
            properties.put("package.file", this.getDownloadedFile().getName());
            properties.put("package.source.dir", Configuration.BASESOURCEDIR);
            properties.put("base.deploy.dir", Configuration.BASEDEPLOYDIR);
            properties.put("service.id", this.getServiceKey());
            this.run.setProperties(properties, true);
            this.run.runTarget("uncompressPackage");
        }
        catch (AntInterfaceException aie) {
            throw new DeployException("Unable to uncompress package " + this.downloader.packagename + ": " + aie.getMessage());
        }
        catch (Exception e) {
            throw new InvalidPackageArchiveException("Unable to load the Service Profile from the package tarball for " + this.downloader.packagename + ": " + e.getMessage());
        }
    }

    private void extractProfile() throws InvalidPackageArchiveException {
        this.logger.debug((Object)("Looking for service profile in " + this.downloader.packagedir));
        File dir = new File(this.downloader.packagedir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contentEquals("profile.xml");
            }
        };
        String[] children = dir.list(filter);
        if (children.length == 0) {
            throw new InvalidPackageArchiveException("unable to locate the Service Profile in the package tarball");
        }
        try {
            this.serviceProfile = (GCUBEService)GHNContext.getImplementation(GCUBEService.class);
        }
        catch (Exception e) {
            this.logger.error((Object)"Unable to get the GCUBEService class", (Throwable)e);
            throw new RuntimeException("Unable to get the GCUBEService class");
        }
        for (int i = 0; i < children.length; ++i) {
            try {
                this.serviceProfile.load((Reader)new FileReader(this.downloader.packagedir + File.separator + children[i]));
                this.serviceprofileFileName = children[i];
                this.serviceprofileFullPath = this.downloader.packagedir + File.separator + children[i];
                this.downloader.serviceID = this.serviceProfile.getID();
                continue;
            }
            catch (Exception e) {
                this.logger.warn((Object)("unable to load the service profile from " + children[i]));
                this.logger.trace((Object)"failed because of: ", (Throwable)e);
            }
        }
        if (this.serviceProfile == null) {
            throw new InvalidPackageArchiveException("unable to load the service profile");
        }
    }

    public String getServiceProfileFileName() {
        return this.serviceprofileFileName;
    }

    public String getServiceProfileFullPath() {
        return this.serviceprofileFullPath;
    }

    public GCUBEService getServiceProfile() {
        return this.serviceProfile;
    }

    @Override
    public Deployable getPackage() throws InvalidPackageArchiveException, Exception {
        this.packageprofile = PackageFinder.getPackageDescription(this.getServiceProfile(), this.downloader.packagename, this.downloader.packageVersion);
        Deployable returned = DeployablePackageFactory.createDeployablePackageFromProfile(this.packageprofile, this);
        if (returned == null) {
            throw new InvalidPackageArchiveException();
        }
        return returned;
    }
}

