/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.check;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.gcube.accounting.analytics.Filter;
import org.gcube.resource.management.quota.library.quotalist.TimeInterval;
import org.gcube.resource.management.quota.library.status.QuotaStorageStatus;
import org.gcube.resource.management.quota.manager.util.Constants;
import org.gcube.resource.management.quota.manager.util.DiscoveryConfiguration;
import org.gcube.resource.management.quota.manager.util.DiscoveryListUser;
import org.gcube.resource.management.quota.manager.util.QuotaUsageServiceValue;
import org.gcube.resource.management.quota.manager.util.QuotaUsageStorageValue;
import org.gcube.resource.management.quota.manager.util.SendNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuotaUsage {
    private static Logger log = LoggerFactory.getLogger(QuotaUsage.class);
    private DiscoveryConfiguration discoveryCheck;
    private SendNotification sendNotification;
    public List<String> userExceedQuota = new ArrayList();

    public QuotaUsage(DiscoveryConfiguration discoveryCheck) {
        this.discoveryCheck = discoveryCheck;
        this.sendNotification = new SendNotification(discoveryCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertServiceQuota(QuotaUsageServiceValue usageSerVal) throws Exception {
        String context_label = usageSerVal.getContext().replace('/', '_').toUpperCase();
        Statement stmt = null;
        try (Connection connection = this.getDBConnection();){
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            String periodQuota = usageSerVal.getTemporalConstraint().getAggregationMode().toString();
            if (!this.verifyTable(connection, "quotausage_service_" + context_label + "_" + periodQuota).booleanValue()) {
                String queryCreate = "CREATE TABLE quotausage_service_" + context_label + "_" + periodQuota + "(CALLERTYPE varchar(255),IDENTIFIER varchar(255) ,SERVICE varchar(255),ACCESSTYPE varchar(50),QUOTAASSIGNED DOUBLE PRECISION, QUOTAUSAGE DOUBLE PRECISION,POLICY integer,primary key(CALLERTYPE,IDENTIFIER,SERVICE))";
                stmt.execute(queryCreate);
            }
            String serviceIdentifier = "";
            for (Filter tmp : usageSerVal.getFilters()) {
                serviceIdentifier = serviceIdentifier + tmp.getValue() + ":";
            }
            serviceIdentifier = serviceIdentifier + "0";
            String queryVerify = "SELECT count(*) FROM quotausage_storage_" + periodQuota + " WHERE IDENTIFIER ='" + usageSerVal.getIdentifier() + "'";
            ResultSet rs = stmt.executeQuery(queryVerify);
            rs.next();
            String queryInsert = rs.getInt(1) == 0 ? "INSERT into quotausage_service_" + context_label + "_" + periodQuota + " (CALLERTYPE,IDENTIFIER, SERVICE,ACCESSTYPE,QUOTAASSIGNED, QUOTAUSAGE)  VALUES('" + usageSerVal.getCallerType() + "','" + usageSerVal.getIdentifier() + "','" + serviceIdentifier + "','" + usageSerVal.getAccessType() + "'," + usageSerVal.getdQuota() + "," + usageSerVal.getD() + ")" : "UPDATE quotausage_service_" + context_label + "_" + periodQuota + "SET ACCESSTYPE='" + usageSerVal.getAccessType() + "' ,QUOTAASSIGNED=" + usageSerVal.getdQuota() + " ,QUOTAUSAGE=" + usageSerVal.getD() + "WHERE CALLERTYPE='" + usageSerVal.getCallerType() + "' AND IDENTIFIER='" + usageSerVal.getIdentifier() + "' AND SERVICE='" + serviceIdentifier + "'";
            log.debug("Insert data into table:{}", (Object)queryInsert);
            stmt.execute(queryInsert);
            stmt.close();
            connection.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertStorageQuota(QuotaUsageStorageValue usageStorVal) throws Exception {
        Statement stmt = null;
        try (Connection connection = this.getDBConnection();){
            Boolean notificationWarning1 = false;
            Boolean notificationWarning2 = false;
            Boolean notificationExceed = false;
            Double quotaAssignedOld = 0.0;
            log.debug("quota consistent value getOrderingProperty :{}", (Object)usageStorVal.getOrderingProperty());
            if (usageStorVal.getOrderingProperty() != null) {
                connection.setAutoCommit(false);
                stmt = connection.createStatement();
                String periodQuota = "total";
                if (usageStorVal.getTemporalConstraint() != null) {
                    periodQuota = usageStorVal.getTemporalConstraint().getAggregationMode().toString();
                }
                if (!this.verifyTable(connection, "quotausage_storage_" + periodQuota).booleanValue()) {
                    String queryCreate = "CREATE TABLE quotausage_storage_" + periodQuota + "(IDENTIFIER varchar(255) primary key,QUOTAASSIGNED DOUBLE PRECISION, QUOTAUSAGE DOUBLE PRECISION, NOTIFICATIONWARNING1 boolean default false,NOTIFICATIONWARNING2 boolean default false,NOTIFICATIONEXCEED boolean default false)";
                    log.debug("Create table:{}", (Object)queryCreate);
                    stmt.execute(queryCreate);
                }
                Double percent = usageStorVal.getD() / usageStorVal.getdQuota() * 100.0;
                percent = (double)Math.round(percent * 100.0) / 100.0;
                log.debug("Quota Percent quota:{} used:{} percent:{}", new Object[]{usageStorVal.getdQuota(), usageStorVal.getD(), percent});
                String queryVerify = "SELECT NOTIFICATIONWARNING1,NOTIFICATIONWARNING2,NOTIFICATIONEXCEED,QUOTAASSIGNED FROM quotausage_storage_" + periodQuota + " WHERE IDENTIFIER ='" + usageStorVal.getIdentifier() + "'";
                ResultSet rs = stmt.executeQuery(queryVerify);
                while (rs.next()) {
                    notificationWarning1 = rs.getBoolean("NOTIFICATIONWARNING1");
                    notificationWarning2 = rs.getBoolean("NOTIFICATIONWARNING2");
                    notificationExceed = rs.getBoolean("NOTIFICATIONEXCEED");
                    quotaAssignedOld = rs.getDouble("QUOTAASSIGNED");
                }
                if (!quotaAssignedOld.equals(usageStorVal.getdQuota())) {
                    log.debug("quota changed old value:{} new value:{}", (Object)quotaAssignedOld, (Object)usageStorVal.getdQuota());
                    if (!quotaAssignedOld.equals(0.0)) {
                        log.debug("your old quota is consistent:{}", (Object)quotaAssignedOld);
                        this.sendNotification.sendNotificationUser(usageStorVal.getIdentifier(), usageStorVal.getdQuota(), usageStorVal.getD(), percent, "change");
                    }
                }
                if (!usageStorVal.getdQuota().equals(-1)) {
                    if (percent > (double)Constants.LIMIT_MSG_QUOTA_PERC_USAGE_1.intValue() && percent < (double)Constants.LIMIT_MSG_QUOTA_PERC_USAGE_2.intValue()) {
                        if (!notificationWarning1.booleanValue() && this.sendNotification.sendNotificationUser(usageStorVal.getIdentifier(), usageStorVal.getdQuota(), usageStorVal.getD(), percent, "warning")) {
                            log.debug("notification Send! warning level1");
                            notificationWarning1 = true;
                            notificationWarning2 = false;
                            notificationExceed = false;
                        }
                    } else if (percent > (double)Constants.LIMIT_MSG_QUOTA_PERC_USAGE_2.intValue() && percent < 100.0) {
                        if (!notificationWarning2.booleanValue() && this.sendNotification.sendNotificationUser(usageStorVal.getIdentifier(), usageStorVal.getdQuota(), usageStorVal.getD(), percent, "warning")) {
                            log.debug("notification Send! warning level2");
                            notificationWarning2 = true;
                            notificationExceed = false;
                        }
                    } else if (percent >= 100.0) {
                        log.debug("Quota exceed for:{} identifier:{} notification:{} ", new Object[]{percent, usageStorVal.getIdentifier(), notificationExceed});
                        if (!notificationExceed.booleanValue()) {
                            if (this.sendNotification.sendNotificationUser(usageStorVal.getIdentifier(), usageStorVal.getdQuota(), usageStorVal.getD(), percent, "exceed")) {
                                log.debug("notification Send! warning level3");
                                notificationExceed = true;
                            }
                            String fullname = DiscoveryListUser.getMapUser((String)usageStorVal.getIdentifier());
                            String msgName = fullname + " (" + usageStorVal.getIdentifier() + ") - storage space used: " + percent + "%";
                            this.userExceedQuota.add(msgName);
                        }
                    } else if (notificationWarning1.booleanValue() || notificationWarning2.booleanValue() || notificationExceed.booleanValue()) {
                        log.debug("---Quota reset for identifier:{} and usage :{} and quota:{}", new Object[]{usageStorVal.getIdentifier(), usageStorVal.getdQuota(), usageStorVal.getD()});
                        log.debug("---Quota reset for notificationWarning1:{} and notificationWarning2 :{} and notificationExceed:{}", new Object[]{notificationWarning1, notificationWarning2, notificationExceed});
                        if (this.sendNotification.sendNotificationUser(usageStorVal.getIdentifier(), usageStorVal.getdQuota(), usageStorVal.getD(), percent, "reset")) {
                            log.debug("reset notification Send!");
                            notificationWarning1 = false;
                            notificationWarning2 = false;
                            notificationExceed = false;
                        }
                    }
                } else {
                    log.debug("quote infinite for identifier:{}", (Object)usageStorVal.getIdentifier());
                }
                queryVerify = "SELECT count(*) FROM quotausage_storage_" + periodQuota + " WHERE IDENTIFIER ='" + usageStorVal.getIdentifier() + "'";
                rs = stmt.executeQuery(queryVerify);
                rs.next();
                String queryInsert = rs.getInt(1) == 0 ? "INSERT into quotausage_storage_" + periodQuota + " (IDENTIFIER, QUOTAASSIGNED, QUOTAUSAGE,NOTIFICATIONWARNING1,NOTIFICATIONWARNING2,NOTIFICATIONEXCEED)  VALUES('" + usageStorVal.getIdentifier() + "'," + usageStorVal.getdQuota() + "," + usageStorVal.getD() + "," + notificationWarning1 + "," + notificationWarning2 + "," + notificationExceed + ")" : "UPDATE quotausage_storage_" + periodQuota + " set QUOTAASSIGNED=" + usageStorVal.getdQuota() + ",QUOTAUSAGE=" + usageStorVal.getD() + " ,NOTIFICATIONEXCEED=" + notificationExceed + " ,NOTIFICATIONWARNING1=" + notificationWarning1 + ",NOTIFICATIONWARNING2=" + notificationWarning2 + " where IDENTIFIER='" + usageStorVal.getIdentifier() + "'";
                log.debug("Insert data into table:{}", (Object)queryInsert);
                stmt.execute(queryInsert);
                stmt.close();
                connection.commit();
            }
        }
    }

    public void SendNotificationAdmin() {
        try {
            log.debug("Send Notification to Admin");
            this.sendNotification.SendNotificationAdmin(this.userExceedQuota);
            this.userExceedQuota.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QuotaStorageStatus selectStorageQuota(String identifier, TimeInterval interval) throws Exception {
        Connection connection = this.getDBConnection();
        QuotaStorageStatus quotaStorageStatus = null;
        Statement stmt = null;
        try {
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            String periodQuota = "total";
            Double quotaAssigned = 0.0;
            Double quotaUsage = 0.0;
            if (interval.equals((Object)TimeInterval.FOREVER)) {
                String query = "SELECT * FROM quotausage_storage_" + periodQuota + " WHERE IDENTIFIER='" + identifier + "'";
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    quotaAssigned = rs.getDouble("QUOTAASSIGNED");
                    quotaUsage = rs.getDouble("QUOTAUSAGE");
                }
            }
            stmt.close();
            connection.commit();
            quotaStorageStatus = new QuotaStorageStatus(identifier, interval, quotaAssigned, quotaUsage);
        }
        catch (SQLException e) {
            log.error("Sql error  Message " + e);
        }
        catch (Exception e) {
            log.error("Exception error  Message " + e);
        }
        finally {
            connection.close();
        }
        return quotaStorageStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QuotaStorageStatus> selectStorageQuotaList(TimeInterval interval) throws Exception {
        Connection connection = this.getDBConnection();
        ArrayList<QuotaStorageStatus> quotaStorageStatusList = new ArrayList<QuotaStorageStatus>();
        Statement stmt = null;
        try {
            connection.setAutoCommit(false);
            stmt = connection.createStatement();
            String periodQuota = "total";
            Double quotaAssigned = 0.0;
            Double quotaUsage = 0.0;
            if (interval.equals((Object)TimeInterval.FOREVER)) {
                String query = "SELECT * FROM quotausage_storage_" + periodQuota + " order by QUOTAUSAGE DESC";
                ResultSet rs = stmt.executeQuery(query);
                while (rs.next()) {
                    quotaAssigned = rs.getDouble("QUOTAASSIGNED");
                    quotaUsage = rs.getDouble("QUOTAUSAGE");
                    String identifier = rs.getString("IDENTIFIER");
                    quotaStorageStatusList.add(new QuotaStorageStatus(identifier, interval, quotaAssigned, quotaUsage));
                }
            }
            stmt.close();
            connection.commit();
        }
        catch (SQLException e) {
            log.error("Sql error  Message " + e);
        }
        catch (Exception e) {
            log.error("Exception error  Message " + e);
        }
        finally {
            connection.close();
        }
        return quotaStorageStatusList;
    }

    private Boolean verifyTable(Connection connection, String tableName) throws SQLException {
        boolean tExists = false;
        DatabaseMetaData dbm = connection.getMetaData();
        ResultSet tables = dbm.getTables(null, null, tableName, null);
        if (tables.next()) {
            tExists = true;
        }
        log.trace("verifyTable :{} result:{}", (Object)tableName, (Object)tExists);
        return tExists;
    }

    private Connection getDBConnection() {
        Connection dbConnection = null;
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            log.error("error class not found exception", (Throwable)e);
        }
        try {
            String nameConnection = "jdbc:postgresql://" + this.discoveryCheck.getDatabasePath() + "/" + this.discoveryCheck.getDbname();
            dbConnection = DriverManager.getConnection(nameConnection, this.discoveryCheck.getUsernameDb(), this.discoveryCheck.getPwdnameDb());
            return dbConnection;
        }
        catch (SQLException e) {
            log.error("error connecting to db", (Throwable)e);
            return dbConnection;
        }
    }
}

