/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.persistence;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Singleton;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.TypedQuery;
import org.gcube.resource.management.quota.library.quotalist.ServicePackage;
import org.gcube.resource.management.quota.library.quotalist.ServicePackageDetail;
import org.gcube.resource.management.quota.manager.persistence.entities.ServicePackageDetailEntity;
import org.gcube.resource.management.quota.manager.persistence.entities.ServicePackageManagerEntity;
import org.gcuberesource.management.quota.manager.service.exception.NotFoundQuotaPackageExecption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class QuotaPackageDBPersistence {
    private static QuotaPackageDBPersistence instance;
    private static Logger log;
    protected EntityManagerFactory emFactory = Persistence.createEntityManagerFactory((String)"quota_persistence");

    private QuotaPackageDBPersistence() {
    }

    public static synchronized QuotaPackageDBPersistence getInstance() {
        if (instance == null) {
            instance = new QuotaPackageDBPersistence();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(ServicePackage servicePackages) {
        try (EntityManager em = this.emFactory.createEntityManager();){
            ServicePackageManagerEntity servicePackageManager = new ServicePackageManagerEntity(servicePackages.getName());
            em.getTransaction().begin();
            em.persist((Object)servicePackageManager);
            em.flush();
            for (ServicePackageDetail servicePackageDetail : servicePackages.getServicesPackageDetail()) {
                ServicePackageDetailEntity servicePackageDetailEntity = new ServicePackageDetailEntity(servicePackageManager, servicePackageDetail.getContent());
                servicePackageDetailEntity.setServicePackage(servicePackageManager);
                em.persist((Object)servicePackageDetailEntity);
            }
            em.getTransaction().commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServicePackage> getPackages() throws NotFoundQuotaPackageExecption {
        ArrayList<ServicePackage> packagesToReturn;
        block6: {
            packagesToReturn = new ArrayList<ServicePackage>();
            try (EntityManager em = this.emFactory.createEntityManager();){
                TypedQuery query = em.createNamedQuery("ServicePackage.all", ServicePackageManagerEntity.class);
                if (query.getResultList().size() > 0) {
                    for (ServicePackageManagerEntity serEntity : query.getResultList()) {
                        ArrayList<ServicePackageDetail> servicePackageDetaiListl = new ArrayList<ServicePackageDetail>();
                        for (ServicePackageDetailEntity serDetEntity : serEntity.getListdetail()) {
                            ServicePackageDetail servicePackageDetail = new ServicePackageDetail(serDetEntity.getServicePackage().getId(), serDetEntity.getContent());
                            servicePackageDetail.setId(serDetEntity.getId());
                            servicePackageDetaiListl.add(servicePackageDetail);
                        }
                        ServicePackage servicePackage = new ServicePackage(serEntity.getName(), servicePackageDetaiListl);
                        servicePackage.setId(serEntity.getId());
                        packagesToReturn.add(servicePackage);
                    }
                    break block6;
                }
                throw new NotFoundQuotaPackageExecption("No packages found");
            }
        }
        return packagesToReturn;
    }

    public void removePackage(long servicePackageId) {
        EntityManager em = this.emFactory.createEntityManager();
        try {
            em.getTransaction().begin();
            ServicePackageManagerEntity entity = (ServicePackageManagerEntity)em.find(ServicePackageManagerEntity.class, (Object)servicePackageId);
            if (entity != null) {
                em.remove((Object)entity);
            } else {
                log.warn("package with id {} not found", (Object)servicePackageId);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            log.error("error removing package with id {}", (Object)servicePackageId);
            em.close();
        }
    }

    public void removePackageDetail(long servicePackageDetailId) {
        EntityManager em = this.emFactory.createEntityManager();
        try {
            em.getTransaction().begin();
            ServicePackageDetailEntity entity = (ServicePackageDetailEntity)em.find(ServicePackageDetailEntity.class, (Object)servicePackageDetailId);
            if (entity != null) {
                em.remove((Object)entity);
                em.flush();
            } else {
                log.warn("package detail with id {} not found", (Object)servicePackageDetailId);
            }
            em.getTransaction().commit();
        }
        catch (Exception e) {
            log.error("error removing package detail with id {}", (Object)servicePackageDetailId);
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServicePackage getPackage(long servicepackage_id) throws NotFoundQuotaPackageExecption {
        ServicePackage servicePackage;
        block6: {
            servicePackage = null;
            try (EntityManager em = this.emFactory.createEntityManager();){
                TypedQuery query = em.createNamedQuery("ServicePackage.getById", ServicePackageManagerEntity.class);
                query.setParameter("id", (Object)servicepackage_id);
                if (query.getResultList().size() > 0) {
                    for (ServicePackageManagerEntity serEntity : query.getResultList()) {
                        ArrayList<ServicePackageDetail> servicePackageDetaiListl = new ArrayList<ServicePackageDetail>();
                        for (ServicePackageDetailEntity serDetEntity : serEntity.getListdetail()) {
                            ServicePackageDetail servicePackageDetail = new ServicePackageDetail(serDetEntity.getServicePackage().getId(), serDetEntity.getContent());
                            servicePackageDetail.setId(serDetEntity.getId());
                            servicePackageDetaiListl.add(servicePackageDetail);
                        }
                        servicePackage = new ServicePackage(serEntity.getName(), servicePackageDetaiListl);
                        servicePackage.setId(serEntity.getId());
                    }
                    break block6;
                }
                throw new NotFoundQuotaPackageExecption("No packages found");
            }
        }
        return servicePackage;
    }

    static {
        log = LoggerFactory.getLogger(QuotaPackageDBPersistence.class);
    }
}

