/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resource.management.quota.manager.service;

import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.utils.Caller;
import org.gcube.resource.management.quota.library.quotalist.TimeInterval;
import org.gcube.resource.management.quota.library.status.QuotaStorageStatus;
import org.gcube.resource.management.quota.manager.check.MyAppManager;
import org.gcube.resource.management.quota.manager.check.QuotaUsage;
import org.gcube.smartgears.ApplicationManagerProvider;
import org.gcube.smartgears.annotations.ManagedBy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="quotaStatus")
@ManagedBy(value=MyAppManager.class)
public class QuotaStatus {
    private static Logger log = LoggerFactory.getLogger(QuotaStatus.class);
    private MyAppManager appManager = (MyAppManager)ApplicationManagerProvider.get(MyAppManager.class);

    @GET
    @Path(value="/detail/")
    @Produces(value={"application/xml"})
    public QuotaStorageStatus getQuotaStorageStatus(@QueryParam(value="timeinterval") String timeinterval) {
        QuotaStorageStatus quotaStorageStatus;
        Caller caller = AuthorizationProvider.instance.get();
        String identifier = caller.getClient().getId();
        QuotaUsage queryUsage = this.appManager.getQuotaUsage();
        try {
            log.info("retrieving quote for identifier:{} and time:{}", (Object)identifier, (Object)timeinterval);
            quotaStorageStatus = queryUsage.selectStorageQuota(identifier, TimeInterval.valueOf((String)timeinterval));
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error : " + e.getMessage())).type("text/plain").build());
        }
        return quotaStorageStatus;
    }

    @GET
    @Path(value="/list/")
    @Produces(value={"application/xml"})
    public List<QuotaStorageStatus> getQuotaStorageStatusList(@QueryParam(value="timeinterval") String timeinterval) {
        List quotaStorageStatusList;
        QuotaUsage queryUsage = this.appManager.getQuotaUsage();
        try {
            quotaStorageStatusList = queryUsage.selectStorageQuotaList(TimeInterval.valueOf((String)timeinterval));
        }
        catch (Exception e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Error : " + e.getMessage())).type("text/plain").build());
        }
        return quotaStorageStatusList;
    }
}

